/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xmlparser.document;

import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.tinygroup.parser.exception.ParseException;
import org.tinygroup.xmlparser.XmlDocument;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class DocumentTest
extends TestCase {
    XmlDocument doc = null;
    XmlStringParser stringParser = new XmlStringParser();

    protected void setUp() throws Exception {
        super.setUp();
        this.doc = this.stringParser.parse("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><?name pidata?><!DOCTYPE rootElement><!DOCTYPE rootElement SYSTEM \"URIreference\"><!DOCTYPE rootElement PUBLIC \"PublicIdentifier\" \"URIreference\"><!--aa--><!--bb--><root a=c><!-- abc --><![CDATA[aasdf]]><b><c></c></b></root>");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetRoot() {
        DocumentTest.assertNotNull((Object)this.doc.getRoot());
        DocumentTest.assertEquals((String)"root", (String)((XmlNode)this.doc.getRoot()).getNodeName());
    }

    public void testSetRoot() {
        this.doc.setRoot(this.stringParser.parse("<aa><b/></aa>").getRoot());
        DocumentTest.assertEquals((String)"aa", (String)((XmlNode)this.doc.getRoot()).getNodeName());
    }

    public void testGetXmlDeclaration() {
        DocumentTest.assertEquals((String)"1.0", (String)this.doc.getXmlDeclaration().getAttribute("version"));
    }

    public void testGetCommentList() {
        DocumentTest.assertEquals((int)2, (int)this.doc.getCommentList().size());
    }

    public void testGetDoctypeList() {
        DocumentTest.assertEquals((int)3, (int)this.doc.getDoctypeList().size());
    }

    public void testGetProcessingInstructionList() {
        DocumentTest.assertEquals((int)1, (int)this.doc.getProcessingInstructionList().size());
    }

    public void testToString() {
        System.out.println(this.doc.toString());
    }

    public void testTimes() {
        long l1 = System.currentTimeMillis();
        int ti = 10000;
        try {
            for (int i = 0; i < ti; ++i) {
                this.doc = this.stringParser.parse("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><?name pidata?><!DOCTYPE rootElement><!DOCTYPE rootElement SYSTEM \"URIreference\"><!DOCTYPE rootElement PUBLIC \"PublicIdentifier\" \"URIreference\"><!--aa--><!--bb--><root a=c><!-- abc --><![CDATA[aasdf]]><b><c></c></b></root>");
            }
            long l2 = System.currentTimeMillis();
            System.out.println("times:" + (l2 - l1));
            System.out.println("String length:" + (long)(this.doc.toString().length() * ti) / (l2 - l1) * 1000L);
        }
        catch (ParseException e) {
            DocumentTest.fail((String)e.getMessage());
        }
    }

    public void testWrite() {
        try {
            this.doc.write((OutputStream)System.out);
        }
        catch (IOException e) {
            DocumentTest.fail((String)("\u4e0d\u5e94\u8be5\u6709\u5f02\u5e38" + e.getMessage()));
        }
    }
}

