/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xmlparser.ea;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.tinygroup.commons.file.IOUtils;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.FastNameFilter;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.xmlparser.XmlDocument;
import org.tinygroup.xmlparser.ea.BizTypePair;
import org.tinygroup.xmlparser.ea.BusinessType;
import org.tinygroup.xmlparser.ea.BusinessTypes;
import org.tinygroup.xmlparser.ea.DialectType;
import org.tinygroup.xmlparser.ea.Guid;
import org.tinygroup.xmlparser.ea.Placeholder;
import org.tinygroup.xmlparser.ea.PlaceholderValue;
import org.tinygroup.xmlparser.ea.StandardField;
import org.tinygroup.xmlparser.ea.StandardFields;
import org.tinygroup.xmlparser.ea.StandardType;
import org.tinygroup.xmlparser.ea.StandardTypes;
import org.tinygroup.xmlparser.ea.StdfieldPair;
import org.tinygroup.xmlparser.ea.Table;
import org.tinygroup.xmlparser.ea.TableField;
import org.tinygroup.xmlparser.ea.Tables;
import org.tinygroup.xmlparser.ea.XmlParseSerializableUtil;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class MetadataGenerateEA2Table {
    static String packageName = "org.tinygroup.alm";
    Map<String, StandardType> stdTypeMap = new HashMap<String, StandardType>();
    Map<BizTypePair, BusinessType> bizTypesMap = new HashMap<BizTypePair, BusinessType>();
    Map<StdfieldPair, StandardField> stdfieldMap = new HashMap<StdfieldPair, StandardField>();
    static Map<String, HashSet<String>> customTypeMap = new HashMap<String, HashSet<String>>();
    static XmlDocument doc = null;
    static String outputFolder = "c:/out2/";
    static String basePackagePath = "org.tinygroup.alm";

    public static void main(String[] args) throws Exception {
        URL resourceURl = MetadataGenerateEA2Table.class.getResource("/schema.xml");
        XmlStringParser parser = new XmlStringParser();
        doc = parser.parse(IOUtils.readFromInputStream((InputStream)resourceURl.openStream(), (String)"UTF-8"));
        MetadataGenerateEA2Table mg = new MetadataGenerateEA2Table();
        mg.export("Document");
        mg.export("Product");
        mg.export("Project");
        mg.export("Quality");
        mg.export("Report");
        mg.export("Service");
        mg.export("common");
    }

    public void export(String moduleName) throws Exception {
        this.exportModule(moduleName);
        this.exportStdField();
        this.exportBizType();
        this.exportStdType();
    }

    private void exportStdField() throws Exception {
        StandardFields stdfields = new StandardFields();
        if (stdfields.getStandardFieldList() == null) {
            stdfields.setStandardFieldList(new ArrayList<StandardField>());
        }
        stdfields.getStandardFieldList().addAll(this.stdfieldMap.values());
        this.writeFile(stdfields, StandardFields.class, new File(outputFolder + "aaa.stdfield"));
    }

    private void exportBizType() throws Exception {
        BusinessTypes bizTypes = new BusinessTypes();
        if (bizTypes.getBusinessTypeList() == null) {
            bizTypes.setBusinessTypeList(new ArrayList<BusinessType>());
        }
        bizTypes.getBusinessTypeList().addAll(this.bizTypesMap.values());
        this.writeFile(bizTypes, BusinessTypes.class, new File(outputFolder + "aaa.bizdatatype"));
    }

    private void exportStdType() throws Exception {
        StandardTypes stdfields = new StandardTypes();
        if (stdfields.getStandardTypeList() == null) {
            stdfields.setStandardTypeList(new ArrayList<StandardType>());
        }
        stdfields.getStandardTypeList().addAll(this.stdTypeMap.values());
        this.writeFile(stdfields, StandardTypes.class, new File(outputFolder + "aaa.datatype"));
    }

    private void exportModule(String moduleName) throws Exception {
        FastNameFilter fast = new FastNameFilter(doc.getRoot());
        List elementList = fast.findNodeList("element");
        String moduleId = MetadataGenerateEA2Table.getModuleId((XmlNode)doc.getRoot(), moduleName);
        Tables tables = new Tables();
        tables.setId(Guid.createGUID());
        tables.setPackageName(packageName + "." + moduleName.toLowerCase());
        for (XmlNode element : elementList) {
            Table table;
            XmlNode subNode = (XmlNode)element.getSubNode("model");
            if (subNode == null || !subNode.getAttribute("package").equals(moduleId) || (table = this.exportTable(moduleName, (XmlNode)doc.getRoot(), element, outputFolder)) == null) continue;
            tables.getTableList().add(table);
        }
        this.writeFile(tables, Tables.class, new File(outputFolder + moduleName.toLowerCase() + ".table"));
    }

    private void writeFile(Object object, Class cla, File file) {
        XmlParseSerializableUtil.write(object, cla, file);
    }

    private static String getModuleId(XmlNode root, String moduleName) {
        NameFilter filter = new NameFilter((Node)root);
        HashMap<String, String> atts = new HashMap<String, String>();
        atts.put("name", moduleName);
        atts.put("xmi:type", "uml:Package");
        filter.setIncludeAttribute(atts);
        XmlNode node = (XmlNode)filter.findNode("element");
        return node.getAttribute("xmi:idref");
    }

    private Table exportTable(String moduleName, XmlNode root, XmlNode element, String outputFolder) throws Exception {
        XmlNode properties = (XmlNode)element.getSubNode("properties");
        Table table = new Table();
        if (properties != null && properties.getAttribute("stereotype") != null && properties.getAttribute("stereotype").equals("table")) {
            table.setId(Guid.createGUID());
            table.setName(element.getAttribute("name"));
            table.setTitle(properties.getAttribute("alias") == null ? "" : properties.getAttribute("alias"));
            table.setPackageName(packageName + "." + moduleName.toLowerCase());
            this.processAtrribute(root, element, table);
            File folder = new File(outputFolder + moduleName);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            return table;
        }
        return null;
    }

    private void processAtrribute(XmlNode root, XmlNode element, Table table) {
        XmlNode attributes = (XmlNode)element.getSubNode("attributes");
        if (attributes != null) {
            List nodeList = attributes.getSubNodes("attribute");
            for (XmlNode att : nodeList) {
                String type = ((XmlNode)att.getSubNode("properties")).getAttribute("type");
                String length = StringUtils.defaultString((String)((XmlNode)att.getSubNode("properties")).getAttribute("length"));
                XmlNode style = (XmlNode)att.getSubNode("style");
                String cname = null;
                if (style != null) {
                    cname = style.getAttribute("value");
                }
                if (cname == null) {
                    cname = "";
                }
                String name = att.getAttribute("name");
                name = MetadataGenerateEA2Table.getLowerCase(name);
                if (type == null) {
                    System.out.println("Error:" + name);
                    continue;
                }
                boolean primary = MetadataGenerateEA2Table.isPrimary(root, element, name);
                boolean unique = MetadataGenerateEA2Table.isUnique(root, element, name);
                TableField field = new TableField();
                field.setId(name);
                field.setPrimary(primary);
                field.setUnique(unique);
                field.setStandardFieldId(this.getStdfield(name, cname, type, length).getId());
                table.getFieldList().add(field);
            }
        }
    }

    private StandardType getStdType(String type, String length, BusinessType bizType) {
        StandardType stdType = this.stdTypeMap.get(type);
        if (stdType == null) {
            stdType = new StandardType();
            this.stdTypeMap.put(type, stdType);
            stdType.setId(Guid.createGUID());
            stdType.setName(type);
            stdType.setTitle(StringUtils.upperCase((String)type));
        }
        bizType.setTypeId(stdType.getId());
        if (bizType.getPlaceholderValueList() != null) {
            for (PlaceholderValue phv : bizType.getPlaceholderValueList()) {
                boolean status = false;
                if (stdType.getPlaceholderList() != null) {
                    for (Placeholder placeholder : stdType.getPlaceholderList()) {
                        if (!StringUtils.equals((String)placeholder.getName(), (String)phv.getName())) continue;
                        status = true;
                        break;
                    }
                }
                if (status) continue;
                Placeholder ph = new Placeholder();
                ph.setName(phv.getName());
                if (stdType.getPlaceholderList() == null) {
                    stdType.setPlaceholderList(new ArrayList<Placeholder>());
                }
                stdType.getPlaceholderList().add(ph);
            }
        }
        if (stdType.getDialectTypeList() == null) {
            stdType.setDialectTypeList(new ArrayList<DialectType>());
        }
        if (stdType.getDialectTypeList().size() == 0) {
            DialectType javaDialect = new DialectType();
            javaDialect.setLanguage("java");
            stdType.getDialectTypeList().add(javaDialect);
            DialectType mysqlDialect = new DialectType();
            mysqlDialect.setLanguage("mysql");
            mysqlDialect.setBaseType(type);
            if (StringUtils.isNotBlank((String)length)) {
                mysqlDialect.setExtType(length);
            }
            stdType.getDialectTypeList().add(mysqlDialect);
        }
        return stdType;
    }

    private StandardField getStdfield(String name, String title, String type, String length) {
        StdfieldPair key = new StdfieldPair(name, "");
        StandardField stdfield = this.stdfieldMap.get(key);
        if (stdfield == null) {
            stdfield = new StandardField();
            this.stdfieldMap.put(key, stdfield);
            stdfield.setId(Guid.createGUID());
            stdfield.setName(name);
            stdfield.setTitle(StringUtils.upperCase((String)(StringUtils.isBlank((String)title) ? name : title)));
            stdfield.setTypeId(this.getBizType(type, length).getId());
        }
        return stdfield;
    }

    private BusinessType getBizType(String type, String length) {
        BizTypePair key = new BizTypePair(type, length);
        BusinessType bizType = this.bizTypesMap.get(key);
        if (bizType == null) {
            bizType = new BusinessType();
            this.bizTypesMap.put(key, bizType);
            bizType.setId(Guid.createGUID());
            bizType.setName(type + StringUtils.defaultString((String)length));
            bizType.setTitle(StringUtils.upperCase((String)(type + StringUtils.defaultString((String)length))));
            if (StringUtils.isNotBlank((String)type) && StringUtils.isNotBlank((String)length)) {
                PlaceholderValue value = new PlaceholderValue();
                value.setName("length");
                value.setValue(length);
                if (bizType.getPlaceholderValueList() == null) {
                    bizType.setPlaceholderValueList(new ArrayList<PlaceholderValue>());
                }
                bizType.getPlaceholderValueList().add(value);
            }
        }
        this.getStdType(type, length, bizType);
        return bizType;
    }

    private static String getLowerCase(String str) {
        str = str.replaceAll("_ID", "Id");
        str = str.replaceAll("ID", "Id");
        StringBuffer sb = new StringBuffer();
        String[] strArray = str.split("_");
        for (int i = 0; i < strArray.length; ++i) {
            String word;
            if (i > 0) {
                sb.append("_");
            }
            if ((word = strArray[i]).equalsIgnoreCase("id")) {
                sb.append(word.toLowerCase());
                continue;
            }
            for (int j = 0; j < word.length(); ++j) {
                char ch = word.charAt(j);
                if (ch >= 'A' && ch <= 'Z') {
                    if (j != 0) {
                        sb.append("_");
                    }
                    sb.append((char)(ch - 65 + 97));
                    continue;
                }
                sb.append(ch);
            }
        }
        return sb.toString();
    }

    private static boolean isPrimary(XmlNode root, XmlNode element, String name) {
        XmlNode operations = (XmlNode)element.getSubNode("operations");
        if (operations != null) {
            List nodeList = operations.getSubNodes("operation");
            for (XmlNode operation : nodeList) {
                XmlNode stereotype = (XmlNode)operation.getSubNode("stereotype");
                if (stereotype == null || !stereotype.getAttribute("stereotype").equals("PK")) continue;
                NameFilter filter = new NameFilter((Node)root);
                filter.setIncludeAttribute("xmi:id", operation.getAttribute("xmi:idref"));
                XmlNode node = (XmlNode)filter.findNode("ownedOperation");
                List parameterList = node.getSubNodes("ownedParameter");
                if (parameterList.size() != 1 || !MetadataGenerateEA2Table.getLowerCase(((XmlNode)parameterList.get(0)).getAttribute("name")).equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isUnique(XmlNode root, XmlNode element, String name) {
        XmlNode operations = (XmlNode)element.getSubNode("operations");
        if (operations != null) {
            List nodeList = operations.getSubNodes("operation");
            for (XmlNode operation : nodeList) {
                XmlNode stereotype = (XmlNode)operation.getSubNode("stereotype");
                if (stereotype == null || !stereotype.getAttribute("stereotype").equals("unique")) continue;
                NameFilter filter = new NameFilter((Node)root);
                filter.setIncludeAttribute("xmi:id", operation.getAttribute("xmi:idref"));
                XmlNode node = (XmlNode)filter.findNode("ownedOperation");
                List parameterList = node.getSubNodes("ownedParameter");
                if (parameterList == null || parameterList.size() != 1 || !MetadataGenerateEA2Table.getLowerCase(((XmlNode)parameterList.get(0)).getAttribute("name")).equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private static void printOperations(XmlNode root, XmlNode element, StringBuffer buf) {
        XmlNode operations = (XmlNode)element.getSubNode("operations");
        if (operations != null) {
            List nodeList = operations.getSubNodes("operation");
            for (XmlNode operation : nodeList) {
                XmlNode stereotype = (XmlNode)operation.getSubNode("stereotype");
                if (stereotype == null) continue;
                if (stereotype.getAttribute("stereotype").equals("PK")) {
                    MetadataGenerateEA2Table.printPK(root, element, operation);
                    continue;
                }
                if (stereotype.getAttribute("stereotype").equals("unique")) {
                    System.out.println(MetadataGenerateEA2Table.getUnique(root, element, operation));
                    continue;
                }
                if (!stereotype.getAttribute("stereotype").equals("index")) continue;
                System.out.println(MetadataGenerateEA2Table.getIndex(root, element, operation));
            }
        }
    }

    private static void printPK(XmlNode root, XmlNode element, XmlNode operation) {
        NameFilter filter = new NameFilter((Node)root);
        filter.setIncludeAttribute("xmi:id", operation.getAttribute("xmi:idref"));
        XmlNode node = (XmlNode)filter.findNode("ownedOperation");
        MetadataGenerateEA2Table.getParameters(node);
    }

    private static String getUnique(XmlNode root, XmlNode element, XmlNode operation) {
        NameFilter filter = new NameFilter((Node)root);
        filter.setIncludeAttribute("xmi:id", operation.getAttribute("xmi:idref"));
        XmlNode node = (XmlNode)filter.findNode("ownedOperation");
        return MetadataGenerateEA2Table.getParameters(node);
    }

    private static String getIndex(XmlNode root, XmlNode element, XmlNode operation) {
        NameFilter filter = new NameFilter((Node)root);
        filter.setIncludeAttribute("xmi:id", operation.getAttribute("xmi:idref"));
        XmlNode node = (XmlNode)filter.findNode("ownedOperation");
        return MetadataGenerateEA2Table.getParameters(node);
    }

    private static String getParameters(XmlNode node) {
        StringBuffer sb = new StringBuffer();
        List parameterList = node.getSubNodes("ownedParameter");
        if (parameterList != null) {
            for (XmlNode para : parameterList) {
                if (sb.length() <= 0) continue;
                sb.append(",");
                sb.append(para.getAttribute("name"));
            }
        }
        return sb.toString();
    }
}

