/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xmlparser.formatter;

import java.io.OutputStream;
import java.nio.charset.Charset;
import junit.framework.TestCase;
import org.tinygroup.parser.Document;
import org.tinygroup.xmlparser.XmlDocument;
import org.tinygroup.xmlparser.formatter.XmlFormater;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class XmlFormatterTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testFormatDocumentSelfHtmlDocument() {
        try {
            XmlDocument doc = new XmlStringParser().parse("<html \u4e2d='\u6587'><!--abc--><head><title>aaa</title></head></html>");
            XmlFormater f = new XmlFormater();
            System.out.println(f.format((Document)doc));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testFormat() {
        try {
            XmlDocument xmlDocument = new XmlStringParser().parse("<title><a>a</a></title>");
            XmlFormater formater = new XmlFormater();
            System.out.println(formater.format((Document)xmlDocument));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testWriteFormat() {
        try {
            XmlDocument doc = new XmlStringParser().parse("<title><a>a</a></title>");
            XmlFormater f = new XmlFormater();
            f.format((Document)doc, (OutputStream)System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testError() {
        try {
            XmlDocument document = new XmlStringParser().parse("<Html><html></html></html>");
            XmlFormater formater = new XmlFormater();
            formater.format((Document)document, (OutputStream)System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testFormatDocumentSelfHtmlDocumentOutputStream() {
        try {
            XmlDocument document = new XmlStringParser().parse("<html \u4e2d='\u6587'><head><title>aaa</title><\u4e2d>\u4e2d\u4fe1</\u4e2d></head></html>");
            document.write((OutputStream)System.out);
            System.out.println("\n================================\n");
            XmlFormater formater = new XmlFormater();
            formater.setEncode(Charset.defaultCharset().displayName());
            formater.format((Document)document, (OutputStream)System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

