/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.imagecreator.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.tinygroup.imagecreator.TextToImage;
import org.tinygroup.imagecreator.impl.ConvertParameter;
import org.tinygroup.imagecreator.impl.RandomUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTextToImage<T>
implements TextToImage<T> {
    private static final int MAX_PRIMARY_COLOR = 256;
    private ConvertParameter convertParameter = null;

    public ConvertParameter getImageParameter() {
        return this.convertParameter;
    }

    public void setImageParameter(ConvertParameter convertParameter) {
        this.convertParameter = convertParameter;
    }

    private void drawDisturbedLine(Graphics graph) {
        for (int i = 0; i < this.convertParameter.getDisturbedLineNum(); ++i) {
            graph.setColor(RandomUtil.getColor(null, 256));
            int x1 = RandomUtil.getInt(this.convertParameter.getWidth());
            int y1 = RandomUtil.getInt(this.convertParameter.getHeight());
            int x2 = RandomUtil.getInt(this.convertParameter.getWidth());
            int y2 = RandomUtil.getInt(this.convertParameter.getHeight());
            graph.drawLine(x1, y1, x2, y2);
        }
    }

    @Override
    public void generateImage(String text, T out) throws IOException {
        if (this.convertParameter == null) {
            this.newImageParameter();
        }
        BufferedImage image = this.getImage();
        Graphics2D g = this.initImage(image);
        this.drawDisturbedLine(g);
        this.draw(this.convertParameter, g, text);
        g.dispose();
        this.outputImage(image, out);
    }

    void draw(ConvertParameter convertParameter, Graphics2D g, String text) {
        Font font = new Font(convertParameter.getFontName(), 1, convertParameter.getFontSize());
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics(font);
        int fontHeight = fm.getHeight();
        int offsetLeft = 0;
        int rowIndex = 1;
        for (int i = 0; i < text.length(); ++i) {
            boolean isOutWidth;
            this.initDrawStyle(convertParameter, g);
            char c = text.charAt(i);
            int charWidth = fm.charWidth(c);
            boolean isReturn = Character.isISOControl(c);
            boolean bl = isOutWidth = offsetLeft >= convertParameter.getWidth() - charWidth;
            if (isReturn || isOutWidth) {
                ++rowIndex;
                offsetLeft = 0;
            }
            g.drawString(String.valueOf(c), offsetLeft, rowIndex * fontHeight);
            offsetLeft += charWidth;
        }
    }

    private void initDrawStyle(ConvertParameter convertParameter, Graphics2D g) {
        g.rotate(Math.toRadians(RandomUtil.getDouble(convertParameter.getRadian(), convertParameter.getRadianRange())), convertParameter.getRotateX(), convertParameter.getRotateY());
        g.scale(convertParameter.getScale(), convertParameter.getScale());
        g.setColor(RandomUtil.getColor(convertParameter.getFontColor(), convertParameter.getColorRange()));
    }

    private Graphics2D initImage(BufferedImage image) {
        Graphics2D g = (Graphics2D)image.getGraphics();
        Image bgImage = this.convertParameter.getBgImage();
        if (bgImage == null) {
            g.setColor(this.convertParameter.getBgColor());
            g.fillRect(0, 0, this.convertParameter.getWidth(), this.convertParameter.getHeight());
        } else {
            g.drawImage(bgImage, 0, 0, image.getWidth(), image.getHeight(), 0, 0, bgImage.getWidth(null), bgImage.getWidth(null), null);
        }
        g.setColor(this.convertParameter.getRectColor());
        g.drawRect(0, 0, this.convertParameter.getWidth() - 1, this.convertParameter.getHeight() - 1);
        return g;
    }

    private void newImageParameter() {
        this.convertParameter = new ConvertParameter();
        this.convertParameter.setRotateX(this.convertParameter.getWidth() / 2);
        this.convertParameter.setRotateY(this.convertParameter.getHeight() / 2);
    }

    private BufferedImage getImage() {
        BufferedImage image = new BufferedImage(this.convertParameter.getWidth(), this.convertParameter.getHeight(), 1);
        if (this.convertParameter.getRectColor() == null) {
            this.convertParameter.setRectColor(Color.BLACK);
        }
        if (this.convertParameter.getBgColor() == null) {
            this.convertParameter.setBgColor(Color.WHITE);
        }
        return image;
    }

    protected abstract void outputImage(BufferedImage var1, T var2) throws IOException;
}

