/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.imagecreator.impl;

import java.awt.Color;
import java.util.Date;
import java.util.Random;

final class RandomUtil {
    private static final int MAX_PRIMARY_COLOR = 256;
    private static Random rnd = new Random(new Date().getTime());

    private RandomUtil() {
    }

    private static Color getRandomColor(Color base, int range) {
        int red = (base.getRed() + rnd.nextInt(range)) % 256;
        int green = (base.getGreen() + rnd.nextInt(range)) % 256;
        int blue = (base.getBlue() + rnd.nextInt(range)) % 256;
        return new Color(red, green, blue);
    }

    public static int getInt(int intValue) {
        return rnd.nextInt(intValue);
    }

    public static double getDouble(double baseValue, int range) {
        if (range == 0) {
            return baseValue;
        }
        return baseValue + (double)rnd.nextInt(range) - (double)(range / 2);
    }

    public static Color getColor(Color fontColor, int colorRange) {
        if (fontColor == null) {
            return RandomUtil.getRandomColor(Color.WHITE, colorRange);
        }
        if (colorRange == 0) {
            return fontColor;
        }
        return new Color(RandomUtil.getInt(colorRange), RandomUtil.getInt(colorRange), RandomUtil.getInt(colorRange));
    }
}

