/*
 * Decompiled with CFR 0.152.
 */
package org.pmw.tinylog;

import org.pmw.tinylog.Level;
import org.pmw.tinylog.Supplier;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;

public final class Logger {
    private static final int STACKTRACE_DEPTH = 2;
    private static final LoggingProvider provider = ProviderRegistry.getLoggingProvider();
    private static final boolean MINIMUM_LEVEL_COVERS_TRACE = Logger.isCoveredByMinimumLevel(org.tinylog.Level.TRACE);
    private static final boolean MINIMUM_LEVEL_COVERS_DEBUG = Logger.isCoveredByMinimumLevel(org.tinylog.Level.DEBUG);
    private static final boolean MINIMUM_LEVEL_COVERS_INFO = Logger.isCoveredByMinimumLevel(org.tinylog.Level.INFO);
    private static final boolean MINIMUM_LEVEL_COVERS_WARN = Logger.isCoveredByMinimumLevel(org.tinylog.Level.WARN);
    private static final boolean MINIMUM_LEVEL_COVERS_ERROR = Logger.isCoveredByMinimumLevel(org.tinylog.Level.ERROR);

    private Logger() {
    }

    public static Level getLevel() {
        return Logger.translateLevel(provider.getMinimumLevel(null));
    }

    public static Level getLevel(Package packageObject) {
        return Logger.translateLevel(provider.getMinimumLevel(null));
    }

    public static Level getLevel(Class<?> classObject) {
        return Logger.translateLevel(provider.getMinimumLevel(null));
    }

    public static void trace(Object message) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, org.tinylog.Level.TRACE, null, message, (Object[])null);
        }
    }

    public static void trace(String message) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, org.tinylog.Level.TRACE, null, (Object)message, (Object[])null);
        }
    }

    public static void trace(Supplier<?> message) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, org.tinylog.Level.TRACE, null, message, (Object[])null);
        }
    }

    public static void trace(String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, org.tinylog.Level.TRACE, null, (Object)message, arguments);
        }
    }

    public static void trace(String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, org.tinylog.Level.TRACE, null, (Object)message, (Object[])arguments);
        }
    }

    public static void trace(Throwable exception) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, org.tinylog.Level.TRACE, exception, null, (Object[])null);
        }
    }

    public static void trace(Throwable exception, String message) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, org.tinylog.Level.TRACE, exception, (Object)message, (Object[])null);
        }
    }

    public static void trace(Throwable exception, Supplier<String> message) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, org.tinylog.Level.TRACE, exception, message, (Object[])null);
        }
    }

    public static void trace(Throwable exception, String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, org.tinylog.Level.TRACE, exception, (Object)message, arguments);
        }
    }

    public static void trace(Throwable exception, String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, org.tinylog.Level.TRACE, exception, (Object)message, (Object[])arguments);
        }
    }

    public static void debug(Object message) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, org.tinylog.Level.DEBUG, null, message, (Object[])null);
        }
    }

    public static void debug(String message) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, org.tinylog.Level.DEBUG, null, (Object)message, (Object[])null);
        }
    }

    public static void debug(Supplier<?> message) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, org.tinylog.Level.DEBUG, null, message, (Object[])null);
        }
    }

    public static void debug(String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, org.tinylog.Level.DEBUG, null, (Object)message, arguments);
        }
    }

    public static void debug(String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, org.tinylog.Level.DEBUG, null, (Object)message, (Object[])arguments);
        }
    }

    public static void debug(Throwable exception) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, org.tinylog.Level.DEBUG, exception, null, (Object[])null);
        }
    }

    public static void debug(Throwable exception, String message) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, org.tinylog.Level.DEBUG, exception, (Object)message, (Object[])null);
        }
    }

    public static void debug(Throwable exception, Supplier<String> message) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, org.tinylog.Level.DEBUG, exception, message, (Object[])null);
        }
    }

    public static void debug(Throwable exception, String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, org.tinylog.Level.DEBUG, exception, (Object)message, arguments);
        }
    }

    public static void debug(Throwable exception, String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, org.tinylog.Level.DEBUG, exception, (Object)message, (Object[])arguments);
        }
    }

    public static void info(Object message) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, org.tinylog.Level.INFO, null, message, (Object[])null);
        }
    }

    public static void info(String message) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, org.tinylog.Level.INFO, null, (Object)message, (Object[])null);
        }
    }

    public static void info(Supplier<?> message) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, org.tinylog.Level.INFO, null, message, (Object[])null);
        }
    }

    public static void info(String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, org.tinylog.Level.INFO, null, (Object)message, arguments);
        }
    }

    public static void info(String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, org.tinylog.Level.INFO, null, (Object)message, (Object[])arguments);
        }
    }

    public static void info(Throwable exception) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, org.tinylog.Level.INFO, exception, null, (Object[])null);
        }
    }

    public static void info(Throwable exception, String message) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, org.tinylog.Level.INFO, exception, (Object)message, (Object[])null);
        }
    }

    public static void info(Throwable exception, Supplier<String> message) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, org.tinylog.Level.INFO, exception, message, (Object[])null);
        }
    }

    public static void info(Throwable exception, String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, org.tinylog.Level.INFO, exception, (Object)message, arguments);
        }
    }

    public static void info(Throwable exception, String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_INFO) {
            provider.log(2, null, org.tinylog.Level.INFO, exception, (Object)message, (Object[])arguments);
        }
    }

    public static void warn(Object message) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, org.tinylog.Level.WARN, null, message, (Object[])null);
        }
    }

    public static void warn(String message) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, org.tinylog.Level.WARN, null, (Object)message, (Object[])null);
        }
    }

    public static void warn(Supplier<?> message) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, org.tinylog.Level.WARN, null, message, (Object[])null);
        }
    }

    public static void warn(String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, org.tinylog.Level.WARN, null, (Object)message, arguments);
        }
    }

    public static void warn(String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, org.tinylog.Level.WARN, null, (Object)message, (Object[])arguments);
        }
    }

    public static void warn(Throwable exception) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, org.tinylog.Level.WARN, exception, null, (Object[])null);
        }
    }

    public static void warn(Throwable exception, String message) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, org.tinylog.Level.WARN, exception, (Object)message, (Object[])null);
        }
    }

    public static void warn(Throwable exception, Supplier<String> message) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, org.tinylog.Level.WARN, exception, message, (Object[])null);
        }
    }

    public static void warn(Throwable exception, String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, org.tinylog.Level.WARN, exception, (Object)message, arguments);
        }
    }

    public static void warn(Throwable exception, String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_WARN) {
            provider.log(2, null, org.tinylog.Level.WARN, exception, (Object)message, (Object[])arguments);
        }
    }

    public static void error(Object message) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, org.tinylog.Level.ERROR, null, message, (Object[])null);
        }
    }

    public static void error(String message) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, org.tinylog.Level.ERROR, null, (Object)message, (Object[])null);
        }
    }

    public static void error(Supplier<?> message) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, org.tinylog.Level.ERROR, null, message, (Object[])null);
        }
    }

    public static void error(String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, org.tinylog.Level.ERROR, null, (Object)message, arguments);
        }
    }

    public static void error(String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, org.tinylog.Level.ERROR, null, (Object)message, (Object[])arguments);
        }
    }

    public static void error(Throwable exception) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, org.tinylog.Level.ERROR, exception, null, (Object[])null);
        }
    }

    public static void error(Throwable exception, String message) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, org.tinylog.Level.ERROR, exception, (Object)message, (Object[])null);
        }
    }

    public static void error(Throwable exception, Supplier<String> message) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, org.tinylog.Level.ERROR, exception, message, (Object[])null);
        }
    }

    public static void error(Throwable exception, String message, Object ... arguments) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, org.tinylog.Level.ERROR, exception, (Object)message, arguments);
        }
    }

    public static void error(Throwable exception, String message, Supplier<?> ... arguments) {
        if (MINIMUM_LEVEL_COVERS_ERROR) {
            provider.log(2, null, org.tinylog.Level.ERROR, exception, (Object)message, (Object[])arguments);
        }
    }

    private static boolean isCoveredByMinimumLevel(org.tinylog.Level level) {
        return provider.getMinimumLevel(null).ordinal() <= level.ordinal();
    }

    private static Level translateLevel(org.tinylog.Level level) {
        switch (level) {
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARNING;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case OFF: {
                return Level.OFF;
            }
        }
        throw new IllegalArgumentException("Unknown severity level \"" + level + "\"");
    }
}

