/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joda.time.DateTime;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaTrailer;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MediaMetadata {
    public static final String IMDB = "imdb";
    public static final String TMDB = "tmdb";
    public static final String TVDB = "tvdb";
    public static final String TMDB_SET = "tmdbSet";
    public static final String EPISODE_NR = "episodeNr";
    public static final String SEASON_NR = "seasonNr";
    public static final String EPISODE_NR_DVD = "dvdEpisodeNr";
    public static final String SEASON_NR_DVD = "dvdSeasonNr";
    private final String providerId;
    private HashMap<String, Object> ids = new HashMap();
    private String title = "";
    private String originalTitle = "";
    private String originalLanguage = "";
    private int year = 0;
    private Date releaseDate = null;
    private String plot = "";
    private String tagline = "";
    private int runtime = 0;
    private float rating = 0.0f;
    private int voteCount = 0;
    private String collectionName = "";
    private int top250 = 0;
    private int episodeNumber = -1;
    private int seasonNumber = -1;
    private int dvdEpisodeNumber = -1;
    private int dvdSeasonNumber = -1;
    private int displayEpisodeNumber = -1;
    private int displaySeasonNumber = -1;
    private int absoluteNumber = -1;
    private String status = "";
    private List<MediaCastMember> castMembers = new ArrayList<MediaCastMember>();
    private List<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
    private List<MediaGenres> genres = new ArrayList<MediaGenres>();
    private List<Certification> certifications = new ArrayList<Certification>();
    private List<String> productionCompanies = new ArrayList<String>();
    private List<String> spokenLanguages = new ArrayList<String>();
    private List<String> countries = new ArrayList<String>();
    private List<MediaTrailer> trailers = new ArrayList<MediaTrailer>();
    private List<MediaMetadata> subItems = new ArrayList<MediaMetadata>();
    private List<String> tags = new ArrayList<String>();
    private HashMap<String, Object> extraData = new HashMap();

    public MediaMetadata(String providerId) {
        this.providerId = providerId;
    }

    public void mergeFrom(MediaMetadata md) {
        if (md == null) {
            return;
        }
        Map<String, Object> delta = md.getIds();
        delta.keySet().removeAll(this.ids.keySet());
        this.ids.putAll(delta);
        this.title = this.merge(this.title, md.getTitle());
        this.originalTitle = this.merge(this.originalTitle, md.getOriginalTitle());
        this.originalLanguage = this.merge(this.originalLanguage, md.getOriginalLanguage());
        this.year = this.merge(this.year, md.getYear());
        this.releaseDate = this.merge(this.releaseDate, md.getReleaseDate());
        this.plot = this.merge(this.plot, md.getPlot());
        this.tagline = this.merge(this.tagline, md.getTagline());
        this.runtime = this.merge(this.runtime, md.getRuntime());
        this.rating = this.merge(this.rating, md.getRating());
        this.voteCount = this.merge(this.voteCount, md.getVoteCount());
        this.collectionName = this.merge(this.collectionName, md.getCollectionName());
        this.top250 = this.merge(this.top250, md.getTop250());
        this.episodeNumber = this.merge(this.episodeNumber, md.getEpisodeNumber());
        this.seasonNumber = this.merge(this.seasonNumber, md.getSeasonNumber());
        this.dvdEpisodeNumber = this.merge(this.dvdEpisodeNumber, md.getDvdEpisodeNumber());
        this.dvdSeasonNumber = this.merge(this.dvdSeasonNumber, md.getDvdSeasonNumber());
        this.absoluteNumber = this.merge(this.absoluteNumber, md.getAbsoluteNumber());
        this.status = this.merge(this.status, md.getStatus());
        this.castMembers.removeAll(md.getCastMembers());
        this.castMembers.addAll(md.getCastMembers());
        this.artwork.removeAll(md.getFanart());
        this.artwork.addAll(md.getFanart());
        this.genres.removeAll(md.getGenres());
        this.genres.addAll(md.getGenres());
        this.certifications.removeAll(md.getCertifications());
        this.certifications.addAll(md.getCertifications());
        this.productionCompanies.removeAll(md.getProductionCompanies());
        this.productionCompanies.addAll(md.getProductionCompanies());
        this.spokenLanguages.removeAll(md.getSpokenLanguages());
        this.spokenLanguages.addAll(md.getSpokenLanguages());
        this.countries.removeAll(md.getCountries());
        this.countries.addAll(md.getCountries());
        this.trailers.removeAll(md.getTrailers());
        this.trailers.addAll(md.getTrailers());
        this.subItems.removeAll(md.getSubItems());
        this.subItems.addAll(md.getSubItems());
        this.tags.removeAll(md.getTags());
        this.tags.addAll(md.getTags());
        delta = md.getExtraData();
        delta.keySet().removeAll(this.extraData.keySet());
        this.extraData.putAll(delta);
    }

    private String merge(String val1, String val2) {
        return StringUtils.isBlank((CharSequence)val1) ? val2 : val1;
    }

    private int merge(int val1, int val2) {
        return val1 <= 0 ? val2 : val1;
    }

    private Date merge(Date val1, Date val2) {
        return val1 == null ? val2 : val1;
    }

    private float merge(float val1, float val2) {
        return val1 <= 0.0f ? val2 : val1;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public List<MediaGenres> getGenres() {
        return this.genres;
    }

    public List<MediaCastMember> getCastMembers(MediaCastMember.CastType type) {
        if (type == MediaCastMember.CastType.ALL) {
            return this.castMembers;
        }
        ArrayList<MediaCastMember> l = new ArrayList<MediaCastMember>(this.castMembers.size());
        for (MediaCastMember cm : this.castMembers) {
            if (cm.getType() != type) continue;
            l.add(cm);
        }
        return l;
    }

    public List<MediaArtwork> getMediaArt(MediaArtwork.MediaArtworkType type) {
        List<MediaArtwork> mediaArt = this.getFanart();
        if (mediaArt == null || type == MediaArtwork.MediaArtworkType.ALL) {
            return mediaArt;
        }
        ArrayList<MediaArtwork> l = new ArrayList<MediaArtwork>(mediaArt.size());
        for (MediaArtwork ma : mediaArt) {
            if (ma.getType() != type) continue;
            l.add(ma);
        }
        return l;
    }

    public void addGenre(MediaGenres genre) {
        if (genre != null && !this.genres.contains(genre)) {
            this.genres.add(genre);
        }
    }

    public void addCastMember(MediaCastMember cm) {
        if (this.containsCastMember(cm)) {
            return;
        }
        this.castMembers.add(cm);
    }

    public void addMediaArt(MediaArtwork ma) {
        if (ma != null) {
            this.artwork.add(ma);
        }
    }

    public void clearMediaArt() {
        this.artwork.clear();
    }

    public void addMediaArt(List<MediaArtwork> art) {
        this.artwork.addAll(art);
    }

    public List<MediaCastMember> getCastMembers() {
        return this.castMembers;
    }

    public List<MediaArtwork> getFanart() {
        return this.artwork;
    }

    public void addSubItem(MediaMetadata item) {
        if (item != null) {
            this.subItems.add(item);
        }
    }

    public List<MediaMetadata> getSubItems() {
        return this.subItems;
    }

    private boolean containsCastMember(MediaCastMember cm) {
        boolean found = false;
        if (this.castMembers != null) {
            for (MediaCastMember m : this.castMembers) {
                if (m.getType() != cm.getType() || m.getName() == null || !m.getName().equals(cm.getName())) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public void addCertification(Certification certification) {
        if (certification != null) {
            this.certifications.add(certification);
        }
    }

    public List<Certification> getCertifications() {
        return this.certifications;
    }

    public void addTrailer(MediaTrailer trailer) {
        if (trailer != null) {
            this.trailers.add(trailer);
        }
    }

    public List<MediaTrailer> getTrailers() {
        return this.trailers;
    }

    public void setId(String key, Object object) {
        if (StringUtils.isNotBlank((CharSequence)key) && object != null) {
            this.ids.put(key, object);
        }
    }

    public Object getId(String key) {
        Object id = this.ids.get(key);
        if (id == null) {
            return "";
        }
        return id;
    }

    public HashMap<String, Object> getIds() {
        return this.ids;
    }

    public List<String> getProductionCompanies() {
        return this.productionCompanies;
    }

    public void setProductionCompanies(List<String> productionCompanies) {
        this.productionCompanies.clear();
        if (productionCompanies != null) {
            this.productionCompanies.addAll(productionCompanies);
        }
    }

    public void addProductionCompany(String productionCompany) {
        if (StringUtils.isBlank((CharSequence)productionCompany)) {
            return;
        }
        if (!this.productionCompanies.contains(productionCompany)) {
            this.productionCompanies.add(productionCompany);
        }
    }

    public void removeProductionCompany(String productionCompany) {
        this.productionCompanies.remove(productionCompany);
    }

    public List<String> getSpokenLanguages() {
        return this.spokenLanguages;
    }

    public void setSpokenLanguages(List<String> spokenLanguages) {
        this.spokenLanguages.clear();
        if (spokenLanguages != null) {
            this.spokenLanguages.addAll(spokenLanguages);
        }
    }

    public void addSpokenLanguage(String language) {
        if (StringUtils.isBlank((CharSequence)language)) {
            return;
        }
        if (!this.spokenLanguages.contains(language)) {
            this.spokenLanguages.add(language);
        }
    }

    public void removeSpokenLanguage(String language) {
        this.spokenLanguages.remove(language);
    }

    public List<String> getCountries() {
        return this.countries;
    }

    public void setCountries(List<String> countries) {
        this.countries.clear();
        if (countries != null) {
            this.countries.addAll(countries);
        }
    }

    public void addCountry(String country) {
        if (StringUtils.isBlank((CharSequence)country)) {
            return;
        }
        if (!this.countries.contains(country)) {
            this.countries.add(country);
        }
    }

    public void removeCountry(String country) {
        this.countries.remove(country);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = StrgUtils.getNonNullString(title);
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public void setOriginalTitle(String originalTitle) {
        this.originalTitle = StrgUtils.getNonNullString(originalTitle);
    }

    public String getOriginalLanguage() {
        return this.originalLanguage;
    }

    public void setOriginalLanguage(String originalLanguage) {
        this.originalLanguage = StrgUtils.getNonNullString(originalLanguage);
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setYear(Integer year) {
        if (year != null) {
            this.setYear((int)year);
        }
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(Date releaseDate) {
        this.releaseDate = releaseDate;
    }

    public void setReleaseDate(DateTime releaseDate) {
        if (releaseDate != null) {
            this.setReleaseDate(releaseDate.toDate());
        }
    }

    public String getPlot() {
        return this.plot;
    }

    public void setPlot(String plot) {
        this.plot = StrgUtils.getNonNullString(plot);
    }

    public String getTagline() {
        return this.tagline;
    }

    public void setTagline(String tagline) {
        this.tagline = StrgUtils.getNonNullString(tagline);
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = StrgUtils.getNonNullString(collectionName);
    }

    public int getRuntime() {
        return this.runtime;
    }

    public void setRuntime(int runtime) {
        this.runtime = runtime;
    }

    public void setRuntime(Integer runtime) {
        if (runtime != null) {
            this.setRuntime((int)runtime);
        }
    }

    public float getRating() {
        return this.rating;
    }

    public void setRating(float rating) {
        this.rating = rating;
    }

    public void setRating(Float rating) {
        if (rating != null) {
            this.setRating(rating.floatValue());
        }
    }

    public void setRating(double rating) {
        this.setRating((float)rating);
    }

    public void setRating(Double rating) {
        if (rating != null) {
            this.setRating(rating.floatValue());
        }
    }

    public int getVoteCount() {
        return this.voteCount;
    }

    public void setVoteCount(int voteCount) {
        this.voteCount = voteCount;
    }

    public void setVoteCount(Integer voteCount) {
        if (voteCount != null) {
            this.setVoteCount((int)voteCount);
        }
    }

    public int getTop250() {
        return this.top250;
    }

    public void setTop250(int top250) {
        this.top250 = top250;
    }

    public void setTop250(Integer top250) {
        if (top250 != null) {
            this.setTop250((int)top250);
        }
    }

    public int getEpisodeNumber() {
        return this.episodeNumber;
    }

    public void setEpisodeNumber(int episodeNumber) {
        this.episodeNumber = episodeNumber;
    }

    public void setEpisodeNumber(Integer episodeNumber) {
        if (episodeNumber != null) {
            this.setEpisodeNumber((int)episodeNumber);
        }
    }

    public int getSeasonNumber() {
        return this.seasonNumber;
    }

    public void setSeasonNumber(int seasonNumber) {
        this.seasonNumber = seasonNumber;
    }

    public void setSeasonNumber(Integer seasonNumber) {
        if (seasonNumber != null) {
            this.setSeasonNumber((int)seasonNumber);
        }
    }

    public int getDvdEpisodeNumber() {
        return this.dvdEpisodeNumber;
    }

    public void setDvdEpisodeNumber(int dvdEpisodeNumber) {
        this.dvdEpisodeNumber = dvdEpisodeNumber;
    }

    public void setDvdEpisodeNumber(Integer dvdEpisodeNumber) {
        if (dvdEpisodeNumber != null) {
            this.setDvdEpisodeNumber((int)dvdEpisodeNumber);
        }
    }

    public int getDvdSeasonNumber() {
        return this.dvdSeasonNumber;
    }

    public void setDvdSeasonNumber(int dvdSeasonNumber) {
        this.dvdSeasonNumber = dvdSeasonNumber;
    }

    public void setDvdSeasonNumber(Integer dvdSeasonNumber) {
        if (dvdSeasonNumber != null) {
            this.setDvdSeasonNumber((int)dvdSeasonNumber);
        }
    }

    public int getDisplayEpisodeNumber() {
        return this.displayEpisodeNumber;
    }

    public void setDisplayEpisodeNumber(int displayEpisodeNumber) {
        this.displayEpisodeNumber = displayEpisodeNumber;
    }

    public void setDisplayEpisodeNumber(Integer displayEpisodeNumber) {
        if (displayEpisodeNumber != null) {
            this.setDisplayEpisodeNumber((int)displayEpisodeNumber);
        }
    }

    public int getDisplaySeasonNumber() {
        return this.displaySeasonNumber;
    }

    public void setDisplaySeasonNumber(int displaySeasonNumber) {
        this.displaySeasonNumber = displaySeasonNumber;
    }

    public void setDisplaySeasonNumber(Integer displaySeasonNumber) {
        if (displaySeasonNumber != null) {
            this.setDisplaySeasonNumber((int)displaySeasonNumber);
        }
    }

    public int getAbsoluteNumber() {
        return this.absoluteNumber;
    }

    public void setAbsoluteNumber(int absoluteNumber) {
        this.absoluteNumber = absoluteNumber;
    }

    public void setAbsoluteNumber(Integer absoluteNumber) {
        if (absoluteNumber != null) {
            this.setAbsoluteNumber((int)absoluteNumber);
        }
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = StrgUtils.getNonNullString(status);
    }

    public Map<String, Object> getExtraData() {
        return this.extraData;
    }

    public void addExtraData(String key, Object value) {
        if (StringUtils.isNotBlank((CharSequence)key) && value != null) {
            this.extraData.put(key, value);
        }
    }

    public Object getExtraData(String key) {
        return this.extraData.get(key);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags.clear();
        if (tags != null) {
            this.tags.addAll(tags);
        }
    }

    public void addTag(String tag) {
        if (StringUtils.isBlank((CharSequence)tag)) {
            return;
        }
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    public void removeTag(String tag) {
        this.tags.remove(tag);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

