/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.entities;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MediaCastMember {
    private String id;
    private String name;
    private String character;
    private String part;
    private String providerDataUrl;
    private String imageUrl;
    private CastType type;
    private List<String> fanart = new LinkedList<String>();

    public MediaCastMember() {
    }

    public MediaCastMember(CastType type) {
        this.setType(type);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StrgUtils.getNonNullString(name);
    }

    public String getPart() {
        return this.part;
    }

    public void setPart(String part) {
        this.part = StrgUtils.getNonNullString(part);
    }

    public String getProviderDataUrl() {
        return this.providerDataUrl;
    }

    public void setProviderDataUrl(String providerDataUrl) {
        this.providerDataUrl = StrgUtils.getNonNullString(providerDataUrl);
    }

    public CastType getType() {
        return this.type;
    }

    public void setType(CastType type) {
        this.type = type;
    }

    public void addFanart(String url) {
        this.fanart.add(StrgUtils.getNonNullString(url).trim());
    }

    public String getCharacter() {
        return this.character;
    }

    public void setCharacter(String character) {
        this.character = StrgUtils.getNonNullString(character);
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = StrgUtils.getNonNullString(imageUrl);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static enum CastType {
        ACTOR,
        WRITER,
        DIRECTOR,
        OTHER,
        ALL,
        PRODUCER;

    }
}

