/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.entities;

import java.util.HashMap;
import java.util.Map;

public enum MediaLanguages {
    al("Shqip"),
    ar("\u0627\u0644\u0639\u064e\u0631\u064e\u0628\u0650\u064a\u064e\u0651\u0629"),
    bg("\u0431\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438 \u0435\u0437\u0438\u043a"),
    cs("\u010cesk\u00fd"),
    de("Deutsch"),
    da("Dansk"),
    el("\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac"),
    en("English"),
    es("Espa\u00f1ol"),
    et("eesti"),
    fa("\u0641\u0627\u0631\u0633\u06cc"),
    fi("Suomi"),
    fr("Fran\u00e7aise"),
    hr("hrvatski jezik"),
    hu("Magyar"),
    hy("\u0540\u0561\u0575\u0565\u0580\u0565\u0576"),
    it("Italiano"),
    ja("\u65e5\u672c\u8a9e"),
    ka("\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8"),
    ko("\ud55c\uad6d\uc5b4"),
    nl("Nederlands, Vlaams"),
    no("Norsk"),
    pl("Polski"),
    pt("Portugu\u00eas"),
    pt_BR("Portugu\u00eas (Brasil)"),
    ro("Rom\u00e2n\u0103"),
    ru("\u0420\u0443\u0441\u0441\u043a\u0438\u0439"),
    sl("Sloven\u010dina"),
    sk("Sloven\u0161\u010dina"),
    sr("\u0441\u0440\u043f\u0441\u043a\u0438 \u0458\u0435\u0437\u0438\u043a"),
    sv("Svenska"),
    tr("T\u00fcrk\u00e7e"),
    uk("\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430"),
    zh("\u534e\u8bed");

    private String title;
    private static final Map<String, MediaLanguages> lookup;

    private static Map<String, MediaLanguages> prepareLookup() {
        HashMap<String, MediaLanguages> mlMap = new HashMap<String, MediaLanguages>();
        for (MediaLanguages lang : MediaLanguages.values()) {
            mlMap.put(lang.getTitle(), lang);
        }
        return mlMap;
    }

    public static MediaLanguages get(String title) {
        return lookup.get(title);
    }

    private MediaLanguages(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLanguage() {
        return this.name().substring(0, 2);
    }

    public String toString() {
        return this.title;
    }

    static {
        lookup = MediaLanguages.prepareLookup();
    }
}

