/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StrgUtils {
    private static final Map<Integer, Replacement> REPLACEMENTS = StrgUtils.buildReplacementMap();
    private static final String[] COMMON_TITLE_PREFIXES = StrgUtils.buildCommonTitlePrefixes();

    private static Map<Integer, Replacement> buildReplacementMap() {
        HashMap<Integer, Replacement> replacements = new HashMap<Integer, Replacement>();
        replacements.put(198, new Replacement("AE", "Ae"));
        replacements.put(230, new Replacement("ae"));
        replacements.put(208, new Replacement("D"));
        replacements.put(273, new Replacement("d"));
        replacements.put(216, new Replacement("O"));
        replacements.put(248, new Replacement("o"));
        replacements.put(338, new Replacement("OE", "Oe"));
        replacements.put(339, new Replacement("oe"));
        replacements.put(358, new Replacement("T"));
        replacements.put(359, new Replacement("t"));
        return replacements;
    }

    private static String[] buildCommonTitlePrefixes() {
        return new String[]{"A", "An", "The", "Der", "Die", "Das", "Ein", "Eine", "Eines", "Einer", "Einem", "Einen", "Le", "La", "Une", "Des", "El", "Los", "La", "Las", "Un", "Unos", "Una", "Unas"};
    }

    public static String removeHtml(String html) {
        if (html == null) {
            return null;
        }
        return html.replaceAll("<[^>]+>", "");
    }

    public static String unquote(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceFirst("^\\\"(.*)\\\"$", "$1");
    }

    public static String mapToString(Map map) {
        if (map == null) {
            return "null";
        }
        if (map.size() == 0) {
            return "empty";
        }
        StringBuilder sb = new StringBuilder();
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry me = o = i$.next();
            sb.append(me.getKey()).append(": ").append(me.getValue()).append(",");
        }
        return sb.toString();
    }

    public static String zeroPad(String encodeString, int padding) {
        try {
            int v = Integer.parseInt(encodeString);
            String format = "%0" + padding + "d";
            return String.format(format, v);
        }
        catch (Exception e) {
            return encodeString;
        }
    }

    public static String substr(String str, String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Matcher m = regex.matcher(str);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    public static Date parseDate(String dateAsString) throws ParseException {
        Date date = null;
        Pattern datePattern = Pattern.compile("([0-9]{2})[_\\.-]([0-9]{2})[_\\.-]([0-9]{4})");
        Matcher m = datePattern.matcher(dateAsString);
        if (m.find()) {
            date = new SimpleDateFormat("dd-MM-yyyy").parse(m.group(1) + "-" + m.group(2) + "-" + m.group(3));
        } else {
            datePattern = Pattern.compile("([0-9]{4})[_\\.-]([0-9]{2})[_\\.-]([0-9]{2})");
            m = datePattern.matcher(dateAsString);
            if (m.find()) {
                date = new SimpleDateFormat("yyyy-MM-dd").parse(m.group(1) + "-" + m.group(2) + "-" + m.group(3));
            }
        }
        if (date == null) {
            throw new ParseException("could not parse date from: \"" + dateAsString + "\"", 0);
        }
        return date;
    }

    public static String removeDuplicateWhitespace(String s) {
        StringBuilder result = new StringBuilder();
        int length = s.length();
        boolean isPreviousWhiteSpace = false;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            boolean thisCharWhiteSpace = Character.isWhitespace(c);
            if (!isPreviousWhiteSpace || !thisCharWhiteSpace) {
                result.append(c);
            }
            isPreviousWhiteSpace = thisCharWhiteSpace;
        }
        return result.toString();
    }

    public static String convertToAscii(String input, boolean replaceAllCapitalLetters) {
        String result = null;
        if (null != input) {
            String normalized = Normalizer.normalize(input, Normalizer.Form.NFKD);
            int len = normalized.length();
            result = StrgUtils.processSpecialChars(normalized.toCharArray(), 0, len, replaceAllCapitalLetters);
        }
        return result;
    }

    private static String processSpecialChars(char[] target, int offset, int len, boolean uppercase) {
        StringBuilder result = new StringBuilder();
        boolean skip = false;
        block5: for (int i = 0; i < len; ++i) {
            if (skip) {
                skip = false;
                continue;
            }
            char c = target[i];
            if (c > ' ' && c < '@' || c > 'z' && c < '\u00c0' || c > 'Z' && c < 'a' || c > 'y' && c < '\u00c0' || c == '\u00d7' || c == '\u00f7') {
                result.append(c);
                continue;
            }
            if (Character.isDigit(c) || Character.isISOControl(c)) {
                result.append(c);
                continue;
            }
            if (!Character.isWhitespace(c) && !Character.isLetter(c)) continue;
            boolean isUpper = false;
            switch (c) {
                case '\u00df': {
                    result.append("ss");
                    continue block5;
                }
                case 'A': 
                case 'O': 
                case 'U': {
                    isUpper = true;
                }
                case 'a': 
                case 'o': 
                case 'u': {
                    result.append(c);
                    if (i + 1 >= target.length || target[i + 1] != '\u0308') continue block5;
                    result.append((char)(isUpper && uppercase ? 69 : 101));
                    skip = true;
                    continue block5;
                }
                default: {
                    Replacement rep = REPLACEMENTS.get(c);
                    if (rep != null) {
                        result.append(uppercase ? rep.UPPER : rep.LOWER);
                        continue block5;
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String removeCommonSortableName(String title) {
        if (title == null || title.isEmpty()) {
            return "";
        }
        for (String prfx : COMMON_TITLE_PREFIXES) {
            String delim = " ";
            if (prfx.matches(".*['`\u00b4]$")) {
                delim = "";
            }
            title = title.replaceAll("(?i)(.*), " + prfx, prfx + delim + "$1");
        }
        return title.trim();
    }

    public static int compareVersion(String v1, String v2) {
        if (v1.contains("-SNAPSHOT") && v1.equals(v2) || v1.equals("SVN") || v1.equals("GIT")) {
            return -1;
        }
        String s1 = StrgUtils.normalisedVersion(v1);
        String s2 = StrgUtils.normalisedVersion(v2);
        return s1.compareTo(s2);
    }

    private static String normalisedVersion(String version) {
        return StrgUtils.normalisedVersion(version, ".", 4);
    }

    private static String normalisedVersion(String version, String sep, int maxWidth) {
        version = !version.contains("-SNAPSHOT") ? version + ".0.0.1" : version.replace("-SNAPSHOT", "");
        String[] split = Pattern.compile(sep, 16).split(version);
        StringBuilder sb = new StringBuilder();
        for (String s : split) {
            sb.append(String.format("%" + maxWidth + 's', s));
        }
        return sb.toString();
    }

    public static String getLongestString(String[] array) {
        int maxLength = 0;
        String longestString = null;
        for (String s : array) {
            if (s.length() <= maxLength) continue;
            maxLength = s.length();
            longestString = s;
        }
        return longestString;
    }

    public static String getNonNullString(String originalString) {
        if (originalString == null) {
            return "";
        }
        return originalString;
    }

    private static class Replacement {
        private final String UPPER;
        private final String LOWER;

        Replacement(String ucReplacement, String lcReplacement) {
            this.UPPER = ucReplacement;
            this.LOWER = lcReplacement;
        }

        Replacement(String caseInsensitiveReplacement) {
            this(caseInsensitiveReplacement, caseInsensitiveReplacement);
        }
    }
}

