/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.maven.mp.restclient;

import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ExtCodegenOperation
extends CodegenOperation {
    public List<CodegenParameter> beanParams;
    public boolean beanParam;
    public String beanParamName;
    public List<CodegenParameter> complexQueryParams;
    private final String COMPLEX_QUERY_PARAM_KEY = "complex-query-param";

    public ExtCodegenOperation(CodegenOperation op, Map<String, CodegenModel> codegenModelMap) {
        this.responseHeaders.addAll(op.responseHeaders);
        this.returnTypeIsPrimitive = op.returnTypeIsPrimitive;
        this.returnSimpleType = op.returnSimpleType;
        this.subresourceOperation = op.subresourceOperation;
        this.path = op.path;
        this.operationId = op.operationId;
        this.returnType = op.returnType;
        this.httpMethod = op.httpMethod;
        this.returnBaseType = op.returnBaseType;
        this.returnContainer = op.returnContainer;
        this.summary = op.summary;
        this.unescapedNotes = op.unescapedNotes;
        this.notes = op.notes;
        this.baseName = op.baseName;
        this.defaultResponse = op.defaultResponse;
        this.testPath = op.testPath;
        this.discriminator = op.discriminator;
        this.consumes = op.consumes;
        this.produces = op.produces;
        this.prioritizedContentTypes = op.prioritizedContentTypes;
        this.bodyParam = op.bodyParam;
        this.contents = op.contents;
        this.allParams = op.allParams;
        this.bodyParams = op.bodyParams;
        this.pathParams = op.pathParams;
        this.queryParams = op.queryParams;
        this.headerParams = op.headerParams;
        this.formParams = op.formParams;
        this.requiredParams = op.requiredParams;
        this.authMethods = op.authMethods;
        this.tags = op.tags;
        this.responses = op.responses;
        this.imports = op.imports;
        this.examples = op.examples;
        this.requestBodyExamples = op.requestBodyExamples;
        this.externalDocs = op.externalDocs;
        this.nickname = op.nickname;
        this.operationIdLowerCase = op.operationIdLowerCase;
        this.operationIdCamelCase = op.operationIdCamelCase;
        this.operationIdSnakeCase = op.operationIdSnakeCase;
        this.vendorExtensions = op.vendorExtensions;
        this.beanParams = new ArrayList<CodegenParameter>();
        this.complexQueryParams = new ArrayList<CodegenParameter>();
        if (this.pathParams != null) {
            this.beanParams.addAll(this.pathParams);
        }
        if (this.queryParams != null) {
            this.beanParams.addAll(this.queryParams);
            this.complexQueryParams = this.queryParams.stream().filter(queryParam -> this.isQueryParamAComplexModel(codegenModelMap, (CodegenParameter)queryParam)).collect(Collectors.toList());
            this.complexQueryParams.forEach(this::markAsComplexQueryParam);
            this.allParams.forEach(this::markIfComplexQueryParam);
            this.queryParams.removeAll(this.complexQueryParams);
        }
        if (this.headerParams != null) {
            this.beanParams.addAll(this.headerParams);
        }
        if (this.formParams != null) {
            this.beanParams.addAll(this.formParams);
        }
    }

    private void markAsComplexQueryParam(CodegenParameter param) {
        param.getVendorExtensions().put("x-is-complex-query-param", true);
    }

    private void markIfComplexQueryParam(CodegenParameter param) {
        boolean isComplex = this.complexQueryParams.stream().anyMatch(complexQueryParam -> this.isEquals(param, (CodegenParameter)complexQueryParam));
        if (isComplex) {
            this.markAsComplexQueryParam(param);
        }
    }

    private boolean isQueryParamAComplexModel(Map<String, CodegenModel> codegenModelMap, CodegenParameter param) {
        if (codegenModelMap.containsKey(param.getDataType())) {
            CodegenModel codegenModel = codegenModelMap.get(param.getDataType());
            return codegenModel.getBooleanValue((Object)"x-is-complex-query-param");
        }
        return false;
    }

    private boolean isEquals(CodegenParameter param, CodegenParameter complexQueryParam) {
        return complexQueryParam.getParamName().equals(param.getParamName()) && complexQueryParam.getIsQueryParam().equals(param.getIsQueryParam());
    }

    public List<CodegenParameter> getBeanParams() {
        return this.beanParams;
    }

    public void setBeanParams(List<CodegenParameter> beanParams) {
        this.beanParams = beanParams;
    }

    public boolean isBeanParam() {
        return this.beanParam;
    }

    public void setBeanParam(boolean beanParam) {
        this.beanParam = beanParam;
    }

    public String getBeanParamName() {
        return this.beanParamName;
    }

    public void setBeanParamName(String beanParamName) {
        this.beanParamName = beanParamName;
    }

    public List<CodegenParameter> getComplexQueryParams() {
        return this.complexQueryParams;
    }

    public void setComplexQueryParams(List<CodegenParameter> complexQueryParams) {
        this.complexQueryParams = complexQueryParams;
    }
}

