/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.maven.mp.restclient;

import com.google.googlejavaformat.java.Formatter;
import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenObject;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenParameter;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.generators.java.AbstractJavaJAXRSServerCodegen;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.maven.mp.restclient.ExtCodegenOperation;
import org.tkit.maven.mp.restclient.FieldGenerator;
import org.tkit.maven.mp.restclient.ImplType;
import org.tkit.maven.mp.restclient.JsonLib;

public class MicroProfileRestClientCodegen
extends AbstractJavaJAXRSServerCodegen {
    private static final Logger log = LoggerFactory.getLogger(MicroProfileRestClientCodegen.class);
    private static final String LOMBOK_DATA = "lombokData";
    private static final String LOMBOK_GET_SET = "lombokGetSet";
    private static final String IMPL_REST_CLASS = "implRestClass";
    static final String IMPL_PROXY = "implProxy";
    private static final String FIELD_PUBLIC = "fieldPublic";
    private static final String GENERATE_GETTER_SETTER = "generateGetterSetter";
    private static final String GENERATE_EQUALS = "generateEquals";
    private static final String GENERATE_TO_STRING = "generateToString";
    private static final String JACKSON = "jackson";
    private static final String JSONB = "jsonb";
    static final String INTERFACE_ONLY = "interfaceOnly";
    static final String FORMATTER = "formatter";
    static final String GROUP_BY_TAGS = "groupByTags";
    static final String API_NAME = "apiName";
    static final String PATH_PREFIX = "pathPrefix";
    static final String API_SUFFIX = "apiSuffix";
    static final String PROXY_CLIENT_CLASS = "proxyClientClass";
    static final String ANNOTATIONS = "annotations";
    private static final String HAS_ANNOTATIONS = "hasAnnotations";
    static final String MODEL_ANNOTATIONS = "modelAnnotations";
    private static final String HAS_MODEL_ANNOTATIONS = "hasModelAnnotations";
    static final String BEAN_PARAM_SUFFIX = "beanParamSuffix";
    static final String BEAN_PARAM_COUNT = "beanParamCount";
    static final String RETURN_RESPONSE = "returnResponse";
    static final String JSON_LIB = "jsonLib";
    static final String FIELD_GEN = "fieldGen";
    static final String IMPL_TYPE = "implType";
    static final String USE_BEAN_VALIDATION = "useBeanValidation";
    static final String API_INTERFACE_DOC = "apiInterfaceDoc";
    static final String BAS_PATH_PREFIX = "basePathPrefix";
    static final String PRESERVE_ENUM_CASE = "preserveEnumCase";
    private List<String> outputFiles = new ArrayList<String>();
    private String apiSuffix = "Api";
    private boolean format = true;
    private String apiName = null;
    private boolean groupByTags = false;
    private String pathPrefix = null;
    private String beanParamSuffix = "BeanParam";
    private int beanParamCount = 4;
    private Map<String, CodegenModel> codegenModelMap = new HashMap<String, CodegenModel>();
    private final String COMPLEX_QUERY_PARAM_KEY = "complex-query-param";

    public MicroProfileRestClientCodegen() {
        this.invokerPackage = "io.swagger.api";
        this.artifactId = "swagger-jaxrs-server";
        this.outputFolder = "generated-code/mp-rest-client";
        this.apiPackage = "api";
        this.modelPackage = "model";
        this.additionalProperties.put("title", this.title);
        this.additionalProperties.put(BEAN_PARAM_SUFFIX, this.beanParamSuffix);
        this.additionalProperties.put(LOMBOK_DATA, false);
        this.additionalProperties.put(FIELD_PUBLIC, true);
        this.additionalProperties.put(JSONB, true);
        this.additionalProperties.put(JACKSON, false);
        this.additionalProperties.put(GENERATE_GETTER_SETTER, false);
        this.additionalProperties.put(API_SUFFIX, this.apiSuffix);
        this.additionalProperties.put(RETURN_RESPONSE, true);
        this.additionalProperties.put(PRESERVE_ENUM_CASE, false);
        for (int i = 0; i < this.cliOptions.size(); ++i) {
            if (!"library".equals(((CliOption)this.cliOptions.get(i)).getOpt())) continue;
            this.cliOptions.remove(i);
            break;
        }
        CliOption library = new CliOption("library", "library template (sub-template) to use");
        library.setDefault("<default>");
        LinkedHashMap<String, String> supportedLibraries = new LinkedHashMap<String, String>();
        supportedLibraries.put("<default>", "JAXRS");
        library.setEnum(supportedLibraries);
        this.cliOptions.add(library);
    }

    public void processOpts() {
        super.processOpts();
        this.writePropertyBack(USE_BEAN_VALIDATION, this.useBeanValidation);
        this.additionalProperties.put(HAS_ANNOTATIONS, this.updateCodegenExtraAnnotationList(ANNOTATIONS));
        this.additionalProperties.put(HAS_MODEL_ANNOTATIONS, this.updateCodegenExtraAnnotationList(MODEL_ANNOTATIONS));
        if (this.additionalProperties.containsKey(API_SUFFIX)) {
            this.apiSuffix = (String)this.additionalProperties.get(API_SUFFIX);
        }
        if (this.additionalProperties.containsKey(API_NAME)) {
            this.apiName = (String)this.additionalProperties.get(API_NAME);
        }
        if (this.additionalProperties.containsKey(PATH_PREFIX)) {
            this.pathPrefix = (String)this.additionalProperties.get(PATH_PREFIX);
        }
        if (this.additionalProperties.containsKey(BEAN_PARAM_SUFFIX)) {
            this.beanParamSuffix = (String)this.additionalProperties.get(BEAN_PARAM_SUFFIX);
        }
        if (this.additionalProperties.containsKey(BEAN_PARAM_COUNT)) {
            this.beanParamCount = Integer.parseInt(this.additionalProperties.get(BEAN_PARAM_COUNT).toString());
            this.additionalProperties.put(BEAN_PARAM_COUNT, this.beanParamCount);
        }
        this.groupByTags = this.updateBoolean(GROUP_BY_TAGS, this.groupByTags);
        this.format = this.updateBoolean(FORMATTER, this.format);
        this.updateBoolean(API_INTERFACE_DOC, true);
        this.writePropertyBack(FIELD_PUBLIC, true);
        this.writePropertyBack(LOMBOK_DATA, false);
        this.writePropertyBack(GENERATE_EQUALS, false);
        this.writePropertyBack(GENERATE_TO_STRING, false);
        this.writePropertyBack(GENERATE_GETTER_SETTER, false);
        if (this.additionalProperties.containsKey(FIELD_GEN)) {
            FieldGenerator gen = this.additionalProperties.getOrDefault(FIELD_GEN, FieldGenerator.PUBLIC);
            switch (gen) {
                case PUBLIC: {
                    this.writePropertyBack(FIELD_PUBLIC, true);
                    break;
                }
                case LOMBOK: {
                    this.writePropertyBack(LOMBOK_DATA, true);
                    break;
                }
                case LOMBOK_GET_SET: {
                    this.writePropertyBack(LOMBOK_GET_SET, true);
                    break;
                }
                case GET_SET: {
                    this.writePropertyBack(GENERATE_EQUALS, true);
                    this.writePropertyBack(GENERATE_TO_STRING, true);
                    this.writePropertyBack(GENERATE_GETTER_SETTER, true);
                }
            }
        }
        boolean proxyImplementation = false;
        this.updateBoolean(INTERFACE_ONLY, true);
        boolean interfaceOnly = (Boolean)this.additionalProperties.get(INTERFACE_ONLY);
        if (interfaceOnly) {
            this.writePropertyBack(IMPL_REST_CLASS, false);
        } else {
            this.writePropertyBack(IMPL_REST_CLASS, true);
            if (this.additionalProperties.containsKey(IMPL_TYPE)) {
                ImplType impl = this.additionalProperties.getOrDefault(IMPL_TYPE, ImplType.CLASS);
                switch (impl) {
                    case CLASS: {
                        this.writePropertyBack(IMPL_REST_CLASS, true);
                        break;
                    }
                    case INTERFACE: {
                        this.writePropertyBack(IMPL_REST_CLASS, false);
                        break;
                    }
                    case PROXY: {
                        this.writePropertyBack(IMPL_REST_CLASS, true);
                        this.writePropertyBack(IMPL_PROXY, true);
                        proxyImplementation = true;
                    }
                }
            }
        }
        this.writePropertyBack(JSONB, true);
        this.writePropertyBack(JACKSON, false);
        if (this.additionalProperties.containsKey(JSON_LIB)) {
            JsonLib jsonLib = (JsonLib)((Object)this.additionalProperties.getOrDefault(JSON_LIB, JsonLib.JSONB.name()));
            switch (jsonLib) {
                case JSONB: {
                    this.writePropertyBack(JSONB, true);
                    this.writePropertyBack(JACKSON, false);
                    break;
                }
                case JACKSON: {
                    this.writePropertyBack(JACKSON, true);
                    this.writePropertyBack(JSONB, false);
                }
            }
        }
        this.updateBoolean(RETURN_RESPONSE, true);
        if (StringUtils.isBlank((CharSequence)this.templateDir)) {
            this.embeddedTemplateDir = this.templateDir = this.getTemplateDir();
        }
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.put("api.mustache", ".java");
        this.apiTestTemplateFiles.clear();
        this.modelTestTemplateFiles.clear();
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.supportingFiles.clear();
        if (proxyImplementation) {
            this.modelDocTemplateFiles.clear();
            this.modelTemplateFiles.clear();
        }
    }

    public String getName() {
        return "tkit-mp-rest-client-plugin";
    }

    public String getHelp() {
        return "Micro-profile rest client generator according to JAXRS 2.0 specification.";
    }

    public String customTemplateDir() {
        return this.getDefaultTemplateDir();
    }

    public String getDefaultTemplateDir() {
        return "tkit-mp-rest-client";
    }

    private boolean updateBoolean(String name, boolean value) {
        boolean result = value;
        if (this.additionalProperties.containsKey(name)) {
            result = this.convertPropertyToBoolean(name);
            this.writePropertyBack(name, result);
        }
        return result;
    }

    public String toApiName(String name) {
        if (!this.groupByTags && this.apiName != null) {
            return this.apiName;
        }
        String computed = name;
        if (computed.length() == 0) {
            return "Default" + this.apiSuffix;
        }
        if (this.groupByTags) {
            computed = computed.replace("internal", "");
        }
        computed = this.sanitizeName(computed);
        return MicroProfileRestClientCodegen.camelize((String)computed) + this.apiSuffix;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        if (this.groupByTags) {
            super.addOperationToGroup(tag, resourcePath, operation, co, operations);
            co.subresourceOperation = !co.path.isEmpty();
            return;
        }
        String restPath = resourcePath;
        if (restPath.startsWith("/")) {
            restPath = restPath.substring(1);
        }
        if (this.apiName != null && !this.apiName.isEmpty() && (this.pathPrefix == null || this.pathPrefix.isEmpty()) || "/".equals(this.pathPrefix)) {
            co.baseName = "";
            co.path = restPath;
            co.subresourceOperation = !co.path.isEmpty();
        } else if (this.pathPrefix != null && !this.pathPrefix.isEmpty()) {
            String tmp = this.pathPrefix;
            if (tmp.startsWith("/")) {
                tmp = tmp.substring(1);
            }
            if (!restPath.startsWith(tmp)) {
                log.warn("Resource path `" + resourcePath + "` does not start with a prefix `" + tmp + "` and will be ignored!");
                return;
            }
            co.baseName = tmp;
            int pathPrefixIndex = tmp.endsWith("/") ? tmp.length() : tmp.length() + 1;
            co.path = pathPrefixIndex <= restPath.length() ? restPath.substring(pathPrefixIndex) : "";
            co.subresourceOperation = !co.path.isEmpty();
        } else {
            int index = restPath.indexOf("/");
            if (index > 0) {
                co.baseName = restPath.substring(0, index);
                co.path = restPath.substring(index);
            } else {
                co.baseName = restPath;
                co.path = "";
            }
            co.subresourceOperation = !co.path.isEmpty();
        }
        List opList = operations.computeIfAbsent(co.baseName, v -> new ArrayList());
        opList.add(co);
        int counter = 0;
        for (CodegenOperation op : opList) {
            if (!co.operationId.equals(op.operationId)) continue;
            ++counter;
        }
        if (counter > 1) {
            co.nickname = MicroProfileRestClientCodegen.camelize((String)(tag + "-" + co.operationId), (boolean)true);
        }
        co.operationIdLowerCase = co.operationId.toLowerCase();
        co.operationIdCamelCase = MicroProfileRestClientCodegen.camelize((String)co.operationId);
        co.operationIdSnakeCase = MicroProfileRestClientCodegen.underscore((String)co.operationId);
    }

    public boolean shouldOverwrite(String filename) {
        if (this.outputFiles != null) {
            if (this.outputFiles.contains(filename)) {
                File tmp = new File(filename);
                String f = tmp.getName().replace(".java", "");
                log.error("Wrong plugin configuration. Please check the API schema paths and maven configuration for <groupByTags>, <apiName> and <pathPrefix>.");
                log.error("Add the maven configuration <apiName>{}<apiName>, remove <pathPrefix> and <groupByTags> to generate one java class for open API schema", (Object)f);
                log.error("Remove the <groupByTags> if you what to have one file defined by <groupByTags> and the API schema has more tags.");
                throw new IllegalStateException("File '" + tmp.getName() + "' already generated.");
            }
            this.outputFiles.add(filename);
        }
        return super.shouldOverwrite(filename);
    }

    public void setGitRepoBaseURL(String s) {
    }

    public String getGitRepoBaseURL() {
        return null;
    }

    public boolean checkAliasModel() {
        return false;
    }

    public void processOpenAPI(OpenAPI openAPI) {
        if (this.format) {
            log.info("Google formatter source code");
            if (this.outputFiles != null && !this.outputFiles.isEmpty()) {
                Formatter gf = new Formatter();
                this.outputFiles.forEach(file -> {
                    try {
                        log.debug("Formatter source code: {}", file);
                        Path path = Paths.get(file, new String[0]);
                        String sourceString = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                        sourceString = gf.formatSourceAndFixImports(sourceString);
                        Files.write(path, sourceString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    }
                    catch (Exception ex) {
                        log.error("Skip format source code of the file {} ", file);
                        log.error("Error by formatting the source code", (Throwable)ex);
                    }
                });
            }
        }
        super.processOpenAPI(openAPI);
    }

    private boolean updateCodegenExtraAnnotationList(String name) {
        List items;
        if (this.additionalProperties.containsKey(name) && (items = (List)this.additionalProperties.get(name)) != null && !items.isEmpty()) {
            this.additionalProperties.put(name, items);
            return true;
        }
        return false;
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> schemas, OpenAPI openAPI) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, schemas, openAPI);
        ExtCodegenOperation e = new ExtCodegenOperation(op, this.codegenModelMap);
        e.setBeanParamName(MicroProfileRestClientCodegen.camelize((String)op.operationId) + this.beanParamSuffix);
        if (e.beanParams.size() >= this.beanParamCount) {
            e.setBeanParam(true);
        }
        return e;
    }

    public Map<String, Object> postProcessAllModels(Map<String, Object> processedModels) {
        HashMap<String, CodegenModel> modelMap = new HashMap<String, CodegenModel>();
        processedModels.forEach((key, value) -> {
            Map valueMap = (Map)value;
            List modelsMap = (List)valueMap.get("models");
            modelMap.putAll(modelsMap.stream().collect(Collectors.toMap(map -> ((CodegenModel)map.get("model")).getName(), map -> (CodegenModel)map.get("model"))));
        });
        modelMap.forEach((key, value) -> this.markComplexQueryParams((CodegenModel)value, (Map<String, CodegenModel>)modelMap));
        this.codegenModelMap.putAll(modelMap);
        return super.postProcessAllModels(processedModels);
    }

    public String toEnumVarName(String value, String datatype) {
        boolean preserveEnumCase = (Boolean)this.additionalProperties.get(PRESERVE_ENUM_CASE);
        if (!preserveEnumCase) {
            return super.toEnumVarName(value, datatype);
        }
        if (value.length() == 0) {
            return "EMPTY";
        }
        String var = value.replaceAll("\\W+", "_");
        if (var.matches("\\d.*")) {
            return "_" + var;
        }
        return var;
    }

    public String findCommonPrefixOfVars(List<Object> vars) {
        boolean preserveEnumCase = (Boolean)this.additionalProperties.get(PRESERVE_ENUM_CASE);
        if (!preserveEnumCase) {
            return super.findCommonPrefixOfVars(vars);
        }
        return "";
    }

    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        model.imports.remove("Schema");
        model.imports.remove("JsonSerialize");
        model.imports.remove("ToStringSerializer");
        model.imports.remove("JsonValue");
        model.imports.remove("JsonProperty");
        model.imports.remove("Data");
        model.imports.remove("ToString");
    }

    private void markComplexQueryParams(CodegenModel model, Map<String, CodegenModel> modelMap) {
        for (Map.Entry entry : this.openAPI.getPaths().entrySet()) {
            PathItem pathItem = (PathItem)entry.getValue();
            Set<Parameter> parameters = this.getAllOperationParameters(pathItem);
            parameters.forEach(this.markIfComplexQueryParam(model, modelMap));
        }
    }

    private Consumer<Parameter> markIfComplexQueryParam(CodegenModel model, Map<String, CodegenModel> modelMap) {
        return param -> {
            if (this.isComplexQueryParam(model, (Parameter)param)) {
                this.markAsComplexQueryParam((CodegenObject)model);
                this.markChildrenIfComplexQueryParam(model, modelMap);
            }
        };
    }

    private void markAsComplexQueryParam(CodegenObject codegenObject) {
        codegenObject.getVendorExtensions().put("x-is-complex-query-param", true);
    }

    private void markChildrenIfComplexQueryParam(CodegenModel model, Map<String, CodegenModel> modelMap) {
        if (model.getHasVars().booleanValue() && !model.getVars().isEmpty()) {
            model.getVars().forEach(codegenProperty -> {
                CodegenModel codegenModel;
                if (modelMap.containsKey(codegenProperty.getBaseType()) && this.isCodegenModelAnObject(codegenModel = (CodegenModel)modelMap.get(codegenProperty.getBaseType()))) {
                    this.markAsComplexQueryParam((CodegenObject)codegenProperty);
                    this.markAsComplexQueryParam((CodegenObject)codegenModel);
                    this.markChildrenIfComplexQueryParam(codegenModel, modelMap);
                }
            });
        }
    }

    private boolean isComplexQueryParam(CodegenModel model, Parameter param) {
        CodegenParameter codegenParameter = this.fromParameter(param, new HashSet());
        return model.getClassname().equals(codegenParameter.getDataType()) && this.isCodegenModelAnObject(model) && param.getIn().equals("query");
    }

    private boolean isCodegenModelAnObject(CodegenModel model) {
        return model.getIsPrimitiveType() == false && model.getIsEnum() == false && model.getIsArrayModel() == false && model.getIsListContainer() == false && model.getIsMapContainer() == false;
    }

    private Set<Parameter> getAllOperationParameters(PathItem value) {
        HashSet<Parameter> parameters = new HashSet<Parameter>();
        if (value.getGet() != null && value.getGet().getParameters() != null) {
            parameters.addAll(value.getGet().getParameters());
        }
        if (value.getPut() != null && value.getPut().getParameters() != null) {
            parameters.addAll(value.getPut().getParameters());
        }
        if (value.getPost() != null && value.getPost().getParameters() != null) {
            parameters.addAll(value.getPost().getParameters());
        }
        if (value.getDelete() != null && value.getDelete().getParameters() != null) {
            parameters.addAll(value.getDelete().getParameters());
        }
        if (value.getOptions() != null && value.getOptions().getParameters() != null) {
            parameters.addAll(value.getOptions().getParameters());
        }
        if (value.getHead() != null && value.getHead().getParameters() != null) {
            parameters.addAll(value.getHead().getParameters());
        }
        if (value.getPatch() != null && value.getPatch().getParameters() != null) {
            parameters.addAll(value.getPatch().getParameters());
        }
        if (value.getTrace() != null && value.getTrace().getParameters() != null) {
            parameters.addAll(value.getTrace().getParameters());
        }
        if (value.getParameters() != null && value.getParameters() != null) {
            parameters.addAll(value.getParameters());
        }
        return parameters;
    }
}

