/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.maven.mp.restclient;

import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.ClientOptInput;
import io.swagger.codegen.v3.CodegenConfig;
import io.swagger.codegen.v3.config.CodegenConfigurator;
import io.swagger.codegen.v3.config.CodegenConfiguratorUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.tkit.maven.mp.restclient.FieldGenerator;
import org.tkit.maven.mp.restclient.ImplType;
import org.tkit.maven.mp.restclient.JsonLib;
import org.tkit.maven.mp.restclient.MicroProfileGenerator;
import org.tkit.maven.mp.restclient.MicroProfileRestClientCodegen;

@Mojo(name="codegen", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class MicroProfileRestClientCodegenMojo
extends AbstractMojo {
    @Parameter(name="verbose", required=false, defaultValue="false")
    private boolean verbose;
    @Parameter(name="output", property="mp.rest-client.output", defaultValue="${project.build.directory}/generated-sources/mp-rest-client")
    private File output;
    @Parameter(name="inputSpec", required=true)
    private String inputSpec;
    @Parameter(name="gitUserId", required=false)
    private String gitUserId;
    @Parameter(name="gitRepoId", required=false)
    private String gitRepoId;
    @Parameter(name="templateDirectory")
    private File templateDirectory;
    @Parameter(name="auth")
    private String auth;
    @Parameter(name="configurationFile", required=false)
    private String configurationFile;
    @Parameter(name="skipOverwrite", required=false)
    private Boolean skipOverwrite;
    @Parameter(name="removeOperationIdPrefix", required=false)
    private Boolean removeOperationIdPrefix;
    @Parameter(name="apiPackage")
    private String apiPackage;
    @Parameter(name="modelPackage")
    private String modelPackage;
    @Parameter(name="invokerPackage")
    private String invokerPackage;
    @Parameter(name="groupId")
    private String groupId;
    @Parameter(name="artifactId")
    private String artifactId;
    @Parameter(name="artifactVersion")
    private String artifactVersion;
    @Parameter(name="library", required=false)
    private String library;
    @Parameter(name="modelNamePrefix", required=false)
    private String modelNamePrefix;
    @Parameter(name="modelNameSuffix", required=false)
    private String modelNameSuffix;
    @Parameter(name="ignoreFileOverride", required=false)
    private String ignoreFileOverride;
    @Parameter(name="configOptions")
    private Map<?, ?> configOptions = new HashMap();
    @Parameter(name="instantiationTypes")
    private List<String> instantiationTypes;
    @Parameter(name="importMappings")
    private List<String> importMappings;
    @Parameter(name="typeMappings")
    private List<String> typeMappings;
    @Parameter(name="languageSpecificPrimitives")
    private List<String> languageSpecificPrimitives;
    @Parameter(name="additionalProperties")
    private List<String> additionalProperties;
    @Parameter(name="reservedWordsMappings")
    private List<String> reservedWordsMappings;
    @Parameter(name="generateApis", required=false)
    private Boolean generateApis = true;
    @Parameter(name="generateModels", required=false)
    private Boolean generateModels = true;
    @Parameter(name="modelsToGenerate", required=false)
    private String modelsToGenerate = "";
    @Parameter(name="generateSupportingFiles", required=false)
    private Boolean generateSupportingFiles = false;
    @Parameter(name="supportingFilesToGenerate", required=false)
    private String supportingFilesToGenerate = "";
    @Parameter(name="generateModelTests", required=false)
    private Boolean generateModelTests = true;
    @Parameter(name="generateModelDocumentation", required=false)
    private Boolean generateModelDocumentation = true;
    @Parameter(name="generateApiTests", required=false)
    private Boolean generateApiTests = true;
    @Parameter(name="generateApiDocumentation", required=false)
    private Boolean generateApiDocumentation = true;
    @Parameter(name="withXml", required=false)
    private Boolean withXml = false;
    @Parameter(name="skip", property="codegen.skip", required=false, defaultValue="false")
    private Boolean skip;
    @Parameter(defaultValue="true")
    private boolean addCompileSourceRoot = true;
    @Parameter
    protected Map<String, String> environmentVariables = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> originalEnvironmentVariables = new HashMap<String, String>();
    @Parameter
    private boolean configHelp = false;
    @Parameter(readonly=true, required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(name="formatter", required=false, defaultValue="true")
    private Boolean formatter;
    @Parameter(name="groupByTags", required=false, defaultValue="false")
    private Boolean groupByTags;
    @Parameter(name="apiName", required=false)
    private String apiName;
    @Parameter(name="interfaceOnly", required=false, defaultValue="true")
    private Boolean interfaceOnly;
    @Parameter(name="pathPrefix", required=false)
    private String pathPrefix;
    @Parameter(name="apiSuffix", required=false, defaultValue="RestClient")
    private String apiSuffix;
    @Parameter(name="annotations")
    private List<String> annotations;
    @Parameter(name="modelAnnotations")
    private List<String> modelAnnotations;
    @Parameter(name="returnResponse", required=false, defaultValue="true")
    private Boolean returnResponse;
    @Parameter(name="beanParamSuffix", required=false, defaultValue="BeanParam")
    private String beanParamSuffix;
    @Parameter(name="beanParamCount", required=false, defaultValue="9")
    private String beanParamCount;
    @Parameter(name="jsonLib", required=false, defaultValue="JSONB")
    private JsonLib jsonLib;
    @Parameter(name="fieldGen", required=false, defaultValue="PUBLIC")
    private FieldGenerator fieldGen;
    @Parameter(name="implType", required=false, defaultValue="CLASS")
    private ImplType implType;
    @Parameter(name="dateLibrary", required=false, defaultValue="java8")
    private String dateLibrary;
    @Parameter(name="useBeanValidation", required=false, defaultValue="true")
    private Boolean useBeanValidation;
    @Parameter(name="apiInterfaceDoc", required=false, defaultValue="true")
    private Boolean apiInterfaceDoc;
    @Parameter(name="proxyClientClass", required=false, defaultValue="org.tkit.changeme.proxyClientClass")
    private String proxyClientClass;
    @Parameter(name="basePathPrefix", required=false)
    private String basePathPrefix;
    @Parameter(name="preserveEnumCase", required=false, defaultValue="false")
    private Boolean preserveEnumCase;

    public void execute() throws MojoExecutionException {
        if (this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"Code generation is skipped.");
            this.addCompileSourceRootIfConfigured();
            return;
        }
        CodegenConfigurator configurator = CodegenConfigurator.fromFile((String)this.configurationFile);
        if (configurator == null) {
            configurator = new CodegenConfigurator();
        }
        configurator.setVerbose(this.verbose);
        if (this.skipOverwrite != null) {
            configurator.setSkipOverwrite(this.skipOverwrite.booleanValue());
        }
        if (this.removeOperationIdPrefix != null) {
            configurator.setRemoveOperationIdPrefix(this.removeOperationIdPrefix.booleanValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.inputSpec)) {
            configurator.setInputSpecURL(this.inputSpec);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.gitUserId)) {
            configurator.setGitUserId(this.gitUserId);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.gitRepoId)) {
            configurator.setGitRepoId(this.gitRepoId);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.ignoreFileOverride)) {
            configurator.setIgnoreFileOverride(this.ignoreFileOverride);
        }
        configurator.setLang(MicroProfileRestClientCodegen.class.getName());
        configurator.setOutputDir(this.output.getAbsolutePath());
        if (StringUtils.isNotEmpty((CharSequence)this.auth)) {
            configurator.setAuth(this.auth);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.apiPackage)) {
            configurator.setApiPackage(this.apiPackage);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.modelPackage)) {
            configurator.setModelPackage(this.modelPackage);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.invokerPackage)) {
            configurator.setInvokerPackage(this.invokerPackage);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.groupId)) {
            configurator.setGroupId(this.groupId);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.artifactId)) {
            configurator.setArtifactId(this.artifactId);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.artifactVersion)) {
            configurator.setArtifactVersion(this.artifactVersion);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.library)) {
            configurator.setLibrary(this.library);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.modelNamePrefix)) {
            configurator.setModelNamePrefix(this.modelNamePrefix);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.modelNameSuffix)) {
            configurator.setModelNameSuffix(this.modelNameSuffix);
        }
        if (null != this.templateDirectory) {
            configurator.setTemplateDir(this.templateDirectory.getAbsolutePath());
        }
        if (null != this.generateApis && this.generateApis.booleanValue()) {
            System.setProperty("apis", "");
        } else {
            System.clearProperty("apis");
        }
        if (null != this.generateModels && this.generateModels.booleanValue()) {
            System.setProperty("models", this.modelsToGenerate);
        } else {
            System.clearProperty("models");
        }
        if (null != this.generateSupportingFiles && this.generateSupportingFiles.booleanValue()) {
            System.setProperty("supportingFiles", this.supportingFilesToGenerate);
        } else {
            System.clearProperty("supportingFiles");
        }
        System.setProperty("modelTests", this.generateModelTests.toString());
        System.setProperty("modelDocs", this.generateModelDocumentation.toString());
        System.setProperty("apiTests", this.generateApiTests.toString());
        System.setProperty("apiDocs", this.generateApiDocumentation.toString());
        System.setProperty("withXml", this.withXml.toString());
        if (this.configOptions != null) {
            if (this.instantiationTypes == null && this.configOptions.containsKey("instantiation-types")) {
                CodegenConfiguratorUtils.applyInstantiationTypesKvp((String)this.configOptions.get("instantiation-types").toString(), (CodegenConfigurator)configurator);
            }
            if (this.importMappings == null && this.configOptions.containsKey("import-mappings")) {
                CodegenConfiguratorUtils.applyImportMappingsKvp((String)this.configOptions.get("import-mappings").toString(), (CodegenConfigurator)configurator);
            }
            if (this.typeMappings == null && this.configOptions.containsKey("type-mappings")) {
                CodegenConfiguratorUtils.applyTypeMappingsKvp((String)this.configOptions.get("type-mappings").toString(), (CodegenConfigurator)configurator);
            }
            if (this.languageSpecificPrimitives == null && this.configOptions.containsKey("language-specific-primitives")) {
                CodegenConfiguratorUtils.applyLanguageSpecificPrimitivesCsv((String)this.configOptions.get("language-specific-primitives").toString(), (CodegenConfigurator)configurator);
            }
            if (this.additionalProperties == null && this.configOptions.containsKey("additional-properties")) {
                CodegenConfiguratorUtils.applyAdditionalPropertiesKvp((String)this.configOptions.get("additional-properties").toString(), (CodegenConfigurator)configurator);
            }
            if (this.reservedWordsMappings == null && this.configOptions.containsKey("reserved-words-mappings")) {
                CodegenConfiguratorUtils.applyReservedWordsMappingsKvp((String)this.configOptions.get("reserved-words-mappings").toString(), (CodegenConfigurator)configurator);
            }
        }
        if (!(this.instantiationTypes == null || this.configOptions != null && this.configOptions.containsKey("instantiation-types"))) {
            CodegenConfiguratorUtils.applyInstantiationTypesKvpList(this.instantiationTypes, (CodegenConfigurator)configurator);
        }
        if (!(this.importMappings == null || this.configOptions != null && this.configOptions.containsKey("import-mappings"))) {
            CodegenConfiguratorUtils.applyImportMappingsKvpList(this.importMappings, (CodegenConfigurator)configurator);
        }
        if (!(this.typeMappings == null || this.configOptions != null && this.configOptions.containsKey("type-mappings"))) {
            CodegenConfiguratorUtils.applyTypeMappingsKvpList(this.typeMappings, (CodegenConfigurator)configurator);
        }
        if (!(this.languageSpecificPrimitives == null || this.configOptions != null && this.configOptions.containsKey("language-specific-primitives"))) {
            CodegenConfiguratorUtils.applyLanguageSpecificPrimitivesCsvList(this.languageSpecificPrimitives, (CodegenConfigurator)configurator);
        }
        if (!(this.additionalProperties == null || this.configOptions != null && this.configOptions.containsKey("additional-properties"))) {
            CodegenConfiguratorUtils.applyAdditionalPropertiesKvpList(this.additionalProperties, (CodegenConfigurator)configurator);
        }
        if (!(this.reservedWordsMappings == null || this.configOptions != null && this.configOptions.containsKey("reserved-words-mappings"))) {
            CodegenConfiguratorUtils.applyReservedWordsMappingsKvpList(this.reservedWordsMappings, (CodegenConfigurator)configurator);
        }
        if (this.environmentVariables != null) {
            for (String key : this.environmentVariables.keySet()) {
                this.originalEnvironmentVariables.put(key, System.getProperty(key));
                Iterator value = this.environmentVariables.get(key);
                if (value == null) {
                    value = "";
                }
                System.setProperty(key, (String)((Object)value));
                configurator.addSystemProperty(key, (String)((Object)value));
            }
        }
        configurator.addAdditionalProperty("formatter", (Object)this.formatter);
        configurator.addAdditionalProperty("groupByTags", (Object)this.groupByTags);
        configurator.addAdditionalProperty("apiName", (Object)this.apiName);
        configurator.addAdditionalProperty("interfaceOnly", (Object)this.interfaceOnly);
        configurator.addAdditionalProperty("beanParamSuffix", (Object)this.beanParamSuffix);
        configurator.addAdditionalProperty("beanParamCount", (Object)this.beanParamCount);
        configurator.addAdditionalProperty("pathPrefix", (Object)this.pathPrefix);
        configurator.addAdditionalProperty("apiSuffix", (Object)this.apiSuffix);
        configurator.addAdditionalProperty("annotations", this.annotations);
        configurator.addAdditionalProperty("modelAnnotations", this.modelAnnotations);
        configurator.addAdditionalProperty("returnResponse", (Object)this.returnResponse);
        configurator.addAdditionalProperty("jsonLib", (Object)this.jsonLib);
        configurator.addAdditionalProperty("fieldGen", (Object)this.fieldGen);
        configurator.addAdditionalProperty("implType", (Object)this.implType);
        configurator.addAdditionalProperty("proxyClientClass", (Object)this.proxyClientClass);
        configurator.addAdditionalProperty("dateLibrary", (Object)this.dateLibrary);
        configurator.addAdditionalProperty("useBeanValidation", (Object)this.useBeanValidation);
        configurator.addAdditionalProperty("apiInterfaceDoc", (Object)this.apiInterfaceDoc);
        configurator.addAdditionalProperty("basePathPrefix", (Object)this.basePathPrefix);
        configurator.addAdditionalProperty("preserveEnumCase", (Object)this.preserveEnumCase);
        ClientOptInput input = configurator.toClientOptInput();
        CodegenConfig config = input.getConfig();
        if (this.configOptions != null) {
            for (CliOption langCliOption : config.cliOptions()) {
                if (!this.configOptions.containsKey(langCliOption.getOpt())) continue;
                input.getConfig().additionalProperties().put(langCliOption.getOpt(), this.configOptions.get(langCliOption.getOpt()));
            }
        }
        if (this.configHelp) {
            for (CliOption langCliOption : config.cliOptions()) {
                System.out.println("\t" + langCliOption.getOpt());
                System.out.println("\t    " + langCliOption.getOptionHelp().replaceAll("\n", "\n\t    "));
                System.out.println();
            }
            return;
        }
        try {
            new MicroProfileGenerator().opts(input).generate();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Code generation failed. See above for the full exception.");
        }
        this.addCompileSourceRootIfConfigured();
    }

    private void addCompileSourceRootIfConfigured() {
        if (this.addCompileSourceRoot) {
            Object sourceFolderObject = this.configOptions == null ? null : (Object)this.configOptions.get("sourceFolder");
            String sourceFolder = sourceFolderObject == null ? "src/main/java" : sourceFolderObject.toString();
            String sourceJavaFolder = this.output.toString() + "/" + sourceFolder;
            this.project.addCompileSourceRoot(sourceJavaFolder);
        }
        for (Map.Entry<String, String> entry : this.originalEnvironmentVariables.entrySet()) {
            if (entry.getValue() == null) {
                System.clearProperty(entry.getKey());
                continue;
            }
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }
}

