/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.googlecloudstorage.repository;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;
import org.togglz.core.util.FeatureStateStorageWrapper;
import org.togglz.googlecloudstorage.repository.GoogleCloudStorageStateRepositoryException;

public final class GoogleCloudStorageStateRepository
implements StateRepository {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Storage storageClient;
    private final String bucketName;
    private final String prefix;

    private GoogleCloudStorageStateRepository(Builder builder) {
        this.bucketName = builder.bucketName;
        this.prefix = builder.prefix;
        this.storageClient = builder.storageClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    public FeatureState getFeatureState(Feature feature) {
        try {
            byte[] content;
            Blob blob = this.storageClient.get(BlobId.of((String)this.bucketName, (String)(this.prefix + feature.name())));
            if (blob != null && (content = blob.getContent(new Blob.BlobSourceOption[0])) != null && content.length > 0) {
                FeatureStateStorageWrapper wrapper = (FeatureStateStorageWrapper)this.objectMapper.reader().forType(FeatureStateStorageWrapper.class).readValue(content);
                return FeatureStateStorageWrapper.featureStateForWrapper((Feature)feature, (FeatureStateStorageWrapper)wrapper);
            }
        }
        catch (IOException e) {
            throw new GoogleCloudStorageStateRepositoryException("Failed to get the feature state", e);
        }
        return null;
    }

    public void setFeatureState(FeatureState featureState) {
        try {
            FeatureStateStorageWrapper storageWrapper = FeatureStateStorageWrapper.wrapperForFeatureState((FeatureState)featureState);
            String json = this.objectMapper.writeValueAsString((Object)storageWrapper);
            BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)BlobId.of((String)this.bucketName, (String)(this.prefix + featureState.getFeature().name()))).build();
            this.storageClient.create(blobInfo, json.getBytes(StandardCharsets.UTF_8), new Storage.BlobTargetOption[0]);
        }
        catch (JsonProcessingException e) {
            throw new GoogleCloudStorageStateRepositoryException("Failed to set the feature state", e);
        }
    }

    public static final class Builder {
        private Storage storageClient;
        private String bucketName;
        private String prefix = "";

        private Builder() {
        }

        public Builder storageClient(Storage storageClient) {
            this.storageClient = storageClient;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix == null ? "" : prefix;
            return this;
        }

        public GoogleCloudStorageStateRepository build() {
            return new GoogleCloudStorageStateRepository(this);
        }
    }
}

