/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.testing;

import java.util.HashSet;
import java.util.Set;
import org.togglz.core.Feature;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.user.FeatureUser;

public class TestFeatureManager
implements FeatureManager {
    private final Class<? extends Feature> featureClass;
    private final Set<Feature> activeFeatures = new HashSet<Feature>();

    public TestFeatureManager(Class<? extends Feature> featureClass) {
        this.featureClass = featureClass;
    }

    public Feature[] getFeatures() {
        return this.featureClass.getEnumConstants();
    }

    public boolean isActive(Feature feature) {
        return this.activeFeatures.contains(feature);
    }

    public FeatureUser getCurrentFeatureUser() {
        return null;
    }

    public FeatureState getFeatureState(Feature feature) {
        return new FeatureState(feature, this.isActive(feature));
    }

    public void setFeatureState(FeatureState state) {
        if (state.isEnabled()) {
            this.activeFeatures.add(state.getFeature());
        } else {
            this.activeFeatures.remove(state.getFeature());
        }
    }

    public TestFeatureManager enable(Feature feature) {
        this.activeFeatures.add(feature);
        return this;
    }

    public TestFeatureManager disable(Feature feature) {
        this.activeFeatures.remove(feature);
        return this;
    }

    public TestFeatureManager enableAll() {
        for (Feature feature : this.featureClass.getEnumConstants()) {
            this.enable(feature);
        }
        return this;
    }

    public TestFeatureManager disableAll() {
        this.activeFeatures.clear();
        return this;
    }
}

