/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.cli.api.format;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Table {
    private static final String COL_SEP = "|";
    private static final String HEADER_CHAR = "=";
    private static final String LINE_CHAR = "-";
    private static final char EMPTY_CHAR = ' ';
    private final List<Row> rows = new LinkedList<Row>();
    private final String cr = System.lineSeparator();
    private final Row header;

    public Table(String ... header) {
        this.header = new Row(Arrays.asList(header));
    }

    public Table row(Object ... columns) {
        if (!this.rows.isEmpty() && this.rows.iterator().next().columns.length != columns.length) {
            throw new IllegalArgumentException("columns should have all the same size");
        }
        ArrayList<String> str = new ArrayList<String>(columns.length);
        for (Object o : columns) {
            str.add(String.valueOf(o));
        }
        this.rows.add(new Row(str));
        return this;
    }

    public Table sort() {
        Collections.sort(this.rows);
        return this;
    }

    public void print(PrintStream printStream, boolean horizontal) {
        if (horizontal) {
            this.printHorizontal(printStream);
        } else {
            this.printVertical(printStream);
        }
    }

    public void printHorizontal(PrintStream printStream) {
        ArrayList<Integer> width = new ArrayList<Integer>(this.rows.size());
        for (int i = 0; i < this.header.columns.length; ++i) {
            if (width.size() > i) continue;
            width.add(this.header.columns[i].length());
        }
        for (Row r : this.rows) {
            for (int i = 0; i < r.columns.length; ++i) {
                width.set(i, Math.max((Integer)width.get(i), r.columns[i].length()));
            }
        }
        int columnWidth = 0;
        for (Integer i : width) {
            columnWidth += i.intValue();
        }
        this.sepLineHorizontal(printStream, columnWidth, HEADER_CHAR);
        printStream.print(COL_SEP);
        this.printLineHorizontal(printStream, width, this.header.columns);
        printStream.print(this.cr);
        this.sepLineHorizontal(printStream, columnWidth, HEADER_CHAR);
        for (Row line : this.rows) {
            printStream.print(COL_SEP);
            this.printLineHorizontal(printStream, width, line.columns);
            printStream.print(this.cr);
        }
        this.sepLineHorizontal(printStream, columnWidth, LINE_CHAR);
        printStream.print(this.cr);
    }

    private void printLineHorizontal(PrintStream printStream, List<Integer> width, String[] items) {
        for (int i = 0; i < items.length; ++i) {
            printStream.print(' ' + this.center(items[i], width.get(i)) + ' ' + COL_SEP);
        }
    }

    private void sepLineHorizontal(PrintStream printStream, int width, String sep) {
        for (int i = 0; i < width + 1 + this.header.columns.length * 3; ++i) {
            printStream.print(sep);
        }
        printStream.print(this.cr);
    }

    public void printVertical(PrintStream printStream) {
        int headerWidth = this.lineWidth(this.header);
        for (Row line : this.rows) {
            int width = this.lineWidth(line);
            this.sepLineVertical(printStream, width, headerWidth);
            for (int idx = 0; idx < this.header.columns.length; ++idx) {
                printStream.print("|| ");
                printStream.print(this.center(this.header.columns[idx], headerWidth));
                printStream.print(" ||");
                printStream.print(' ' + this.center(line.columns[idx], width) + ' ' + COL_SEP);
                printStream.print(this.cr);
            }
            this.sepLineVertical(printStream, width, headerWidth);
            printStream.print(this.cr);
        }
    }

    private int lineWidth(Row line) {
        int width = 0;
        for (String h : line.columns) {
            if (h.length() <= width) continue;
            width = h.length();
        }
        return width;
    }

    private void printLineVertical(PrintStream printStream, List<Integer> width, String[] items) {
        for (int i = 0; i < items.length; ++i) {
            printStream.print(' ' + this.center(items[i], width.get(i)) + ' ' + COL_SEP);
        }
    }

    private void sepLineVertical(PrintStream printStream, int width, int headerWidth) {
        int i;
        for (i = 0; i < headerWidth + 5; ++i) {
            printStream.print(HEADER_CHAR);
        }
        for (i = 0; i < width + 4; ++i) {
            printStream.print(LINE_CHAR);
        }
        printStream.print(this.cr);
    }

    private String center(String text, int len) {
        int i;
        if (text.length() >= len) {
            return text;
        }
        StringBuilder builder = new StringBuilder(len);
        int empty = len - text.length();
        for (i = 0; i < empty / 2; ++i) {
            builder.append(' ');
        }
        builder.append(text);
        for (i = 0; i < empty - empty / 2; ++i) {
            builder.append(' ');
        }
        return builder.toString();
    }

    public boolean hasContent() {
        return !this.rows.isEmpty();
    }

    private static class Row
    implements Comparable<Row> {
        private final String[] columns;

        private Row(Collection<String> columns) {
            this.columns = columns.toArray(new String[columns.size()]);
        }

        @Override
        public int compareTo(Row o) {
            for (int i = 0; i < this.columns.length; ++i) {
                int cmp = String.valueOf(this.columns[i]).compareTo(String.valueOf(o.columns[i]));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }
}

