/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.cli.impl;

import java.util.ArrayList;
import java.util.List;

public class CommandParser {
    public Command[] toArgs(String line) {
        if (line == null || line.isEmpty()) {
            throw new IllegalArgumentException("Empty command.");
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        char waitChar = ' ';
        boolean copyNextChar = false;
        boolean inEscaped = false;
        block5: for (char c : line.toCharArray()) {
            if (copyNextChar) {
                current.append(c);
                copyNextChar = false;
                continue;
            }
            if (waitChar == c) {
                if (current.length() > 0) {
                    result.add(current.toString());
                    current.setLength(0);
                }
                waitChar = ' ';
                inEscaped = false;
                continue;
            }
            switch (c) {
                case '\"': 
                case '\'': {
                    if (!inEscaped) {
                        waitChar = c;
                        inEscaped = true;
                        continue block5;
                    }
                    current.append(c);
                    continue block5;
                }
                case '\\': {
                    copyNextChar = true;
                    continue block5;
                }
                case '|': {
                    this.flush(commands, result, current);
                    continue block5;
                }
                default: {
                    current.append(c);
                }
            }
        }
        if (waitChar != ' ') {
            throw new IllegalStateException("Missing closing " + Character.toString(waitChar));
        }
        this.flush(commands, result, current);
        return commands.toArray(new Command[commands.size()]);
    }

    private void flush(List<Command> commands, List<String> result, StringBuilder current) {
        if (current.length() > 0) {
            result.add(current.toString());
            current.setLength(0);
        }
        if (!result.isEmpty()) {
            commands.add(new Command(result.toArray(new String[result.size()])));
            result.clear();
        }
    }

    public static final class Command {
        private String[] args;

        private Command(String[] strings) {
            this.args = strings;
        }

        public String[] getArgs() {
            return this.args;
        }
    }
}

