/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.jaws.s3;

import java.util.Objects;

public class Path {
    private final String name;
    private final String absoluteName;
    private final String parent;
    public static final Path ROOT = new Path("", "", null){

        @Override
        public Path getParent() {
            return null;
        }

        @Override
        public Path getChild(String name) {
            return Path.fromKey(name);
        }

        @Override
        public String getSearchPrefix() {
            return null;
        }
    };

    private Path(String name, String absoluteName, String parent) {
        this.name = name;
        this.absoluteName = absoluteName;
        this.parent = parent;
    }

    public static Path fromKey(String key) {
        if ("".equals(key = Path.normalize(key))) {
            return ROOT;
        }
        int lastSlash = key.lastIndexOf(47) + 1;
        if (lastSlash == 0) {
            return new Path(key, key, null);
        }
        String name = key.substring(lastSlash);
        String parent = key.substring(0, lastSlash);
        return new Path(name, key, parent);
    }

    private static String normalize(String key) {
        if (!key.endsWith("/")) {
            return key;
        }
        return Path.normalize(key.substring(0, key.length() - 1));
    }

    public static Path root() {
        return ROOT;
    }

    public String getName() {
        return this.name;
    }

    public String getAbsoluteName() {
        return this.absoluteName;
    }

    public String getSearchPrefix() {
        return this.absoluteName + "/";
    }

    public Path getParent() {
        return this.parent == null ? ROOT : Path.fromKey(this.parent);
    }

    public Path getChild(String name) {
        if (name.contains("/")) {
            return Path.fromKey(this.absoluteName + "/" + name);
        }
        return new Path(name, this.absoluteName + "/" + name, this.absoluteName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path path = (Path)o;
        return this.absoluteName.equals(path.absoluteName);
    }

    public int hashCode() {
        return Objects.hash(this.absoluteName);
    }
}

