/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.jaws.s3;

import com.amazonaws.services.s3.model.ListObjectsRequest;
import java.io.FileNotFoundException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.tomitribe.jaws.s3.Delimiter;
import org.tomitribe.jaws.s3.Filter;
import org.tomitribe.jaws.s3.Filters;
import org.tomitribe.jaws.s3.Marker;
import org.tomitribe.jaws.s3.Prefix;
import org.tomitribe.jaws.s3.S3Bucket;
import org.tomitribe.jaws.s3.S3File;
import org.tomitribe.util.dir.Name;
import org.tomitribe.util.dir.Walk;
import org.tomitribe.util.reflect.Generics;

public interface S3 {
    public S3File get();

    public S3File parent();

    public S3File file(String var1);

    public Stream<S3File> files();

    public static <T> T of(Class<T> clazz, S3Bucket bucket) {
        return S3.of(clazz, bucket.asFile());
    }

    public static <T> T of(Class<T> clazz, S3File file) {
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)new S3Handler(file));
    }

    public static class S3Handler
    implements InvocationHandler {
        private final S3File dir;

        public S3Handler(S3File dir) {
            this.dir = dir;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.isDefault()) {
                return S3Handler.invokeDefault(proxy, method, args);
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                if (method.getName().equals("toString")) {
                    return this.toString();
                }
                if (method.getName().equals("equals")) {
                    return this.equals(proxy, args);
                }
                if (method.getName().equals("hashCode")) {
                    return this.hashCode();
                }
            }
            if (method.getDeclaringClass().equals(S3.class)) {
                if (method.getName().equals("get")) {
                    return this.dir;
                }
                if (method.getName().equals("parent")) {
                    return this.dir.getParentFile();
                }
                if (method.getName().equals("files")) {
                    return this.files();
                }
                if (method.getName().equals("file") && this.hasStringArg(method)) {
                    return this.file(args);
                }
                throw new IllegalStateException("Unknown method " + method);
            }
            S3File file = this.dir.getFile(this.name(method));
            Class<?> returnType = method.getReturnType();
            if (returnType.isArray()) {
                return this.returnArray(method);
            }
            if (Stream.class.equals(returnType) && args == null) {
                return this.returnStream(method);
            }
            if (List.class.equals(returnType) && args == null) {
                return this.returnList(method);
            }
            if (Set.class.equals(returnType) && args == null) {
                return this.returnSet(method);
            }
            if (Collection.class.equals(returnType) && args == null) {
                return this.returnList(method);
            }
            if (S3File.class.equals(returnType) && args == null) {
                return this.returnFile(method, file);
            }
            if (returnType.isInterface() && args != null && args.length == 1 && args[0] instanceof String) {
                return S3.of(returnType, this.dir.getFile((String)args[0]));
            }
            if (returnType.isInterface() && args == null) {
                return S3.of(returnType, file);
            }
            throw new UnsupportedOperationException(method.toGenericString());
        }

        private boolean hasStringArg(Method method) {
            Class<?>[] types = method.getParameterTypes();
            if (types.length != 1) {
                return false;
            }
            return types[0].equals(String.class);
        }

        private Stream<S3File> files() {
            return this.dir.files();
        }

        private S3File file(Object[] args) {
            return this.file((String)args[0]);
        }

        private S3File file(String name) {
            return this.dir.getFile(name);
        }

        private String name(Method method) {
            if (method.isAnnotationPresent(Name.class)) {
                return method.getAnnotation(Name.class).value();
            }
            return method.getName();
        }

        private boolean equals(Object proxy, Object[] args) {
            if (args.length != 1) {
                return false;
            }
            if (args[0] == null) {
                return false;
            }
            if (!proxy.getClass().isAssignableFrom(args[0].getClass())) {
                return false;
            }
            InvocationHandler handler = Proxy.getInvocationHandler(args[0]);
            return this.equals(handler);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            S3Handler that = (S3Handler)o;
            return this.dir.equals(that.dir);
        }

        public int hashCode() {
            return this.dir.hashCode();
        }

        private static Object invokeDefault(Object proxy, Method method, Object[] args) throws Throwable {
            float version = Float.parseFloat(System.getProperty("java.class.version"));
            if (version <= 52.0f) {
                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
                constructor.setAccessible(true);
                Class<?> clazz = method.getDeclaringClass();
                return ((MethodHandles.Lookup)constructor.newInstance(clazz)).in(clazz).unreflectSpecial(method, clazz).bindTo(proxy).invokeWithArguments(args);
            }
            return MethodHandles.lookup().findSpecial(method.getDeclaringClass(), method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(args);
        }

        private Object returnFile(Method method, S3File file) throws FileNotFoundException {
            if (this.exceptions(method).contains(FileNotFoundException.class) && !file.exists()) {
                throw new FileNotFoundException(file.getAbsoluteName());
            }
            return file;
        }

        public List<Class<?>> exceptions(Method method) {
            Class<?>[] exceptionTypes = method.getExceptionTypes();
            return Arrays.asList(exceptionTypes);
        }

        private Object returnArray(Method method) {
            Predicate<S3File> filter = this.getFilter(method);
            Class<?> arrayType = method.getReturnType().getComponentType();
            if (S3File.class.equals(arrayType)) {
                return this.stream(method).filter(filter).toArray(S3File[]::new);
            }
            if (arrayType.isInterface()) {
                Object[] src = this.stream(method).filter(filter).map(child -> S3.of(arrayType, child)).toArray();
                Object[] dest = (Object[])Array.newInstance(arrayType, src.length);
                System.arraycopy(src, 0, dest, 0, src.length);
                return dest;
            }
            throw new UnsupportedOperationException(method.toGenericString());
        }

        private Object returnList(Method method) {
            Class listType = (Class)Generics.getReturnType((Method)method);
            Predicate<S3File> filter = this.getFilter(method);
            if (S3File.class.equals((Object)listType)) {
                return this.stream(method).filter(filter).collect(Collectors.toList());
            }
            if (listType.isInterface()) {
                return this.stream(method).filter(filter).map(child -> S3.of(listType, child)).collect(Collectors.toList());
            }
            throw new UnsupportedOperationException(method.toGenericString());
        }

        private Object returnSet(Method method) {
            Class listType = (Class)Generics.getReturnType((Method)method);
            Predicate<S3File> filter = this.getFilter(method);
            if (S3File.class.equals((Object)listType)) {
                return this.stream(method).filter(filter).collect(Collectors.toSet());
            }
            if (listType.isInterface()) {
                return this.stream(method).filter(filter).map(child -> S3.of(listType, child)).collect(Collectors.toSet());
            }
            throw new UnsupportedOperationException(method.toGenericString());
        }

        private Predicate<S3File> getFilter(Method method) {
            if (method.isAnnotationPresent(Filter.class)) {
                Filter filter = method.getAnnotation(Filter.class);
                return this.asPredicate(filter);
            }
            if (method.isAnnotationPresent(Filters.class)) {
                Filters filters = method.getAnnotation(Filters.class);
                Predicate<S3File> predicate = file -> true;
                for (Filter filter : filters.value()) {
                    predicate = predicate.and(this.asPredicate(filter));
                }
                return predicate;
            }
            return pathname -> true;
        }

        private Predicate<S3File> asPredicate(Filter filter) {
            if (filter == null) {
                return pathname -> true;
            }
            Class<? extends Predicate<S3File>> clazz = filter.value();
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to instantiate filter " + clazz, e);
            }
        }

        private Object returnStream(Method method) {
            Class returnType = (Class)Generics.getReturnType((Method)method);
            Predicate<S3File> filter = this.getFilter(method);
            if (returnType.isInterface()) {
                return this.stream(method).filter(filter).map(child -> S3.of(returnType, child));
            }
            if (S3File.class.equals((Object)returnType)) {
                return this.stream(method).filter(filter);
            }
            throw new UnsupportedOperationException(method.toGenericString());
        }

        private Stream<S3File> stream(Method method) {
            Walk walk = method.getAnnotation(Walk.class);
            if (walk != null) {
                return S3Handler.walk(walk, this.dir);
            }
            ListObjectsRequest request = new ListObjectsRequest();
            if (method.isAnnotationPresent(Prefix.class)) {
                Prefix prefix = method.getAnnotation(Prefix.class);
                request.setPrefix(this.dir.getPath().getSearchPrefix() + prefix.value());
            }
            if (method.isAnnotationPresent(Marker.class)) {
                Marker marker = method.getAnnotation(Marker.class);
                request.setMarker(marker.value());
            }
            if (method.isAnnotationPresent(Delimiter.class)) {
                Delimiter delimiter = method.getAnnotation(Delimiter.class);
                request.setDelimiter(delimiter.value());
            }
            return this.dir.files(request);
        }

        private static Stream<S3File> walk(Walk walk, S3File dir) {
            return S3Handler.walk(dir, walk.maxDepth(), walk.minDepth());
        }

        private static Stream<S3File> walk(S3File dir, int maxDepth, int minDepth) {
            Predicate<S3File> min;
            Predicate<S3File> predicate = min = minDepth <= 0 ? s3File -> true : S3Handler.minDepth(dir, minDepth);
            if (maxDepth != -1) {
                return dir.walk(maxDepth).filter(min);
            }
            return dir.walk().filter(min);
        }

        private static Predicate<S3File> minDepth(S3File dir, int minDepth) {
            int parentDepth = S3Handler.getDepth(dir);
            return s3File -> {
                int s3FileDepth = S3Handler.getDepth(s3File);
                int depth = s3FileDepth - parentDepth;
                return depth >= minDepth;
            };
        }

        private static int getDepth(S3File dir) {
            int depth = 0;
            S3File f = dir;
            while (f != null) {
                f = f.getParentFile();
                ++depth;
            }
            return depth;
        }

        public String toString() {
            return this.dir.getAbsoluteName();
        }
    }
}

