/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.jaws.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.stream.Stream;
import org.tomitribe.jaws.s3.NoSuchS3ObjectException;
import org.tomitribe.jaws.s3.S3Client;
import org.tomitribe.jaws.s3.S3File;
import org.tomitribe.jaws.s3.S3OutputStream;

public class S3Bucket {
    private final S3Client client;
    private final Bucket bucket;
    private final AmazonS3 s3;

    public S3Bucket(S3Client client, Bucket bucket) {
        this.client = client;
        this.bucket = bucket;
        this.s3 = client.getS3();
    }

    public S3Client getClient() {
        return this.client;
    }

    public S3File asFile() {
        return S3File.rootFile(this);
    }

    public Stream<S3File> objects() {
        ObjectListingIterator iterator = new ObjectListingIterator(this.bucket.getName());
        return S3Client.asStream(iterator).map(s3ObjectSummary -> new S3File(this, (S3ObjectSummary)s3ObjectSummary));
    }

    public Stream<S3File> objects(ListObjectsRequest request) {
        request.setBucketName(this.bucket.getName());
        ObjectListingIterator iterator = new ObjectListingIterator(request);
        return S3Client.asStream(iterator).map(s3ObjectSummary -> new S3File(this, (S3ObjectSummary)s3ObjectSummary));
    }

    public PutObjectResult putObject(String key, File file) throws SdkClientException, AmazonServiceException {
        return this.s3.putObject(this.bucket.getName(), key, file);
    }

    public PutObjectResult putObject(String key, InputStream inputStream, ObjectMetadata objectMetadata) throws SdkClientException, AmazonServiceException {
        return this.s3.putObject(this.bucket.getName(), key, inputStream, objectMetadata);
    }

    public PutObjectResult putObject(String key, String s2) throws AmazonServiceException, SdkClientException {
        return this.s3.putObject(this.bucket.getName(), key, s2);
    }

    public S3Object getObject(String key) throws SdkClientException, AmazonServiceException {
        return this.s3.getObject(this.bucket.getName(), key);
    }

    public S3File getFile(String key) throws SdkClientException, AmazonServiceException {
        return new S3File(this, this.getObject(key));
    }

    public S3ObjectInputStream getObjectAsStream(String key) throws SdkClientException, AmazonServiceException {
        try {
            S3Object object = this.s3.getObject(this.bucket.getName(), key);
            if (object == null) {
                throw new NoSuchS3ObjectException(this.bucket.getName(), key);
            }
            return object.getObjectContent();
        }
        catch (AmazonS3Exception e) {
            if (e.getMessage().contains("The specified key does not exist")) {
                throw new NoSuchS3ObjectException(this.bucket.getName(), key, e);
            }
            throw e;
        }
    }

    public String getObjectAsString(String key) throws AmazonServiceException, SdkClientException {
        try {
            return this.s3.getObjectAsString(this.bucket.getName(), key);
        }
        catch (AmazonS3Exception e) {
            if (e.getMessage().contains("The specified key does not exist")) {
                throw new NoSuchS3ObjectException(this.bucket.getName(), key, e);
            }
            throw e;
        }
    }

    public S3OutputStream setObjectAsStream(String key) {
        return new S3OutputStream(this.getClient().getS3(), this.bucket.getName(), key);
    }

    public PutObjectResult setObjectAsString(String key, String value) {
        AmazonS3 s3 = this.getClient().getS3();
        return s3.putObject(this.bucket.getName(), key, value);
    }

    public PutObjectResult setObjectAsFile(String key, File value) {
        AmazonS3 s3 = this.getClient().getS3();
        return s3.putObject(this.bucket.getName(), key, value);
    }

    public PutObjectResult setObjectAsStream(String key, InputStream value) {
        AmazonS3 s3 = this.getClient().getS3();
        return s3.putObject(this.bucket.getName(), key, value, new ObjectMetadata());
    }

    public void deleteObject(String key) {
        this.s3.deleteObject(new DeleteObjectRequest(this.bucket.getName(), key));
    }

    public Owner getOwner() {
        return this.bucket.getOwner();
    }

    public void setOwner(Owner owner) {
        this.bucket.setOwner(owner);
    }

    public Date getCreationDate() {
        return this.bucket.getCreationDate();
    }

    public void setCreationDate(Date creationDate) {
        this.bucket.setCreationDate(creationDate);
    }

    public String getName() {
        return this.bucket.getName();
    }

    public void setName(String name) {
        this.bucket.setName(name);
    }

    class ObjectListingIterator
    implements Iterator<S3ObjectSummary> {
        private Iterator<S3ObjectSummary> iterator;
        private ObjectListing objectListing;

        public ObjectListingIterator(String bucketName) {
            this.objectListing = S3Bucket.this.client.getS3().listObjects(bucketName);
            this.iterator = this.objectListing.getObjectSummaries().iterator();
        }

        public ObjectListingIterator(ListObjectsRequest bucketName) {
            this.objectListing = S3Bucket.this.client.getS3().listObjects(bucketName);
            this.iterator = this.objectListing.getObjectSummaries().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.iterator.hasNext()) {
                return true;
            }
            if (!this.objectListing.isTruncated()) {
                return false;
            }
            this.objectListing = S3Bucket.this.client.getS3().listNextBatchOfObjects(this.objectListing);
            this.iterator = this.objectListing.getObjectSummaries().iterator();
            return this.hasNext();
        }

        @Override
        public S3ObjectSummary next() {
            return this.iterator.next();
        }
    }
}

