/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.jaws.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Bucket;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.tomitribe.jaws.NoSuchBucketException;
import org.tomitribe.jaws.s3.S3Bucket;

public class S3Client {
    private final AmazonS3 s3;

    public S3Client(AmazonS3 s3) {
        this.s3 = s3;
    }

    public static <T> Stream<T> asStream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    public S3Bucket createBucket(String s) throws SdkClientException, AmazonServiceException {
        Bucket bucket = this.s3.createBucket(s);
        return new S3Bucket(this, bucket);
    }

    public S3Bucket getBucket(String name) {
        Bucket bucket = this.s3.listBuckets().stream().filter(item -> name.equals(item.getName())).findAny().orElseThrow(() -> new NoSuchBucketException(name));
        return new S3Bucket(this, bucket);
    }

    public Stream<S3Bucket> buckets() {
        return this.s3.listBuckets().stream().map(bucket -> new S3Bucket(this, (Bucket)bucket));
    }

    public AmazonS3 getS3() {
        return this.s3;
    }
}

