/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.jaws.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.tomitribe.jaws.s3.NoSuchS3ObjectException;
import org.tomitribe.jaws.s3.Path;
import org.tomitribe.jaws.s3.S3Bucket;
import org.tomitribe.jaws.s3.S3Client;
import org.tomitribe.jaws.s3.S3OutputStream;
import org.tomitribe.util.IO;

public class S3File {
    private final S3Bucket bucket;
    private final Path path;
    private final AtomicReference<Node> node = new AtomicReference();

    S3File(S3Bucket bucket, S3ObjectSummary summary) {
        this.bucket = bucket;
        this.path = Path.fromKey(summary.getKey());
        this.node.set(new ObjectSummary(summary));
    }

    S3File(S3Bucket bucket, S3Object object) {
        this.bucket = bucket;
        this.path = Path.fromKey(object.getKey());
        this.node.set(new Object(object));
    }

    S3File(S3Bucket bucket, Path path, Class<? extends Node> type) {
        this.bucket = bucket;
        this.path = path;
        this.node.set(this.nodeInstance(type));
    }

    private Node nodeInstance(Class<? extends Node> type) {
        if (Directory.class.equals(type)) {
            return new Directory();
        }
        if (NewObject.class.equals(type)) {
            return new NewObject();
        }
        if (Unknown.class.equals(type)) {
            return new Unknown();
        }
        throw new IllegalArgumentException("Unsupported node type: " + type.getSimpleName());
    }

    static S3File rootFile(S3Bucket bucket) {
        return new S3File(bucket, Path.ROOT, Directory.class);
    }

    public Path getPath() {
        return this.path;
    }

    public boolean exists() {
        return this.node.get().exists();
    }

    public boolean isFile() {
        return this.node.get().isFile();
    }

    public boolean isDirectory() {
        return this.node.get().isDirectory();
    }

    public S3File getParentFile() {
        Path parent = this.path.getParent();
        if (parent == null) {
            return null;
        }
        return new S3File(this.bucket, parent, Directory.class);
    }

    public S3File getFile(String name) {
        return this.node.get().getFile(name);
    }

    public Stream<S3File> files() {
        return this.node.get().files();
    }

    public Stream<S3File> files(ListObjectsRequest request) {
        return this.node.get().files(request);
    }

    public Stream<S3File> walk() {
        return this.node.get().walk(Integer.MAX_VALUE);
    }

    public Stream<S3File> walk(int maxDepth) {
        return this.node.get().walk(maxDepth);
    }

    public String getAbsoluteName() {
        return this.path.getAbsoluteName();
    }

    public String getName() {
        return this.path.getName();
    }

    public S3Bucket getBucket() {
        return this.bucket;
    }

    public S3ObjectInputStream getValueAsStream() {
        return this.node.get().getValueAsStream();
    }

    public String getValueAsString() {
        return this.node.get().getValueAsString();
    }

    public S3OutputStream setValueAsStream() {
        return this.node.get().setValueAsStream();
    }

    public void setValueAsStream(InputStream inputStream) {
        this.node.get().setValueAsStream(inputStream);
    }

    public void setValueAsFile(File file) {
        this.node.get().setValueAsFile(file);
    }

    public void setValueAsString(String value) {
        this.node.get().setValueAsString(value);
    }

    public String getBucketName() {
        return this.bucket.getName();
    }

    public String getETag() {
        return this.node.get().getETag();
    }

    public long getSize() {
        return this.node.get().getSize();
    }

    public Date getLastModified() {
        return this.node.get().getLastModified();
    }

    public S3Object getS3Object() {
        return this.node.get().getS3Object();
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3File s3File = (S3File)o;
        return this.path.equals(s3File.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public void delete() {
        this.node.get().delete();
    }

    private void writeStringAndReplace(Node current, String value) {
        PutObjectResult result = this.bucket.setObjectAsString(this.path.getAbsoluteName(), value);
        this.node.compareAndSet(current, new UpdatedObject(result));
    }

    private void writeFileAndReplace(Node current, File value) {
        PutObjectResult result = this.bucket.setObjectAsFile(this.path.getAbsoluteName(), value);
        this.node.compareAndSet(current, new UpdatedObject(result));
    }

    private S3OutputStream writeStreamAndReplace(Node current) {
        return new S3OutputStream(this.bucket.getClient().getS3(), this.bucket.getName(), this.path.getAbsoluteName(), () -> {
            S3Object object = this.bucket.getObject(this.path.getAbsoluteName());
            this.node.compareAndSet(current, new Object(object));
        });
    }

    private void writeStreamAndReplace(Node current, InputStream inputStream) {
        PutObjectResult result = this.bucket.setObjectAsStream(this.path.getAbsoluteName(), inputStream);
        this.node.compareAndSet(current, new UpdatedObject(result));
    }

    private Stream<S3File> performWalk(int depth) {
        return S3Client.asStream(new WalkingIterator(this, depth));
    }

    private Node resolve(Node current) {
        S3Object object;
        try {
            object = this.bucket.getObject(this.path.getAbsoluteName());
        }
        catch (AmazonS3Exception e) {
            if ("NoSuchKey".equals(e.getErrorCode())) {
                NewObject newObject = new NewObject();
                if (this.node.compareAndSet(current, newObject)) {
                    return newObject;
                }
                return this.node.get();
            }
            throw e;
        }
        Object newNode = new Object(object);
        if (this.node.compareAndSet(current, newNode)) {
            return newNode;
        }
        return this.node.get();
    }

    private Stream<S3File> listRequest(ListObjectsRequest request) {
        Objects.requireNonNull(request);
        if (request.getPrefix() == null) {
            return this.bucket.objects(request.withPrefix(this.path.getSearchPrefix()));
        }
        return this.bucket.objects(request);
    }

    public String toString() {
        return "S3File{bucket='" + this.bucket.getName() + "', path='" + this.path.getAbsoluteName() + "', node='" + this.node.get().getClass().getSimpleName() + "'}";
    }

    static class IteratorIterator<T>
    implements Iterator<T> {
        private final Iterator<Iterator<T>> iterators;
        private Iterator<T> current;

        public IteratorIterator(Iterator<T> ... iterators) {
            this(Arrays.asList(iterators));
        }

        public IteratorIterator(List<Iterator<T>> iterators) {
            this.iterators = iterators.iterator();
            this.current = this.iterators.next();
        }

        @Override
        public boolean hasNext() {
            if (this.current.hasNext()) {
                return true;
            }
            if (!this.iterators.hasNext()) {
                return false;
            }
            this.current = this.iterators.next();
            return this.hasNext();
        }

        @Override
        public T next() {
            return this.current.next();
        }
    }

    class ObjectSummaryIterator
    implements Iterator<S3File> {
        private final Iterator<S3ObjectSummary> iterator;

        public ObjectSummaryIterator(Iterator<S3ObjectSummary> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public S3File next() {
            return new S3File(S3File.this.bucket, this.iterator.next());
        }
    }

    class DirectoryIterator
    implements Iterator<S3File> {
        private final Iterator<String> iterator;

        public DirectoryIterator(Iterator<String> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public S3File next() {
            return new S3File(S3File.this.bucket, Path.fromKey(this.iterator.next()), Directory.class);
        }
    }

    class WalkingIterator
    implements Iterator<S3File> {
        static final int INFINITE = Integer.MAX_VALUE;
        private final int remaining;
        private Iterator<S3File> iterator;
        private final List<Iterator<S3File>> children = new ArrayList<Iterator<S3File>>();
        private final ListObjectsRequest request;

        public WalkingIterator(S3File file, int depth) {
            this(new ListObjectsRequest(), file, depth);
        }

        public WalkingIterator(ListObjectsRequest request, S3File file, int depth) {
            this.request = request.withDelimiter("/").withPrefix(file.getPath().getSearchPrefix()).withBucketName(S3File.this.bucket.getName());
            this.iterator = new Listing(this.getS3().listObjects(this.request));
            this.remaining = depth == Integer.MAX_VALUE ? Integer.MAX_VALUE : depth - 1;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public S3File next() {
            return this.iterator.next();
        }

        private AmazonS3 getS3() {
            return S3File.this.bucket.getClient().getS3();
        }

        class Listing
        implements Iterator<S3File> {
            private final ObjectListing objectListing;
            private final Iterator<S3File> objectListingIterator;

            public Listing(ObjectListing objectListing) {
                this.objectListing = objectListing;
                this.objectListingIterator = this.iterator(objectListing);
            }

            private Iterator<S3File> iterator(ObjectListing objectListing) {
                return new IteratorIterator<S3File>(new ObjectSummaryIterator(objectListing.getObjectSummaries().iterator()), new DirectoryIterator(objectListing.getCommonPrefixes().iterator()));
            }

            @Override
            public boolean hasNext() {
                if (this.objectListingIterator.hasNext()) {
                    return true;
                }
                if (this.objectListing.isTruncated()) {
                    WalkingIterator.this.iterator = new Listing(WalkingIterator.this.getS3().listNextBatchOfObjects(this.objectListing));
                    return WalkingIterator.this.iterator.hasNext();
                }
                if (WalkingIterator.this.children.size() > 0) {
                    WalkingIterator.this.iterator = new IteratorIterator(WalkingIterator.this.children);
                    return WalkingIterator.this.iterator.hasNext();
                }
                return false;
            }

            @Override
            public S3File next() {
                S3File next = this.objectListingIterator.next();
                if (next.isDirectory() && (WalkingIterator.this.remaining == Integer.MAX_VALUE || WalkingIterator.this.remaining > 0)) {
                    WalkingIterator.this.children.add(new WalkingIterator(WalkingIterator.this.request, next, WalkingIterator.this.remaining));
                }
                return next;
            }
        }
    }

    private class NewObject
    implements Node {
        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public boolean isFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public Stream<S3File> files() {
            return Stream.of(new S3File[0]);
        }

        @Override
        public Stream<S3File> files(ListObjectsRequest request) {
            return Stream.of(new S3File[0]);
        }

        @Override
        public Stream<S3File> walk(int maxDepth) {
            return Stream.of(new S3File[0]);
        }

        @Override
        public S3File getFile(String name) {
            Path child = S3File.this.path.getChild(name);
            return new S3File(S3File.this.bucket, child, Unknown.class);
        }

        @Override
        public S3ObjectInputStream getValueAsStream() {
            throw new NoSuchS3ObjectException(S3File.this.getBucketName(), S3File.this.getAbsoluteName());
        }

        @Override
        public String getValueAsString() {
            throw new NoSuchS3ObjectException(S3File.this.getBucketName(), S3File.this.getAbsoluteName());
        }

        @Override
        public S3OutputStream setValueAsStream() {
            return S3File.this.writeStreamAndReplace(this);
        }

        @Override
        public void setValueAsStream(InputStream inputStream) {
            S3File.this.writeStreamAndReplace(this, inputStream);
        }

        @Override
        public void setValueAsString(String value) {
            S3File.this.writeStringAndReplace(this, value);
        }

        @Override
        public void setValueAsFile(File value) {
            S3File.this.writeFileAndReplace(this, value);
        }

        @Override
        public String getETag() {
            throw new NoSuchS3ObjectException(S3File.this.getBucketName(), S3File.this.getAbsoluteName());
        }

        @Override
        public long getSize() {
            throw new NoSuchS3ObjectException(S3File.this.getBucketName(), S3File.this.getAbsoluteName());
        }

        @Override
        public Date getLastModified() {
            throw new NoSuchS3ObjectException(S3File.this.getBucketName(), S3File.this.getAbsoluteName());
        }

        @Override
        public void delete() {
            throw new NoSuchS3ObjectException(S3File.this.getBucketName(), S3File.this.getAbsoluteName());
        }

        @Override
        public S3Object getS3Object() {
            throw new NoSuchS3ObjectException(S3File.this.getBucketName(), S3File.this.getAbsoluteName());
        }
    }

    private class Unknown
    implements Node {
        @Override
        public boolean exists() {
            return S3File.this.resolve(this).exists();
        }

        @Override
        public boolean isFile() {
            return S3File.this.resolve(this).isFile();
        }

        @Override
        public boolean isDirectory() {
            return S3File.this.resolve(this).isDirectory();
        }

        @Override
        public Stream<S3File> files() {
            return S3File.this.bucket.objects(new ListObjectsRequest().withPrefix(S3File.this.path.getSearchPrefix()));
        }

        @Override
        public Stream<S3File> files(ListObjectsRequest request) {
            return S3File.this.listRequest(request);
        }

        @Override
        public Stream<S3File> walk(int maxDepth) {
            return S3File.this.performWalk(maxDepth);
        }

        @Override
        public S3File getFile(String name) {
            Path child = S3File.this.path.getChild(name);
            return new S3File(S3File.this.bucket, child, Unknown.class);
        }

        @Override
        public S3ObjectInputStream getValueAsStream() {
            return S3File.this.resolve(this).getValueAsStream();
        }

        @Override
        public String getValueAsString() {
            return S3File.this.resolve(this).getValueAsString();
        }

        @Override
        public S3OutputStream setValueAsStream() {
            return S3File.this.writeStreamAndReplace(this);
        }

        @Override
        public void setValueAsStream(InputStream inputStream) {
            S3File.this.writeStreamAndReplace(this, inputStream);
        }

        @Override
        public void setValueAsString(String value) {
            S3File.this.writeStringAndReplace(this, value);
        }

        @Override
        public void setValueAsFile(File value) {
            S3File.this.writeFileAndReplace(this, value);
        }

        @Override
        public String getETag() {
            return S3File.this.resolve(this).getETag();
        }

        @Override
        public long getSize() {
            return S3File.this.resolve(this).getSize();
        }

        @Override
        public Date getLastModified() {
            return S3File.this.resolve(this).getLastModified();
        }

        @Override
        public void delete() {
            S3File.this.resolve(this).delete();
        }

        @Override
        public S3Object getS3Object() {
            return S3File.this.resolve(this).getS3Object();
        }
    }

    private class UpdatedObject
    implements Node {
        private final PutObjectResult result;

        public UpdatedObject(PutObjectResult result) {
            this.result = result;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public boolean isFile() {
            return true;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public S3File getFile(String name) {
            String message = String.format("S3File '%s' is a not directory and cannot have child '%s'", S3File.this.path.getAbsoluteName(), name);
            throw new UnsupportedOperationException(message);
        }

        @Override
        public Stream<S3File> files() {
            return Stream.of(new S3File[0]);
        }

        @Override
        public Stream<S3File> files(ListObjectsRequest request) {
            return Stream.of(new S3File[0]);
        }

        @Override
        public Stream<S3File> walk(int maxDepth) {
            return Stream.of(new S3File[0]);
        }

        @Override
        public S3ObjectInputStream getValueAsStream() {
            return S3File.this.resolve(this).getValueAsStream();
        }

        @Override
        public void setValueAsStream(InputStream inputStream) {
            S3File.this.writeStreamAndReplace(this, inputStream);
        }

        @Override
        public String getValueAsString() {
            return S3File.this.resolve(this).getValueAsString();
        }

        @Override
        public S3OutputStream setValueAsStream() {
            return S3File.this.writeStreamAndReplace(this);
        }

        @Override
        public void setValueAsString(String value) {
            S3File.this.writeStringAndReplace(this, value);
        }

        @Override
        public void setValueAsFile(File value) {
            S3File.this.writeFileAndReplace(this, value);
        }

        @Override
        public String getETag() {
            return this.result.getETag();
        }

        @Override
        public long getSize() {
            return this.result.getMetadata().getContentLength();
        }

        @Override
        public Date getLastModified() {
            return this.result.getMetadata().getLastModified();
        }

        @Override
        public void delete() {
            S3File.this.bucket.deleteObject(S3File.this.path.getAbsoluteName());
            S3File.this.node.compareAndSet(this, new NewObject());
        }

        @Override
        public S3Object getS3Object() {
            return S3File.this.resolve(this).getS3Object();
        }
    }

    private class ObjectSummary
    implements Node {
        private final S3ObjectSummary summary;

        public ObjectSummary(S3ObjectSummary summary) {
            this.summary = summary;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public boolean isFile() {
            return true;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public S3File getFile(String name) {
            String message = String.format("S3File '%s' is a not directory and cannot have child '%s'", S3File.this.path.getAbsoluteName(), name);
            throw new UnsupportedOperationException(message);
        }

        @Override
        public Stream<S3File> files() {
            return Stream.of(new S3File[0]);
        }

        @Override
        public Stream<S3File> files(ListObjectsRequest request) {
            return Stream.of(new S3File[0]);
        }

        @Override
        public Stream<S3File> walk(int maxDepth) {
            return Stream.of(new S3File[0]);
        }

        @Override
        public S3ObjectInputStream getValueAsStream() {
            return S3File.this.resolve(this).getValueAsStream();
        }

        @Override
        public String getValueAsString() {
            return S3File.this.resolve(this).getValueAsString();
        }

        @Override
        public S3OutputStream setValueAsStream() {
            return S3File.this.writeStreamAndReplace(this);
        }

        @Override
        public void setValueAsStream(InputStream inputStream) {
            S3File.this.writeStreamAndReplace(this, inputStream);
        }

        @Override
        public void setValueAsString(String value) {
            S3File.this.writeStringAndReplace(this, value);
        }

        @Override
        public void setValueAsFile(File value) {
            S3File.this.writeFileAndReplace(this, value);
        }

        @Override
        public String getETag() {
            return this.summary.getETag();
        }

        @Override
        public long getSize() {
            return this.summary.getSize();
        }

        @Override
        public Date getLastModified() {
            return this.summary.getLastModified();
        }

        @Override
        public void delete() {
            S3File.this.bucket.deleteObject(this.summary.getKey());
            S3File.this.node.compareAndSet(this, new NewObject());
        }

        @Override
        public S3Object getS3Object() {
            return S3File.this.resolve(this).getS3Object();
        }
    }

    private class Object
    implements Node {
        private final S3Object object;

        public Object(S3Object object) {
            this.object = object;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public boolean isFile() {
            return true;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public S3File getFile(String name) {
            String message = String.format("S3File '%s' is a not directory and cannot have child '%s'", S3File.this.path.getAbsoluteName(), name);
            throw new UnsupportedOperationException(message);
        }

        @Override
        public Stream<S3File> files() {
            return Stream.of(new S3File[0]);
        }

        @Override
        public Stream<S3File> files(ListObjectsRequest request) {
            return Stream.of(new S3File[0]);
        }

        @Override
        public Stream<S3File> walk(int maxDepth) {
            return Stream.of(new S3File[0]);
        }

        @Override
        public S3ObjectInputStream getValueAsStream() {
            return this.object.getObjectContent();
        }

        @Override
        public String getValueAsString() {
            try {
                return IO.slurp((InputStream)this.object.getObjectContent());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Cannot read content for " + S3File.this.path.getAbsoluteName(), e);
            }
        }

        @Override
        public S3OutputStream setValueAsStream() {
            return S3File.this.writeStreamAndReplace(this);
        }

        @Override
        public void setValueAsStream(InputStream inputStream) {
            S3File.this.writeStreamAndReplace(this, inputStream);
        }

        @Override
        public void setValueAsString(String value) {
            S3File.this.writeStringAndReplace(this, value);
        }

        @Override
        public void setValueAsFile(File value) {
            S3File.this.writeFileAndReplace(this, value);
        }

        @Override
        public String getETag() {
            return this.object.getObjectMetadata().getETag();
        }

        @Override
        public long getSize() {
            return this.object.getObjectMetadata().getContentLength();
        }

        @Override
        public Date getLastModified() {
            return this.object.getObjectMetadata().getLastModified();
        }

        @Override
        public void delete() {
            S3File.this.bucket.deleteObject(this.object.getKey());
            S3File.this.node.compareAndSet(this, new NewObject());
        }

        @Override
        public S3Object getS3Object() {
            return this.object;
        }
    }

    private class Directory
    implements Node {
        private Directory() {
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public boolean isFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public Stream<S3File> files() {
            return S3File.this.bucket.objects(new ListObjectsRequest().withPrefix(S3File.this.path.getSearchPrefix()));
        }

        @Override
        public Stream<S3File> files(ListObjectsRequest request) {
            return S3File.this.listRequest(request);
        }

        @Override
        public S3File getFile(String name) {
            Path child = S3File.this.path.getChild(name);
            return new S3File(S3File.this.bucket, child, Unknown.class);
        }

        @Override
        public Stream<S3File> walk(int maxDepth) {
            return S3File.this.performWalk(maxDepth);
        }

        @Override
        public S3ObjectInputStream getValueAsStream() {
            throw new UnsupportedOperationException("S3File refers to a directory");
        }

        @Override
        public String getValueAsString() {
            throw new UnsupportedOperationException("S3File refers to a directory");
        }

        @Override
        public S3OutputStream setValueAsStream() {
            throw new UnsupportedOperationException("S3File refers to a directory");
        }

        @Override
        public void setValueAsStream(InputStream inputStream) {
            throw new UnsupportedOperationException("S3File refers to a directory");
        }

        @Override
        public void setValueAsString(String value) {
            throw new UnsupportedOperationException("S3File refers to a directory");
        }

        @Override
        public void setValueAsFile(File file) {
            throw new UnsupportedOperationException("S3File refers to a directory");
        }

        @Override
        public String getETag() {
            throw new UnsupportedOperationException("S3File refers to a directory");
        }

        @Override
        public long getSize() {
            throw new UnsupportedOperationException("S3File refers to a directory");
        }

        @Override
        public Date getLastModified() {
            throw new UnsupportedOperationException("S3File refers to a directory");
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException("S3File refers to a directory");
        }

        @Override
        public S3Object getS3Object() {
            throw new UnsupportedOperationException("S3File refers to a directory");
        }
    }

    private static interface Node {
        public boolean isFile();

        public boolean isDirectory();

        public boolean exists();

        public S3File getFile(String var1);

        public Stream<S3File> files();

        public Stream<S3File> files(ListObjectsRequest var1);

        public Stream<S3File> walk(int var1);

        public S3ObjectInputStream getValueAsStream();

        public String getValueAsString();

        public S3OutputStream setValueAsStream();

        public void setValueAsStream(InputStream var1);

        public void setValueAsString(String var1);

        public void setValueAsFile(File var1);

        public String getETag();

        public long getSize();

        public Date getLastModified();

        public void delete();

        public S3Object getS3Object();
    }
}

