/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.jaws.s3;

import alex.mojaki.s3upload.StreamTransferManager;
import com.amazonaws.services.s3.AmazonS3;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class S3OutputStream
extends OutputStream {
    private final OutputStream out;
    private final StreamTransferManager manager;
    private final Runnable completedCallback;

    public S3OutputStream(AmazonS3 client, String bucket, String key) {
        this(client, bucket, key, () -> {});
    }

    public S3OutputStream(AmazonS3 client, String bucket, String key, Runnable runnable) {
        this.manager = new StreamTransferManager(bucket, key, client).numStreams(1).numUploadThreads(1).queueCapacity(2).partSize(10L);
        List streams = this.manager.getMultiPartOutputStreams();
        this.out = (OutputStream)streams.get(0);
        this.completedCallback = runnable;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.close();
        }
        finally {
            this.manager.complete();
            this.completedCallback.run();
        }
    }
}

