/*
 * Decompiled with CFR 0.152.
 */
package org.ton.bitstring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ton.bitstring.BitString;
import org.ton.bitstring.ByteBackedBitString;
import org.ton.bitstring.ByteBackedMutableBitString;
import org.ton.bitstring.EmptyBitString;
import org.ton.bitstring.FiftHexBitStringSerializer;
import org.ton.bitstring.MutableBitString;

@Serializable(with=FiftHexBitStringSerializer.class)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000b\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u001e\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\bg\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0003:\u0001%J\u0011\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0000H\u0096\u0002J\u0016\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0005H\u00a6\u0002\u00a2\u0006\u0002\u0010\fJ\u0017\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000H\u00a6\u0004J\u0011\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u00a6\u0002J\u0011\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u00a6\u0002J\u0018\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0005H&J\u0017\u0010\u0011\u001a\u00020\u00002\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u00a6\u0002J\u0017\u0010\u0011\u001a\u00020\u00002\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u00a6\u0002J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aH&J\u0018\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\b\u0010\u001e\u001a\u00020\u0013H&J\u0012\u0010\u001f\u001a\u00020\u00152\b\b\u0002\u0010 \u001a\u00020\u0002H&J\b\u0010!\u001a\u00020\"H&J\b\u0010#\u001a\u00020\u000fH&J\u0011\u0010$\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000H\u00a6\u0004R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006&"}, d2={"Lorg/ton/bitstring/BitString;", "", "", "", "size", "", "getSize", "()I", "compareTo", "other", "get", "index", "(I)Ljava/lang/Boolean;", "getOrNull", "joinToStringBits", "", "or", "plus", "bits", "", "bytes", "", "", "", "slice", "indices", "Lkotlin/ranges/IntRange;", "subList", "fromIndex", "toIndex", "toBooleanArray", "toByteArray", "augment", "toMutableBitString", "Lorg/ton/bitstring/MutableBitString;", "toString", "xor", "Companion", "ton-kotlin-bitstring"})
public interface BitString
extends List<Boolean>,
Comparable<BitString>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = org.ton.bitstring.BitString$Companion.$$INSTANCE;
    public static final int MAX_LENGTH = 1023;

    public int getSize();

    @Override
    @NotNull
    public Boolean get(int var1);

    @Nullable
    public Boolean getOrNull(int var1);

    @NotNull
    public BitString plus(@NotNull boolean[] var1);

    @NotNull
    public BitString plus(@NotNull Iterable<Boolean> var1);

    @NotNull
    public BitString plus(@NotNull Collection<Boolean> var1);

    @NotNull
    public BitString plus(@NotNull byte[] var1);

    @NotNull
    public BitString plus(@NotNull byte[] var1, int var2);

    @NotNull
    public BitString slice(@NotNull IntRange var1);

    @NotNull
    public byte[] toByteArray(boolean var1);

    @NotNull
    public boolean[] toBooleanArray();

    @NotNull
    public MutableBitString toMutableBitString();

    @NotNull
    public BitString xor(@NotNull BitString var1);

    @NotNull
    public BitString or(@NotNull BitString var1);

    @NotNull
    public BitString subList(int var1, int var2);

    @NotNull
    public String toString();

    @NotNull
    public String joinToStringBits();

    @Override
    public int compareTo(@NotNull BitString var1);

    @JvmStatic
    @NotNull
    public static BitString empty() {
        return Companion.empty();
    }

    @JvmStatic
    @NotNull
    public static BitString of(@NotNull byte[] byteArray, int size) {
        return Companion.of(byteArray, size);
    }

    @JvmStatic
    @NotNull
    public static BitString of(int size) {
        return Companion.of(size);
    }

    @JvmStatic
    @NotNull
    public static BitString binary(@NotNull String bits2) {
        return Companion.binary(bits2);
    }

    @JvmStatic
    @NotNull
    public static BitString of(boolean ... bits2) {
        return Companion.of(bits2);
    }

    @JvmStatic
    @NotNull
    public static BitString of(@NotNull Iterable<Boolean> bits2) {
        return Companion.of(bits2);
    }

    @JvmStatic
    @NotNull
    public static BitString of(@NotNull String hex) {
        return Companion.of(hex);
    }

    @JvmStatic
    @NotNull
    public static byte[] appendAugmentTag(@NotNull byte[] data, int bits2) {
        return Companion.appendAugmentTag(data, bits2);
    }

    @JvmStatic
    public static int findAugmentTag(@NotNull byte[] byteArray) {
        return Companion.findAugmentTag(byteArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\nH\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u0014\u0010\u000f\u001a\u00020\n2\n\u0010\b\u001a\u00020\u0010\"\u00020\u0011H\u0007J\u001a\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\u0004H\u0007J\u0012\u0010\u000f\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\u0004H\u0007J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000bH\u0007J\u0016\u0010\u000f\u001a\u00020\n2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/ton/bitstring/BitString$Companion;", "", "()V", "MAX_LENGTH", "", "appendAugmentTag", "", "data", "bits", "binary", "Lorg/ton/bitstring/BitString;", "", "empty", "findAugmentTag", "byteArray", "of", "", "", "size", "hex", "", "ton-kotlin-bitstring"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        public static final int MAX_LENGTH = 1023;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BitString empty() {
            return EmptyBitString.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final BitString of(@NotNull byte[] byteArray, int size) {
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            return ByteBackedBitString.Companion.of(byteArray, size);
        }

        public static /* synthetic */ BitString of$default(Companion companion, byte[] byArray, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = byArray.length * 8;
            }
            return companion.of(byArray, n);
        }

        @JvmStatic
        @NotNull
        public final BitString of(int size) {
            if (size == 0) {
                return this.empty();
            }
            return ByteBackedBitString.Companion.of(size);
        }

        public static /* synthetic */ BitString of$default(Companion companion, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            return companion.of(n);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final BitString binary(@NotNull String bits2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)bits2, (String)"bits");
            if (((CharSequence)bits2).length() == 0) {
                return this.empty();
            }
            CharSequence $this$map$iv = bits2;
            boolean $i$f$map = false;
            CharSequence charSequence = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
                boolean bl;
                void char_;
                char item$iv$iv;
                char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void var11_11 = char_;
                if (var11_11 == 49) {
                    bl = true;
                } else if (var11_11 == 48) {
                    bl = false;
                } else {
                    throw new IllegalArgumentException("Invalid bit: `" + (char)char_ + '`');
                }
                collection.add(bl);
            }
            Iterable bits$iv = (List)destination$iv$iv;
            boolean $i$f$BitString = false;
            return Companion.of(bits$iv);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final BitString of(boolean ... bits2) {
            Intrinsics.checkNotNullParameter((Object)bits2, (String)"bits");
            if (bits2.length == 0) {
                return this.empty();
            }
            ByteBackedMutableBitString bitString = ByteBackedMutableBitString.Companion.of(bits2.length);
            boolean[] $this$forEachIndexed$iv = bits2;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (boolean item$iv : $this$forEachIndexed$iv) {
                void bit;
                int n = index$iv++;
                boolean bl = item$iv;
                int index = n;
                boolean bl2 = false;
                bitString.set(index, (boolean)bit);
            }
            return bitString;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final BitString of(@NotNull Iterable<Boolean> bits2) {
            Intrinsics.checkNotNullParameter(bits2, (String)"bits");
            List bitsList = CollectionsKt.toList(bits2);
            if (bitsList.isEmpty()) {
                return this.empty();
            }
            ByteBackedMutableBitString bitString = ByteBackedMutableBitString.Companion.of(bitsList.size());
            Iterable $this$forEachIndexed$iv = bitsList;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void bit;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                boolean bl = (Boolean)item$iv;
                int index = n;
                boolean bl2 = false;
                bitString.set(index, (boolean)bit);
            }
            return bitString;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final BitString of(@NotNull String hex) {
            List list;
            void $this$dropLastWhile$iv;
            Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
            if (((CharSequence)hex).length() == 0) {
                return this.empty();
            }
            boolean incomplete = ((CharSequence)hex).length() > 0 && StringsKt.last((CharSequence)hex) == '_';
            List list2 = SequencesKt.toMutableList((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.takeWhile((Sequence)StringsKt.asSequence((CharSequence)hex), (Function1)of.bits.1.INSTANCE), (Function1)of.bits.2.INSTANCE)));
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    boolean it = (Boolean)iterator$iv.previous();
                    boolean bl = false;
                    if (incomplete && !it) continue;
                    list = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            List bits2 = CollectionsKt.dropLast((List)list, (int)(incomplete ? 1 : 0));
            boolean $i$f$BitString = false;
            return Companion.of(bits2);
        }

        @JvmStatic
        @NotNull
        public final byte[] appendAugmentTag(@NotNull byte[] data, int bits2) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            int shift = bits2 % 8;
            if (shift == 0 || data.length == 0) {
                byte[] byArray = Arrays.copyOf(data, bits2 / 8 + 1);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
                byte[] newData = byArray;
                newData[ArraysKt.getLastIndex((byte[])newData)] = -128;
                return newData;
            }
            byte[] byArray = Arrays.copyOf(data, bits2 / 8 + 1);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
            byte[] newData = byArray;
            int lastByte = newData[ArraysKt.getLastIndex((byte[])newData)] & 0xFF;
            if (shift != 7) {
                lastByte >>= 7 - shift;
            }
            lastByte |= 1;
            if (shift != 7) {
                lastByte <<= 7 - shift;
            }
            newData[ArraysKt.getLastIndex((byte[])newData)] = (byte)lastByte;
            return newData;
        }

        @JvmStatic
        public final int findAugmentTag(@NotNull byte[] byteArray) {
            byte by;
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            if (byteArray.length == 0) {
                return 0;
            }
            int length = byteArray.length * 8;
            int index = ArraysKt.getLastIndex((byte[])byteArray);
            while ((by = byteArray[index--]) == 0) {
                length -= 8;
            }
            int skip = 1;
            int mask = 1;
            while ((by & mask) == 0) {
                ++skip;
                mask <<= 1;
            }
            return length -= skip;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static /* synthetic */ byte[] toByteArray$default(BitString bitString, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toByteArray");
            }
            if ((n & 1) != 0) {
                bl = false;
            }
            return bitString.toByteArray(bl);
        }

        @NotNull
        public static BitString subList(@NotNull BitString $this, int fromIndex, int toIndex) {
            return $this.slice(new IntRange(fromIndex, toIndex));
        }

        @NotNull
        public static String joinToStringBits(@NotNull BitString $this) {
            return CollectionsKt.joinToString$default((Iterable)$this, (CharSequence)"", null, null, (int)0, null, (Function1)joinToStringBits.1.INSTANCE, (int)30, null);
        }

        public static int compareTo(@NotNull BitString $this, @NotNull BitString other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int limit = Math.min($this.size(), other.size());
            int n = 0;
            while (n < limit) {
                boolean otherValue;
                int it = n++;
                boolean bl = false;
                boolean thisValue = $this.get(it);
                if (thisValue == (otherValue = other.get(it).booleanValue())) continue;
                return thisValue ? 1 : -1;
            }
            return $this.size() - other.size();
        }
    }
}

