/*
 * Decompiled with CFR 0.152.
 */
package org.ton.bitstring;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ton.bitstring.BitString;
import org.ton.bitstring.ByteBackedMutableBitString;
import org.ton.bitstring.MutableBitString;
import org.ton.bitstring.exception.BitStringOverflowException;
import org.ton.bitstring.exception.BitStringUnderflowException;
import org.ton.crypto.HexKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010*\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u0000 62\u00020\u0001:\u000256B\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0096\u0002J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0016J\u0013\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\u0016\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u001d\u001a\u00020\u000fH\u0016J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001fH\u0096\u0002J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\"H\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\"2\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0011\u0010#\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001H\u0096\u0004J\u0011\u0010$\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020%H\u0096\u0002J\u0011\u0010$\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0096\u0002J\u0018\u0010$\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0017\u0010$\u001a\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0096\u0002J\u0017\u0010$\u001a\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0&H\u0096\u0002J\u0010\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003H\u0016J\b\u0010-\u001a\u00020%H\u0016J\u0010\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u000fH\u0016J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000203H\u0016J\u0011\u00104\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001H\u0096\u0004R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u00067"}, d2={"Lorg/ton/bitstring/ByteBackedBitString;", "Lorg/ton/bitstring/BitString;", "size", "", "bytes", "", "(I[B)V", "getBytes", "()[B", "getSize", "()I", "appendTag", "data", "bits", "contains", "", "element", "containsAll", "elements", "", "equals", "other", "", "get", "index", "(I)Ljava/lang/Boolean;", "getOrNull", "hashCode", "indexOf", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "or", "plus", "", "", "slice", "indices", "Lkotlin/ranges/IntRange;", "subList", "fromIndex", "toIndex", "toBooleanArray", "toByteArray", "augment", "toMutableBitString", "Lorg/ton/bitstring/MutableBitString;", "toString", "", "xor", "BitStringIterator", "Companion", "ton-kotlin-bitstring"})
public class ByteBackedBitString
implements BitString {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int size;
    @NotNull
    private final byte[] bytes;

    protected ByteBackedBitString(int size, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.size = size;
        this.bytes = bytes;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @NotNull
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    @NotNull
    public Boolean get(int index) {
        Boolean bl = this.getOrNull(index);
        if (bl == null) {
            throw new BitStringUnderflowException();
        }
        return (boolean)bl;
    }

    @Override
    @Nullable
    public Boolean getOrNull(int index) {
        return (0 <= index ? index <= this.size() : false) ? Boolean.valueOf(ByteBackedBitString.get(this.getBytes(), index)) : null;
    }

    @Override
    @NotNull
    public BitString plus(@NotNull boolean[] bits2) {
        Intrinsics.checkNotNullParameter((Object)bits2, (String)"bits");
        return this.toMutableBitString().plus(bits2);
    }

    @Override
    @NotNull
    public BitString plus(@NotNull Iterable<Boolean> bits2) {
        Intrinsics.checkNotNullParameter(bits2, (String)"bits");
        return this.toMutableBitString().plus(bits2);
    }

    @Override
    @NotNull
    public BitString plus(@NotNull Collection<Boolean> bits2) {
        Intrinsics.checkNotNullParameter(bits2, (String)"bits");
        return this.toMutableBitString().plus(bits2);
    }

    @Override
    @NotNull
    public BitString plus(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.toMutableBitString().plus(bytes);
    }

    @Override
    @NotNull
    public BitString plus(@NotNull byte[] bytes, int bits2) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.toMutableBitString().plus(bytes, bits2);
    }

    @Override
    @NotNull
    public BitString slice(@NotNull IntRange indices) {
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        ByteBackedMutableBitString result = ByteBackedMutableBitString.Companion.of(indices.getLast() - indices.getFirst() + 1);
        int n = indices.getFirst();
        int n2 = indices.getLast();
        int n3 = 0;
        if (n <= n2) {
            int i;
            do {
                int position = n3++;
                i = n++;
                result.set(position, this.get(i));
            } while (i != n2);
        }
        return result;
    }

    @Override
    @NotNull
    public byte[] toByteArray(boolean augment) {
        byte[] byArray;
        if (augment && this.size() % 8 != 0) {
            byArray = BitString.Companion.appendAugmentTag(this.getBytes(), this.size());
        } else {
            byte[] byArray2 = this.getBytes();
            byte[] byArray3 = Arrays.copyOf(byArray2, byArray2.length);
            byArray = byArray3;
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(this, size)");
        }
        return byArray;
    }

    @Override
    @NotNull
    public boolean[] toBooleanArray() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Boolean>");
        return CollectionsKt.toBooleanArray((Collection)this);
    }

    @Override
    @NotNull
    public MutableBitString toMutableBitString() {
        return ByteBackedMutableBitString.Companion.of(this.getBytes(), this.size());
    }

    public boolean contains(boolean element) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean it = (Boolean)element$iv;
                    boolean bl2 = false;
                    if (!(it == element)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean it = (Boolean)element$iv;
                    boolean bl2 = false;
                    if (this.contains((Object)it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int lastIndexOf(boolean element) {
        int n;
        block1: {
            List $this$indexOfLast$iv = this;
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                boolean it = (Boolean)iterator$iv.previous();
                boolean bl = false;
                if (!(it == element)) continue;
                n = iterator$iv.nextIndex();
                break block1;
            }
            n = -1;
        }
        return n;
    }

    @Override
    @NotNull
    public ListIterator<Boolean> listIterator() {
        return new BitStringIterator(this, 0, 2, null);
    }

    @Override
    @NotNull
    public ListIterator<Boolean> listIterator(int index) {
        return new BitStringIterator(this, index);
    }

    @Override
    @NotNull
    public BitString subList(int fromIndex, int toIndex) {
        return this.slice(new IntRange(fromIndex, toIndex));
    }

    public int indexOf(boolean element) {
        int n;
        block2: {
            List $this$indexOfFirst$iv = this;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                boolean it = (Boolean)item$iv;
                boolean bl = false;
                if (it == element) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    @Override
    @NotNull
    public Iterator<Boolean> iterator() {
        return this.listIterator();
    }

    @Override
    @NotNull
    public BitString xor(@NotNull BitString other) {
        BitString bitString;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof ByteBackedBitString)) {
            ByteBackedMutableBitString result = ByteBackedMutableBitString.Companion.of(Math.max(this.size(), other.size()));
            int n = Math.min(this.size(), other.size());
            for (int i = 0; i < n; ++i) {
                result.set(i, this.get(i) ^ other.get(i));
            }
            bitString = result;
        } else {
            byte[] result = new byte[Math.max(this.getBytes().length, ((ByteBackedBitString)other).getBytes().length)];
            int n = Math.min(this.getBytes().length, ((ByteBackedBitString)other).getBytes().length);
            for (int i = 0; i < n; ++i) {
                result[i] = (byte)(this.getBytes()[i] ^ ((ByteBackedBitString)other).getBytes()[i]);
            }
            bitString = Companion.of(result, Math.max(this.size(), other.size()));
        }
        return bitString;
    }

    @Override
    @NotNull
    public BitString or(@NotNull BitString other) {
        BitString bitString;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof ByteBackedBitString)) {
            ByteBackedMutableBitString result = ByteBackedMutableBitString.Companion.of(Math.max(this.size(), other.size()));
            int n = Math.min(this.size(), other.size());
            for (int i = 0; i < n; ++i) {
                result.set(i, this.get(i) | other.get(i));
            }
            bitString = result;
        } else {
            byte[] result = new byte[Math.max(this.getBytes().length, ((ByteBackedBitString)other).getBytes().length)];
            int n = Math.min(this.getBytes().length, ((ByteBackedBitString)other).getBytes().length);
            for (int i = 0; i < n; ++i) {
                result[i] = (byte)(this.getBytes()[i] | ((ByteBackedBitString)other).getBytes()[i]);
            }
            bitString = Companion.of(result, Math.max(this.size(), other.size()));
        }
        return bitString;
    }

    @Override
    @NotNull
    public String toString() {
        if (this.size() == 0) {
            return "";
        }
        byte[] data = this.appendTag(this.getBytes(), this.size());
        StringBuilder result = new StringBuilder(HexKt.hex((byte[])data));
        int n = this.size() % 8;
        if (n == 0) {
            Intrinsics.checkNotNullExpressionValue((Object)result.deleteCharAt(StringsKt.getLastIndex((CharSequence)result)), (String)"this.deleteCharAt(index)");
            Intrinsics.checkNotNullExpressionValue((Object)result.deleteCharAt(StringsKt.getLastIndex((CharSequence)result)), (String)"this.deleteCharAt(index)");
        } else {
            boolean bl = 1 <= n ? n < 4 : false;
            if (bl) {
                result.setCharAt(StringsKt.getLastIndex((CharSequence)result), '_');
            } else if (n == 4) {
                Intrinsics.checkNotNullExpressionValue((Object)result.deleteCharAt(StringsKt.getLastIndex((CharSequence)result)), (String)"this.deleteCharAt(index)");
            } else {
                result.append('_');
            }
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return string2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BitString)) {
            return false;
        }
        if (this.size() != ((BitString)other).size()) {
            return false;
        }
        return !(other instanceof ByteBackedBitString ? !Arrays.equals(this.getBytes(), ((ByteBackedBitString)other).getBytes()) : !Arrays.equals(this.toBooleanArray(), ((BitString)other).toBooleanArray()));
    }

    @Override
    public int hashCode() {
        int result = this.size();
        result = 31 * result + Arrays.hashCode(this.getBytes());
        return result;
    }

    private final byte[] appendTag(byte[] data, int bits2) {
        int shift = bits2 % 8;
        if (shift == 0 || data.length == 0) {
            byte[] byArray = Arrays.copyOf(data, bits2 / 8 + 1);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
            byte[] newData = byArray;
            newData[ArraysKt.getLastIndex((byte[])newData)] = -128;
            return newData;
        }
        byte[] byArray = Arrays.copyOf(data, bits2 / 8 + 1);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
        byte[] newData = byArray;
        int lastByte = newData[ArraysKt.getLastIndex((byte[])newData)];
        if (shift != 7) {
            lastByte >>= 7 - shift;
        }
        lastByte |= 1;
        if (shift != 7) {
            lastByte <<= 7 - shift;
        }
        newData[ArraysKt.getLastIndex((byte[])newData)] = (byte)lastByte;
        return newData;
    }

    @Override
    @NotNull
    public String joinToStringBits() {
        return BitString.DefaultImpls.joinToStringBits(this);
    }

    @Override
    public int compareTo(@NotNull BitString other) {
        return BitString.DefaultImpls.compareTo(this, other);
    }

    @Override
    public boolean add(boolean element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void add(int index, boolean element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(int index, Collection<? extends Boolean> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends Boolean> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(int index) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(UnaryOperator<Boolean> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Boolean set(int index, boolean element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void sort(Comparator<? super Boolean> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @JvmStatic
    @NotNull
    public static final ByteBackedBitString of(int size) {
        return Companion.of(size);
    }

    @JvmStatic
    @NotNull
    public static final ByteBackedBitString of(@NotNull byte[] bytes, int size) {
        return Companion.of(bytes, size);
    }

    @JvmStatic
    @NotNull
    protected static final byte[] constructByteArray(@NotNull byte[] bytes, int size) {
        return Companion.constructByteArray(bytes, size);
    }

    @JvmStatic
    @NotNull
    protected static final byte[] expandByteArray(@NotNull byte[] bytes, int size) {
        return Companion.expandByteArray(bytes, size);
    }

    @JvmStatic
    @NotNull
    protected static final byte[] constructByteArray(int size) {
        return Companion.constructByteArray(size);
    }

    @JvmStatic
    protected static final void checkSize(int size) {
        Companion.checkSize(size);
    }

    @JvmStatic
    protected static final boolean get(@NotNull byte[] bytes, int index) {
        return Companion.get(bytes, index);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010*\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0002H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0002H\u0016J\u000e\u0010\u0010\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\r\u0010\u0013\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0014\u001a\u00020\u0006H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/ton/bitstring/ByteBackedBitString$BitStringIterator;", "", "", "bitString", "Lorg/ton/bitstring/BitString;", "index", "", "(Lorg/ton/bitstring/BitString;I)V", "getBitString", "()Lorg/ton/bitstring/BitString;", "getIndex", "()I", "setIndex", "(I)V", "hasNext", "hasPrevious", "next", "()Ljava/lang/Boolean;", "nextIndex", "previous", "previousIndex", "ton-kotlin-bitstring"})
    public static class BitStringIterator
    implements ListIterator<Boolean>,
    KMappedMarker {
        @NotNull
        private final BitString bitString;
        private int index;

        public BitStringIterator(@NotNull BitString bitString, int index) {
            Intrinsics.checkNotNullParameter((Object)bitString, (String)"bitString");
            this.bitString = bitString;
            this.index = index;
        }

        public /* synthetic */ BitStringIterator(BitString bitString, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            this(bitString, n);
        }

        @NotNull
        public BitString getBitString() {
            return this.bitString;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.getBitString().size();
        }

        @Override
        public boolean hasPrevious() {
            return this.index - 1 >= 0;
        }

        @Override
        @NotNull
        public Boolean next() {
            int n = this.index;
            this.index = n + 1;
            return this.getBitString().get(n);
        }

        @Override
        public int nextIndex() {
            return this.index + 1;
        }

        @Override
        @NotNull
        public Boolean previous() {
            int n = this.index;
            this.index = n + -1;
            return this.getBitString().get(n);
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void add(boolean element) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void set(boolean element) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0004H\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0004H\u0005J\u0018\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0004H\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0004H\u0005J\u001c\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\b\u001a\u00020\u0004H\u0007J\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\u0012"}, d2={"Lorg/ton/bitstring/ByteBackedBitString$Companion;", "", "()V", "bytesSize", "", "bits", "checkSize", "", "size", "constructByteArray", "", "bytes", "expandByteArray", "get", "", "index", "of", "Lorg/ton/bitstring/ByteBackedBitString;", "ton-kotlin-bitstring"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ByteBackedBitString of(int size) {
            return new ByteBackedBitString(size, ByteBackedBitString.constructByteArray(size));
        }

        public static /* synthetic */ ByteBackedBitString of$default(Companion companion, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            return companion.of(n);
        }

        @JvmStatic
        @NotNull
        public final ByteBackedBitString of(@NotNull byte[] bytes, int size) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            return new ByteBackedBitString(size, ByteBackedBitString.constructByteArray(bytes, size));
        }

        public static /* synthetic */ ByteBackedBitString of$default(Companion companion, byte[] byArray, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                byArray = new byte[]{};
            }
            if ((n2 & 2) != 0) {
                n = byArray.length * 8;
            }
            return companion.of(byArray, n);
        }

        @JvmStatic
        @NotNull
        protected final byte[] constructByteArray(@NotNull byte[] bytes, int size) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            ByteBackedBitString.checkSize(size);
            byte[] byArray = Arrays.copyOf(bytes, this.bytesSize(size));
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
            return byArray;
        }

        @JvmStatic
        @NotNull
        protected final byte[] expandByteArray(@NotNull byte[] bytes, int size) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            int requiredBytesSize = this.bytesSize(size);
            return bytes.length == requiredBytesSize ? bytes : ByteBackedBitString.constructByteArray(bytes, size);
        }

        @JvmStatic
        @NotNull
        protected final byte[] constructByteArray(int size) {
            ByteBackedBitString.checkSize(size);
            return new byte[this.bytesSize(size)];
        }

        @JvmStatic
        protected final void checkSize(int size) {
            if (!(0 <= size ? size < 1024 : false)) {
                boolean bl = false;
                throw new BitStringOverflowException(null, 1, null);
            }
        }

        @JvmStatic
        protected final boolean get(@NotNull byte[] bytes, int index) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            int byteIndex = index / 8;
            byte bitMask = (byte)(1 << 7 - index % 8);
            return (byte)(bytes[byteIndex] & bitMask) != 0;
        }

        private final int bytesSize(int bits2) {
            ByteBackedBitString.checkSize(bits2);
            return bits2 / 8 + (bits2 % 8 == 0 ? 0 : 1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

