/*
 * Decompiled with CFR 0.152.
 */
package org.ton.bitstring;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableListIterator;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.ton.bitstring.BitString;
import org.ton.bitstring.ByteBackedBitString;
import org.ton.bitstring.MutableBitString;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010)\n\u0000\n\u0002\u0010+\n\u0000\n\u0002\u0010\u0018\n\u0002\u0010\u001c\n\u0002\b\u000e\b\u0016\u0018\u0000 12\u00020\u00012\u00020\u0002:\u000201B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0018\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u001e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017H\u0016J\u0016\u0010\u0015\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u001fH\u0096\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110!H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110!2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020#H\u0096\u0002J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H\u0096\u0002J\u0018\u0010\"\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\u0017\u0010\"\u001a\u00020\u00002\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017H\u0096\u0002J\u0017\u0010\"\u001a\u00020\u00002\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110$H\u0096\u0002J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0016\u0010&\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017H\u0016J\u0015\u0010'\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010(J\u0016\u0010)\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017H\u0016J\u001e\u0010*\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0011H\u0096\u0002\u00a2\u0006\u0002\u0010+J\u0019\u0010*\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u0006H\u0096\u0002J\u0018\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0006H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u00062"}, d2={"Lorg/ton/bitstring/ByteBackedMutableBitString;", "Lorg/ton/bitstring/ByteBackedBitString;", "Lorg/ton/bitstring/MutableBitString;", "bytes", "", "size", "", "([BI)V", "getBytes", "()[B", "setBytes", "([B)V", "getSize", "()I", "setSize", "(I)V", "add", "", "element", "", "index", "addAll", "elements", "", "appendWithDoubleShifting", "byteArray", "bits", "appendWithShifting", "appendWithoutShifting", "clear", "iterator", "", "listIterator", "", "plus", "", "", "remove", "removeAll", "removeAt", "(I)Ljava/lang/Boolean;", "retainAll", "set", "(IZ)Ljava/lang/Boolean;", "bit", "subList", "fromIndex", "toIndex", "BitStringMutableIterator", "Companion", "ton-kotlin-bitstring"})
public class ByteBackedMutableBitString
extends ByteBackedBitString
implements MutableBitString {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private byte[] bytes;
    private int size;

    public ByteBackedMutableBitString(@NotNull byte[] bytes, int size) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        super(size, bytes);
        this.bytes = bytes;
        this.size = size;
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.bytes = byArray;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    @Override
    public void set(int index, int bit) {
        this.set(index, bit != 0);
    }

    @Override
    @NotNull
    public Boolean set(int index, boolean element) {
        byte[] newBytes = ByteBackedBitString.expandByteArray(this.getBytes(), index + 1);
        boolean previous = ByteBackedMutableBitString.set(newBytes, index, element);
        this.setBytes(newBytes);
        return previous;
    }

    @Override
    @NotNull
    public MutableBitString subList(int fromIndex, int toIndex) {
        return this.slice(new IntRange(fromIndex, toIndex)).toMutableBitString();
    }

    @Override
    @NotNull
    public ByteBackedMutableBitString plus(@NotNull boolean[] bits2) {
        Intrinsics.checkNotNullParameter((Object)bits2, (String)"bits");
        return this.plus(ArraysKt.asIterable((boolean[])bits2));
    }

    @Override
    @NotNull
    public ByteBackedMutableBitString plus(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.plus(bytes, bytes.length * 8);
    }

    @Override
    @NotNull
    public ByteBackedMutableBitString plus(@NotNull Iterable<Boolean> bits2) {
        Intrinsics.checkNotNullParameter(bits2, (String)"bits");
        return this.plus((Collection)CollectionsKt.toList(bits2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ByteBackedMutableBitString plus(@NotNull Collection<Boolean> bits2) {
        ByteBackedMutableBitString byteBackedMutableBitString;
        Intrinsics.checkNotNullParameter(bits2, (String)"bits");
        ByteBackedMutableBitString $this$plus_u24lambda_u241 = byteBackedMutableBitString = this;
        boolean bl = false;
        if (bits2 instanceof ByteBackedBitString) {
            $this$plus_u24lambda_u241.plus(((ByteBackedBitString)bits2).getBytes(), bits2.size());
        } else {
            int bitsCount = bits2.size();
            byte[] newBytes = ByteBackedBitString.expandByteArray($this$plus_u24lambda_u241.getBytes(), $this$plus_u24lambda_u241.size() + bitsCount);
            Iterable $this$forEachIndexed$iv = bits2;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void bit;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                boolean bl2 = (Boolean)item$iv;
                int index = n;
                boolean bl3 = false;
                ByteBackedMutableBitString.set(newBytes, $this$plus_u24lambda_u241.size() + index, (boolean)bit);
            }
            $this$plus_u24lambda_u241.setBytes(newBytes);
            $this$plus_u24lambda_u241.setSize($this$plus_u24lambda_u241.size() + bitsCount);
        }
        return byteBackedMutableBitString;
    }

    @Override
    @NotNull
    public ByteBackedMutableBitString plus(@NotNull byte[] bytes, int bits2) {
        ByteBackedMutableBitString byteBackedMutableBitString;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ByteBackedMutableBitString $this$plus_u24lambda_u242 = byteBackedMutableBitString = this;
        boolean bl = false;
        ByteBackedBitString.checkSize($this$plus_u24lambda_u242.size() + bits2);
        if (bits2 != 0) {
            if ($this$plus_u24lambda_u242.size() % 8 == 0) {
                if (bits2 % 8 == 0) {
                    $this$plus_u24lambda_u242.appendWithoutShifting(bytes, bits2);
                } else {
                    $this$plus_u24lambda_u242.appendWithShifting(bytes, bits2);
                }
            } else {
                $this$plus_u24lambda_u242.appendWithDoubleShifting(bytes, bits2);
            }
        }
        return byteBackedMutableBitString;
    }

    @Override
    @NotNull
    public Iterator<Boolean> iterator() {
        return this.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<Boolean> listIterator() {
        return new BitStringMutableIterator(this, 0, 2, null);
    }

    @Override
    @NotNull
    public ListIterator<Boolean> listIterator(int index) {
        return new BitStringMutableIterator(this, index);
    }

    @Override
    public boolean add(boolean element) {
        byte[] newBytes = ByteBackedBitString.expandByteArray(this.getBytes(), this.size() + 1);
        ByteBackedMutableBitString.set(newBytes, this.size(), element);
        this.setBytes(newBytes);
        this.setSize(this.size() + 1);
        return true;
    }

    @Override
    public void add(int index, boolean element) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends Boolean> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Boolean> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.plus(elements);
        return true;
    }

    @Override
    public void clear() {
        this.setBytes(new byte[0]);
        this.setSize(0);
    }

    public boolean remove(boolean element) {
        return (Boolean)this.remove(this.lastIndexOf((Object)element));
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public Boolean removeAt(int index) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void appendWithoutShifting(byte[] byteArray, int bits2) {
        if (!(this.size() % 8 == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(bits2 % 8 == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        byte[] newBytes = ByteBackedBitString.expandByteArray(this.getBytes(), this.size() + bits2);
        ArraysKt.copyInto$default((byte[])byteArray, (byte[])newBytes, (int)(this.size() / 8), (int)0, (int)(bits2 / 8), (int)4, null);
        this.setBytes(newBytes);
        this.setSize(this.size() + bits2);
    }

    private final void appendWithShifting(byte[] byteArray, int bits2) {
        if (!(this.size() % 8 == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int shift = bits2 % 8;
        if (!(shift != 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        byte[] newBytes = ByteBackedBitString.expandByteArray(this.getBytes(), this.size() + bits2);
        ArraysKt.copyInto$default((byte[])byteArray, (byte[])newBytes, (int)(this.size() / 8), (int)0, (int)(bits2 / 8 + 1), (int)4, null);
        int lastByte = byteArray[bits2 / 8];
        lastByte >>= 8 - shift;
        newBytes[(this.size() + bits2) / 8] = (byte)(lastByte <<= 8 - shift);
        this.setBytes(newBytes);
        this.setSize(this.size() + bits2);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendWithDoubleShifting(byte[] byteArray, int bits2) {
        int selfShift = this.size() % 8;
        byte[] byArray = Arrays.copyOf(this.getBytes(), this.size() / 8 + byteArray.length + 1);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
        byte[] data = byArray;
        int lastIndex = this.size() / 8;
        int lastBits = data[lastIndex] >> 8 - selfShift;
        int y = 0;
        y = lastBits;
        byte[] $this$forEachIndexed$iv = byteArray;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (byte item$iv : $this$forEachIndexed$iv) {
            void x;
            int n = index$iv++;
            byte by = item$iv;
            int i = n;
            boolean bl = false;
            y = y << 8 | x & 0xFF;
            int newByte = y >> selfShift;
            data[lastIndex + i] = (byte)newByte;
        }
        int a = lastIndex + byteArray.length;
        data[a] = (byte)(y << 8 - selfShift);
        int newSize = this.size() + bits2;
        int shift = newSize % 8;
        if (shift == 0) {
            byte[] newBytes = ByteBackedBitString.expandByteArray(data, newSize);
            this.setBytes(newBytes);
            this.setSize(newSize);
        } else {
            byte[] newBytes = ByteBackedBitString.expandByteArray(data, newSize);
            int lastByte = newBytes[ArraysKt.getLastIndex((byte[])newBytes)];
            lastByte >>= 8 - shift;
            newBytes[ArraysKt.getLastIndex((byte[])newBytes)] = (byte)(lastByte <<= 8 - shift);
            this.setBytes(newBytes);
            this.setSize(newSize);
        }
    }

    @JvmStatic
    @NotNull
    public static final ByteBackedMutableBitString of(int size) {
        return Companion.of(size);
    }

    @JvmStatic
    @NotNull
    public static final ByteBackedMutableBitString of(@NotNull byte[] byteArray, int size) {
        return Companion.of(byteArray, size);
    }

    @JvmStatic
    @NotNull
    public static final ByteBackedMutableBitString of(@NotNull BitString bitString, int size) {
        return Companion.of(bitString, size);
    }

    @JvmStatic
    protected static final boolean set(@NotNull byte[] bytes, int index, boolean element) {
        return Companion.set(bytes, index, element);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010+\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/ton/bitstring/ByteBackedMutableBitString$BitStringMutableIterator;", "Lorg/ton/bitstring/ByteBackedBitString$BitStringIterator;", "", "", "bitString", "Lorg/ton/bitstring/MutableBitString;", "index", "", "(Lorg/ton/bitstring/MutableBitString;I)V", "getBitString", "()Lorg/ton/bitstring/MutableBitString;", "add", "", "element", "remove", "set", "ton-kotlin-bitstring"})
    public static final class BitStringMutableIterator
    extends ByteBackedBitString.BitStringIterator
    implements ListIterator<Boolean>,
    KMutableListIterator {
        @NotNull
        private final MutableBitString bitString;

        public BitStringMutableIterator(@NotNull MutableBitString bitString, int index) {
            Intrinsics.checkNotNullParameter((Object)bitString, (String)"bitString");
            super(bitString, index);
            this.bitString = bitString;
        }

        public /* synthetic */ BitStringMutableIterator(MutableBitString mutableBitString, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            this(mutableBitString, n);
        }

        @Override
        @NotNull
        public MutableBitString getBitString() {
            return this.bitString;
        }

        @Override
        public void add(boolean element) {
            this.getBitString().add(this.getIndex(), element);
        }

        @Override
        public void remove() {
            this.getBitString().remove(this.getIndex());
        }

        @Override
        public void set(boolean element) {
            this.getBitString().set(this.getIndex(), element);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\fH\u0005\u00a8\u0006\u0010"}, d2={"Lorg/ton/bitstring/ByteBackedMutableBitString$Companion;", "", "()V", "of", "Lorg/ton/bitstring/ByteBackedMutableBitString;", "byteArray", "", "size", "", "bitString", "Lorg/ton/bitstring/BitString;", "set", "", "bytes", "index", "element", "ton-kotlin-bitstring"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ByteBackedMutableBitString of(int size) {
            byte[] bytes = ByteBackedBitString.constructByteArray(size);
            return new ByteBackedMutableBitString(bytes, size);
        }

        public static /* synthetic */ ByteBackedMutableBitString of$default(Companion companion, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            return companion.of(n);
        }

        @JvmStatic
        @NotNull
        public final ByteBackedMutableBitString of(@NotNull byte[] byteArray, int size) {
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            byte[] bytes = ByteBackedBitString.constructByteArray(byteArray, size);
            return new ByteBackedMutableBitString(bytes, size);
        }

        public static /* synthetic */ ByteBackedMutableBitString of$default(Companion companion, byte[] byArray, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = byArray.length * 8;
            }
            return companion.of(byArray, n);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final ByteBackedMutableBitString of(@NotNull BitString bitString, int size) {
            ByteBackedMutableBitString byteBackedMutableBitString;
            Intrinsics.checkNotNullParameter((Object)bitString, (String)"bitString");
            if (bitString instanceof ByteBackedBitString) {
                byteBackedMutableBitString = this.of(((ByteBackedBitString)bitString).getBytes(), size);
            } else {
                void var3_3;
                ByteBackedMutableBitString result = this.of(size);
                Iterable $this$forEachIndexed$iv = bitString;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void bit;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    boolean bl = (Boolean)item$iv;
                    int index = n;
                    boolean bl2 = false;
                    result.set(index, (boolean)bit);
                }
                byteBackedMutableBitString = var3_3;
            }
            return byteBackedMutableBitString;
        }

        public static /* synthetic */ ByteBackedMutableBitString of$default(Companion companion, BitString bitString, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = bitString.size();
            }
            return companion.of(bitString, n);
        }

        @JvmStatic
        protected final boolean set(@NotNull byte[] bytes, int index, boolean element) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            int $this$byteIndex$iv = index;
            boolean $i$f$getByteIndex = false;
            int wordIndex = $this$byteIndex$iv / 8;
            int $this$bitMask$iv = index;
            boolean $i$f$getBitMask = false;
            byte bitMask = (byte)(1 << 7 - $this$bitMask$iv % 8);
            boolean previous = ByteBackedBitString.get(bytes, index);
            bytes[wordIndex] = element ? (byte)(bytes[wordIndex] | bitMask) : (byte)(bytes[wordIndex] & (byte)(~bitMask));
            return previous;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

