/*
 * Decompiled with CFR 0.152.
 */
package org.ton.tl;

import io.github.andreypfau.kotlinx.crypto.sha2.SHA256Kt;
import io.ktor.util.CryptoKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.ByteIterator;
import kotlin.io.encoding.Base64;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ton.tl.ByteStringKt;
import org.ton.tl.ByteStringSerializer;

@Serializable(with=ByteStringSerializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u001e\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 22\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u000212B\u000f\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0096\u0002J\u0016\u0010\u0016\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J,\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\b\b\u0002\u0010\u001a\u001a\u00020\n2\b\b\u0002\u0010\u001b\u001a\u00020\n2\b\b\u0002\u0010\u001c\u001a\u00020\nJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\nJ\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\nJ\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020#J\u0006\u0010%\u001a\u00020#J\u0013\u0010&\u001a\u00020\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010'H\u0096\u0002J\u0016\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\nH\u0087\u0002\u00a2\u0006\u0002\b*J\b\u0010\t\u001a\u00020\nH\u0016J\u0006\u0010+\u001a\u00020\u0000J\b\u0010,\u001a\u00020\u0014H\u0016J\t\u0010-\u001a\u00020.H\u0096\u0002J\u0006\u0010/\u001a\u00020\u0005J,\u0010/\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\b\b\u0002\u0010\u001a\u001a\u00020\n2\b\b\u0002\u0010\u001b\u001a\u00020\n2\b\b\u0002\u0010\u001c\u001a\u00020\nJ\b\u00100\u001a\u00020#H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u00063"}, d2={"Lorg/ton/tl/ByteString;", "", "", "", "data", "", "([B)V", "getData$ton_kotlin_tl", "()[B", "hashCode", "", "getHashCode", "()I", "hashCode$delegate", "Lkotlin/Lazy;", "size", "getSize", "compareTo", "other", "contains", "", "element", "containsAll", "elements", "copyInto", "destination", "destinationOffset", "startIndex", "endIndex", "copyOf", "newSize", "copyOfRange", "fromIndex", "toIndex", "decodeToString", "", "encodeBase64", "encodeHex", "equals", "", "get", "index", "getByte", "hashSha256", "isEmpty", "iterator", "Lkotlin/collections/ByteIterator;", "toByteArray", "toString", "ByteIteratorImpl", "Companion", "ton-kotlin-tl"})
@SourceDebugExtension(value={"SMAP\nByteString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteString.kt\norg/ton/tl/ByteString\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1726#2,3:161\n*S KotlinDebug\n*F\n+ 1 ByteString.kt\norg/ton/tl/ByteString\n*L\n29#1:161,3\n*E\n"})
public class ByteString
implements Comparable<ByteString>,
Collection<Byte>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] data;
    @NotNull
    private final Lazy hashCode$delegate;

    public ByteString(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
        this.hashCode$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ ByteString this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return Arrays.hashCode(this.this$0.getData$ton_kotlin_tl());
            }
        }));
    }

    @NotNull
    public final byte[] getData$ton_kotlin_tl() {
        return this.data;
    }

    private final int getHashCode() {
        Lazy lazy = this.hashCode$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public int getSize() {
        return this.data.length;
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    byte it = ((Number)element$iv).byteValue();
                    boolean bl2 = false;
                    if (this.contains((Object)it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public boolean contains(byte element) {
        return ArraysKt.contains((byte[])this.data, (byte)element);
    }

    @JvmName(name="getByte")
    public final byte getByte(int index) {
        return this.data[index];
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] byArray = Arrays.copyOf(this.data, this.data.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return byArray;
    }

    @NotNull
    public final byte[] toByteArray(@NotNull byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        return ArraysKt.copyInto((byte[])this.data, (byte[])destination, (int)destinationOffset, (int)startIndex, (int)endIndex);
    }

    public static /* synthetic */ byte[] toByteArray$default(ByteString byteString, byte[] byArray, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toByteArray");
        }
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = byteString.size();
        }
        return byteString.toByteArray(byArray, n, n2, n3);
    }

    @NotNull
    public final ByteString copyOf(int newSize) {
        byte[] byArray = Arrays.copyOf(this.data, newSize);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return new ByteString(byArray);
    }

    @NotNull
    public final ByteString copyOfRange(int fromIndex, int toIndex) {
        byte[] byArray = this.data;
        return new ByteString(ArraysKt.copyOfRange((byte[])byArray, (int)fromIndex, (int)toIndex));
    }

    @NotNull
    public final byte[] copyInto(@NotNull byte[] destination, int destinationOffset, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        return ArraysKt.copyInto((byte[])this.data, (byte[])destination, (int)destinationOffset, (int)startIndex, (int)endIndex);
    }

    public static /* synthetic */ byte[] copyInto$default(ByteString byteString, byte[] byArray, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyInto");
        }
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = byteString.size();
        }
        return byteString.copyInto(byArray, n, n2, n3);
    }

    @NotNull
    public final String encodeHex() {
        String string = HexExtensionsKt.toHexString$default((byte[])this.data, null, (int)1, null).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string;
    }

    @NotNull
    public final String encodeBase64() {
        return Base64.encode$default((Base64)((Base64)Base64.Default), (byte[])this.data, (int)0, (int)0, (int)6, null);
    }

    @NotNull
    public final String decodeToString() {
        return StringsKt.decodeToString((byte[])this.data);
    }

    @NotNull
    public final ByteString hashSha256() {
        return ByteStringKt.asByteString(SHA256Kt.sha256((byte[])this.data));
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public int compareTo(@NotNull ByteString other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int sizeA = this.size();
        int sizeB = other.size();
        int size = Math.min(sizeA, sizeB);
        for (int i = 0; i < size; ++i) {
            byte byteB;
            byte byteA = (byte)(this.getByte(i) & 0xFFFFFFFF);
            if (byteA == (byteB = (byte)(other.getByte(i) & 0xFFFFFFFF))) {
                continue;
            }
            return byteA < byteB ? -1 : 1;
        }
        if (sizeA == sizeB) {
            return 0;
        }
        return sizeA < sizeB ? -1 : 1;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ByteString)) {
            return false;
        }
        return Arrays.equals(this.data, ((ByteString)other).data);
    }

    @Override
    public int hashCode() {
        return this.getHashCode();
    }

    @NotNull
    public ByteIterator iterator() {
        return new ByteIteratorImpl(this.data);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("0x");
        String string = this.encodeHex().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return stringBuilder.append(string).toString();
    }

    @Override
    public boolean add(byte element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends Byte> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeIf(Predicate<? super Byte> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @JvmStatic
    @NotNull
    public static final ByteString of(byte ... bytes) {
        return Companion.of(bytes);
    }

    @JvmStatic
    @JvmName(name="of")
    @NotNull
    public static final ByteString of(@NotNull byte[] $this$of, int fromIndex, int toIndex) {
        return Companion.of($this$of, fromIndex, toIndex);
    }

    @JvmStatic
    @NotNull
    public static final ByteString decodeFromHex(@NotNull String $this$decodeFromHex) {
        return Companion.decodeFromHex($this$decodeFromHex);
    }

    @JvmStatic
    @NotNull
    public static final ByteString decodeFromBase64(@NotNull String $this$decodeFromBase64) {
        return Companion.decodeFromBase64($this$decodeFromBase64);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\r\u001a\u00020\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/ton/tl/ByteString$ByteIteratorImpl;", "Lkotlin/collections/ByteIterator;", "collection", "", "([B)V", "getCollection", "()[B", "index", "", "getIndex", "()I", "setIndex", "(I)V", "hasNext", "", "nextByte", "", "ton-kotlin-tl"})
    private static final class ByteIteratorImpl
    extends ByteIterator {
        @NotNull
        private final byte[] collection;
        private int index;

        public ByteIteratorImpl(@NotNull byte[] collection) {
            Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
            this.collection = collection;
        }

        @NotNull
        public final byte[] getCollection() {
            return this.collection;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            int n = this.index;
            this.index = n + 1;
            return this.collection[n];
        }

        public boolean hasNext() {
            return this.index < this.collection.length;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00020\u0006\"\u00020\u0007H\u0007J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u00c6\u0001J\f\u0010\n\u001a\u00020\u0004*\u00020\u000bH\u0007J\f\u0010\f\u001a\u00020\u0004*\u00020\u000bH\u0007J%\u0010\r\u001a\u00020\u0004*\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\b\u0003\u00a8\u0006\u0011"}, d2={"Lorg/ton/tl/ByteString$Companion;", "", "()V", "of", "Lorg/ton/tl/ByteString;", "bytes", "", "", "serializer", "Lkotlinx/serialization/KSerializer;", "decodeFromBase64", "", "decodeFromHex", "toByteString", "fromIndex", "", "toIndex", "ton-kotlin-tl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ByteString of(byte ... bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            return new ByteString(bytes);
        }

        @JvmStatic
        @JvmName(name="of")
        @NotNull
        public final ByteString of(@NotNull byte[] $this$toByteString, int fromIndex, int toIndex) {
            Intrinsics.checkNotNullParameter((Object)$this$toByteString, (String)"<this>");
            byte[] byArray = $this$toByteString;
            return new ByteString(ArraysKt.copyOfRange((byte[])byArray, (int)fromIndex, (int)toIndex));
        }

        public static /* synthetic */ ByteString of$default(Companion companion, byte[] byArray, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = byArray.length;
            }
            return companion.of(byArray, n, n2);
        }

        @JvmStatic
        @NotNull
        public final ByteString decodeFromHex(@NotNull String $this$decodeFromHex) {
            Intrinsics.checkNotNullParameter((Object)$this$decodeFromHex, (String)"<this>");
            return new ByteString(CryptoKt.hex((String)$this$decodeFromHex));
        }

        @JvmStatic
        @NotNull
        public final ByteString decodeFromBase64(@NotNull String $this$decodeFromBase64) {
            Intrinsics.checkNotNullParameter((Object)$this$decodeFromBase64, (String)"<this>");
            return new ByteString(Base64.decode$default((Base64)((Base64)Base64.Default), (CharSequence)$this$decodeFromBase64, (int)0, (int)0, (int)6, null));
        }

        @NotNull
        public final KSerializer<ByteString> serializer() {
            return ByteStringSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

