/*
 * Decompiled with CFR 0.152.
 */
package org.ton.tl;

import io.github.andreypfau.kotlinx.crypto.crc32.CRC32Kt;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ton.tl.TlCodec;
import org.ton.tl.TlReader;
import org.ton.tl.TlWriter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lorg/ton/tl/TlConstructor;", "T", "", "Lorg/ton/tl/TlCodec;", "schema", "", "id", "", "(Ljava/lang/String;Ljava/lang/Integer;)V", "getId", "()I", "getSchema", "()Ljava/lang/String;", "schema$delegate", "Lkotlin/Lazy;", "decodeBoxed", "reader", "Lorg/ton/tl/TlReader;", "(Lorg/ton/tl/TlReader;)Ljava/lang/Object;", "encodeBoxed", "", "writer", "Lorg/ton/tl/TlWriter;", "value", "(Lorg/ton/tl/TlWriter;Ljava/lang/Object;)V", "equals", "", "other", "hashCode", "toString", "ton-kotlin-tl"})
@SourceDebugExtension(value={"SMAP\nTlConstructor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TlConstructor.kt\norg/ton/tl/TlConstructor\n+ 2 Strings.kt\nio/ktor/utils/io/core/StringsKt\n+ 3 ByteOrderJvm.kt\nio/ktor/utils/io/bits/ByteOrderJVMKt\n*L\n1#1,46:1\n7#2,4:47\n15#3:51\n15#3:52\n*S KotlinDebug\n*F\n+ 1 TlConstructor.kt\norg/ton/tl/TlConstructor\n*L\n17#1:47,4\n27#1:51\n28#1:52\n*E\n"})
public abstract class TlConstructor<T>
implements TlCodec<T> {
    @NotNull
    private final Lazy schema$delegate;
    private final int id;

    public TlConstructor(@NotNull String schema2, @Nullable Integer id) {
        int n;
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        this.schema$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<String>(schema2){
            final /* synthetic */ String $schema;
            {
                this.$schema = $schema;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)this.$schema, (String)"(", (String)"", (boolean)false, (int)4, null), (String)")", (String)"", (boolean)false, (int)4, null), (String)";", (String)"", (boolean)false, (int)4, null);
            }
        }));
        Integer n2 = id;
        if (n2 != null) {
            n = n2;
        } else {
            byte[] byArray;
            String $this$toByteArray_u24default$iv = this.getSchema();
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$toByteArray = false;
            if (Intrinsics.areEqual((Object)charset$iv, (Object)Charsets.UTF_8)) {
                byArray = StringsKt.encodeToByteArray((String)$this$toByteArray_u24default$iv);
            } else {
                CharsetEncoder charsetEncoder = charset$iv.newEncoder();
                Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
                byArray = CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)$this$toByteArray_u24default$iv, (int)0, (int)$this$toByteArray_u24default$iv.length());
            }
            n = CRC32Kt.crc32((byte[])byArray);
        }
        this.id = n;
    }

    public /* synthetic */ TlConstructor(String string, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        this(string, n);
    }

    @NotNull
    public final String getSchema() {
        Lazy lazy = this.schema$delegate;
        return (String)lazy.getValue();
    }

    public final int getId() {
        return this.id;
    }

    @Override
    public void encodeBoxed(@NotNull TlWriter writer, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        writer.writeInt(this.id);
        this.encode(writer, value);
    }

    @Override
    @NotNull
    public T decodeBoxed(@NotNull TlReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        int actualId = reader.readInt();
        if (!(actualId == this.id)) {
            boolean bl = false;
            int $this$reverseByteOrder$iv = this.id;
            boolean $i$f$reverseByteOrder = false;
            String idHex = StringsKt.padStart((String)UStringsKt.toString-V7xB4Y4((int)UInt.constructor-impl((int)Integer.reverseBytes($this$reverseByteOrder$iv)), (int)16), (int)8, (char)'0');
            int $this$reverseByteOrder$iv2 = actualId;
            boolean $i$f$reverseByteOrder2 = false;
            String actualHex = StringsKt.padStart((String)UStringsKt.toString-V7xB4Y4((int)UInt.constructor-impl((int)Integer.reverseBytes($this$reverseByteOrder$iv2)), (int)16), (int)8, (char)'0');
            String string = "Invalid ID. expected: " + idHex + " (" + this.id + ") actual: " + actualHex + " (" + actualId + ')';
            throw new IllegalArgumentException(string.toString());
        }
        return this.decode(reader);
    }

    @NotNull
    public String toString() {
        return this.getSchema();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TlConstructor)) {
            return false;
        }
        if (this.id != ((TlConstructor)other).id) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getSchema(), (Object)((TlConstructor)other).getSchema());
    }

    public int hashCode() {
        return this.id;
    }
}

