/*
 * Decompiled with CFR 0.152.
 */
package org.ton.tl;

import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.InputLittleEndianKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.ton.tl.ByteString;
import org.ton.tl.constructors.Bool;
import org.ton.tl.constructors.BoolTlCombinator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u0013\u001a\u00020\u0014J+\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0016\"\u0004\b\u0000\u0010\u00172\u0017\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H\u00170\u0019\u00a2\u0006\u0002\b\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/ton/tl/TlReader;", "", "input", "Lio/ktor/utils/io/core/Input;", "(Lio/ktor/utils/io/core/Input;)V", "getInput", "()Lio/ktor/utils/io/core/Input;", "readBoolean", "", "readByteString", "Lorg/ton/tl/ByteString;", "size", "", "readBytes", "", "readInt", "readLong", "", "readRaw", "readString", "", "readVector", "", "T", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "ton-kotlin-tl"})
@SourceDebugExtension(value={"SMAP\nTlReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TlReader.kt\norg/ton/tl/TlReader\n+ 2 UnsignedTypes.kt\nio/ktor/utils/io/core/UnsignedTypesKt\n*L\n1#1,71:1\n7#2:72\n7#2:73\n7#2:74\n7#2:75\n7#2:76\n7#2:77\n7#2:78\n7#2:79\n7#2:80\n7#2:81\n7#2:82\n*S KotlinDebug\n*F\n+ 1 TlReader.kt\norg/ton/tl/TlReader\n*L\n23#1:72\n28#1:73\n29#1:74\n30#1:75\n33#1:76\n34#1:77\n35#1:78\n36#1:79\n37#1:80\n38#1:81\n39#1:82\n*E\n"})
public final class TlReader {
    @NotNull
    private final Input input;

    public TlReader(@NotNull Input input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
    }

    @NotNull
    public final Input getInput() {
        return this.input;
    }

    public final boolean readBoolean() {
        return ((Bool)((Object)BoolTlCombinator.INSTANCE.decode(this))).getValue();
    }

    public final int readInt() {
        return InputLittleEndianKt.readIntLittleEndian((Input)this.input);
    }

    public final long readLong() {
        return InputLittleEndianKt.readLongLittleEndian((Input)this.input);
    }

    @NotNull
    public final byte[] readRaw(int size) {
        return io.ktor.utils.io.core.StringsKt.readBytes((Input)this.input, (int)size);
    }

    @NotNull
    public final ByteString readByteString(int size) {
        return new ByteString(io.ktor.utils.io.core.StringsKt.readBytes((Input)this.input, (int)size));
    }

    @NotNull
    public final ByteString readByteString() {
        return new ByteString(this.readBytes());
    }

    @NotNull
    public final byte[] readBytes() {
        Input $this$readUByte$iv = this.input;
        boolean $i$f$readUByte = false;
        int resultLength = UByte.constructor-impl((byte)$this$readUByte$iv.readByte()) & 0xFF;
        int resultAlignedLength = 0;
        if (resultLength < 254) {
            resultAlignedLength = resultLength + 1;
        } else if (resultLength == 254) {
            Input $this$readUByte$iv2 = this.input;
            boolean $i$f$readUByte2 = false;
            int n = UByte.constructor-impl((byte)$this$readUByte$iv2.readByte()) & 0xFF;
            $this$readUByte$iv2 = this.input;
            $i$f$readUByte2 = false;
            int n2 = n | (UByte.constructor-impl((byte)$this$readUByte$iv2.readByte()) & 0xFF) << 8;
            $this$readUByte$iv2 = this.input;
            $i$f$readUByte2 = false;
            resultLength = n2 | (UByte.constructor-impl((byte)$this$readUByte$iv2.readByte()) & 0xFF) << 16;
            resultAlignedLength = resultLength + 4;
        } else {
            Input $this$readUByte$iv3 = this.input;
            boolean $i$f$readUByte3 = false;
            long l = (long)UByte.constructor-impl((byte)$this$readUByte$iv3.readByte()) & 0xFFL;
            $this$readUByte$iv3 = this.input;
            $i$f$readUByte3 = false;
            long l2 = l | ((long)UByte.constructor-impl((byte)$this$readUByte$iv3.readByte()) & 0xFFL) << 8;
            $this$readUByte$iv3 = this.input;
            $i$f$readUByte3 = false;
            long l3 = l2 | ((long)UByte.constructor-impl((byte)$this$readUByte$iv3.readByte()) & 0xFFL) << 16;
            $this$readUByte$iv3 = this.input;
            $i$f$readUByte3 = false;
            long l4 = l3 | ((long)UByte.constructor-impl((byte)$this$readUByte$iv3.readByte()) & 0xFFL) << 24;
            $this$readUByte$iv3 = this.input;
            $i$f$readUByte3 = false;
            long l5 = l4 | ((long)UByte.constructor-impl((byte)$this$readUByte$iv3.readByte()) & 0xFFL) << 32;
            $this$readUByte$iv3 = this.input;
            $i$f$readUByte3 = false;
            long l6 = l5 | ((long)UByte.constructor-impl((byte)$this$readUByte$iv3.readByte()) & 0xFFL) << 40;
            $this$readUByte$iv3 = this.input;
            $i$f$readUByte3 = false;
            long resultLengthLong = l6 | ((long)UByte.constructor-impl((byte)$this$readUByte$iv3.readByte()) & 0xFFL) << 48;
            if (resultLengthLong > Integer.MAX_VALUE) {
                throw new IllegalStateException("Too big byte array: " + resultLengthLong);
            }
            resultLength = (int)resultLengthLong;
            resultAlignedLength = resultLength + 8;
        }
        byte[] result = io.ktor.utils.io.core.StringsKt.readBytes((Input)this.input, (int)resultLength);
        while (resultAlignedLength++ % 4 > 0) {
            if (this.input.readByte() == 0) continue;
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return result;
    }

    @NotNull
    public final String readString() {
        return StringsKt.decodeToString((byte[])this.readBytes());
    }

    @NotNull
    public final <T> List<T> readVector(@NotNull Function1<? super TlReader, ? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int size = this.readInt();
        ArrayList<Object> arrayList = new ArrayList<Object>(size);
        int n = 0;
        while (n < size) {
            int n2;
            int n3 = n2 = n++;
            ArrayList<Object> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(block.invoke((Object)this));
        }
        return arrayList;
    }
}

