/*
 * Decompiled with CFR 0.152.
 */
package org.ton.tl;

import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputKt;
import io.ktor.utils.io.core.OutputLittleEndianKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.ton.tl.ByteString;
import org.ton.tl.constructors.Bool;
import org.ton.tl.constructors.BoolTlCombinator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J%\u0010\u0007\u001a\u00020\b2\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\b\u000bH\u0086\n\u00f8\u0001\u0000J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0012J\"\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00142\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0012J\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0010J\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0014J\u000e\u0010\u0019\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u001aJ?\u0010\u001b\u001a\u00020\b\"\u0004\b\u0000\u0010\u001c2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001d2\u001d\u0010\t\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u00020\b0\u001e\u00a2\u0006\u0002\b\u000bH\u0086\b\u00f8\u0001\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"Lorg/ton/tl/TlWriter;", "", "output", "Lio/ktor/utils/io/core/Output;", "(Lio/ktor/utils/io/core/Output;)V", "getOutput", "()Lio/ktor/utils/io/core/Output;", "invoke", "", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "writeBoolean", "value", "", "writeBytes", "", "offset", "", "length", "Lorg/ton/tl/ByteString;", "writeInt", "writeLong", "", "writeRaw", "writeString", "", "writeVector", "T", "", "Lkotlin/Function2;", "ton-kotlin-tl"})
@SourceDebugExtension(value={"SMAP\nTlWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TlWriter.kt\norg/ton/tl/TlWriter\n+ 2 UnsignedTypes.kt\nio/ktor/utils/io/core/UnsignedTypesKt\n*L\n1#1,97:1\n48#2,2:98\n48#2,2:100\n48#2,2:102\n48#2,2:104\n48#2,2:106\n48#2,2:108\n48#2,2:110\n48#2,2:112\n48#2,2:114\n48#2,2:116\n*S KotlinDebug\n*F\n+ 1 TlWriter.kt\norg/ton/tl/TlWriter\n*L\n37#1:98,2\n40#1:100,2\n41#1:102,2\n42#1:104,2\n43#1:106,2\n46#1:108,2\n47#1:110,2\n48#1:112,2\n49#1:114,2\n50#1:116,2\n*E\n"})
public final class TlWriter {
    @NotNull
    private final Output output;

    public TlWriter(@NotNull Output output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.output = output;
    }

    public /* synthetic */ TlWriter(Output output, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            output = (Output)new BytePacketBuilder(null, 1, null);
        }
        this(output);
    }

    @NotNull
    public final Output getOutput() {
        return this.output;
    }

    public final void writeBoolean(boolean value) {
        BoolTlCombinator.INSTANCE.encode(this, Bool.Companion.get(value));
    }

    public final void writeInt(int value) {
        OutputLittleEndianKt.writeIntLittleEndian((Output)this.output, (int)value);
    }

    public final void writeLong(long value) {
        OutputLittleEndianKt.writeLongLittleEndian((Output)this.output, (long)value);
    }

    public final void writeRaw(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        OutputKt.writeFully$default((Output)this.output, (byte[])value, (int)0, (int)0, (int)6, null);
    }

    public final void writeRaw(@NotNull ByteString value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        OutputKt.writeFully$default((Output)this.output, (byte[])value.getData$ton_kotlin_tl(), (int)0, (int)0, (int)6, null);
    }

    public final void writeBytes(@NotNull ByteString value, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writeBytes(value.getData$ton_kotlin_tl(), offset, length);
    }

    public static /* synthetic */ void writeBytes$default(TlWriter tlWriter, ByteString byteString, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byteString.size();
        }
        tlWriter.writeBytes(byteString, n, n2);
    }

    public final void writeBytes(@NotNull byte[] value, int offset, int length) {
        byte v$iv;
        Output $this$writeUByte_u2dEK_u2d6454$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int totalLength = length;
        if (totalLength < 254) {
            Output output = this.output;
            byte by = UByte.constructor-impl((byte)((byte)totalLength));
            bl = false;
            $this$writeUByte_u2dEK_u2d6454$iv.writeByte(v$iv);
        } else if (totalLength < 0x1000000) {
            $this$writeUByte_u2dEK_u2d6454$iv = this.output;
            v$iv = -2;
            bl = false;
            $this$writeUByte_u2dEK_u2d6454$iv.writeByte(v$iv);
            $this$writeUByte_u2dEK_u2d6454$iv = this.output;
            v$iv = UByte.constructor-impl((byte)((byte)(totalLength & 0xFF)));
            bl = false;
            $this$writeUByte_u2dEK_u2d6454$iv.writeByte(v$iv);
            $this$writeUByte_u2dEK_u2d6454$iv = this.output;
            v$iv = UByte.constructor-impl((byte)((byte)(totalLength >> 8 & 0xFF)));
            bl = false;
            $this$writeUByte_u2dEK_u2d6454$iv.writeByte(v$iv);
            $this$writeUByte_u2dEK_u2d6454$iv = this.output;
            v$iv = UByte.constructor-impl((byte)((byte)(totalLength >> 16)));
            bl = false;
            $this$writeUByte_u2dEK_u2d6454$iv.writeByte(v$iv);
            totalLength += 4;
        } else if (totalLength < Integer.MAX_VALUE) {
            $this$writeUByte_u2dEK_u2d6454$iv = this.output;
            v$iv = -1;
            bl = false;
            $this$writeUByte_u2dEK_u2d6454$iv.writeByte(v$iv);
            $this$writeUByte_u2dEK_u2d6454$iv = this.output;
            v$iv = UByte.constructor-impl((byte)((byte)(totalLength & 0xFF)));
            bl = false;
            $this$writeUByte_u2dEK_u2d6454$iv.writeByte(v$iv);
            $this$writeUByte_u2dEK_u2d6454$iv = this.output;
            v$iv = UByte.constructor-impl((byte)((byte)(totalLength >> 8 & 0xFF)));
            bl = false;
            $this$writeUByte_u2dEK_u2d6454$iv.writeByte(v$iv);
            $this$writeUByte_u2dEK_u2d6454$iv = this.output;
            v$iv = UByte.constructor-impl((byte)((byte)(totalLength >> 16 & 0xFF)));
            bl = false;
            $this$writeUByte_u2dEK_u2d6454$iv.writeByte(v$iv);
            $this$writeUByte_u2dEK_u2d6454$iv = this.output;
            v$iv = UByte.constructor-impl((byte)((byte)(totalLength >> 24 & 0xFF)));
            bl = false;
            $this$writeUByte_u2dEK_u2d6454$iv.writeByte(v$iv);
            this.output.writeByte((byte)0);
            this.output.writeByte((byte)0);
            this.output.writeByte((byte)0);
            totalLength += 8;
        } else {
            throw new IllegalStateException("Too big byte array: " + totalLength);
        }
        OutputKt.writeFully((Output)this.output, (byte[])value, (int)offset, (int)length);
        while (true) {
            int n = ++totalLength;
            ++totalLength;
            if (n % 4 <= 0) break;
            this.output.writeByte((byte)0);
        }
    }

    public static /* synthetic */ void writeBytes$default(TlWriter tlWriter, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        tlWriter.writeBytes(byArray, n, n2);
    }

    public final void writeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        TlWriter.writeBytes$default(this, StringsKt.encodeToByteArray((String)value), 0, 0, 6, null);
    }

    public final <T> void writeVector(@NotNull Collection<? extends T> value, @NotNull Function2<? super TlWriter, ? super T, Unit> block) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$writeVector = false;
        this.writeInt(value.size());
        for (T item : value) {
            block.invoke((Object)this, item);
        }
    }

    public final void invoke(@NotNull Function1<? super TlWriter, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$invoke = false;
        block.invoke((Object)this);
    }

    public TlWriter() {
        this(null, 1, null);
    }
}

