
package org.touchbit.testrail4j.gson.model;

import java.util.ArrayList;
import java.util.List;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Context {

    @SerializedName("is_global")
    @Expose
    private Boolean isGlobal;
    @SerializedName("project_ids")
    @Expose
    private List<Long> projectIds = new ArrayList<Long>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public Context() {
    }

    /**
     * 
     * @param isGlobal
     * @param projectIds
     */
    public Context(Boolean isGlobal, List<Long> projectIds) {
        super();
        this.isGlobal = isGlobal;
        this.projectIds = projectIds;
    }

    public Boolean getIsGlobal() {
        return isGlobal;
    }

    public void setIsGlobal(Boolean isGlobal) {
        this.isGlobal = isGlobal;
    }

    public Context withIsGlobal(Boolean isGlobal) {
        this.isGlobal = isGlobal;
        return this;
    }

    public List<Long> getProjectIds() {
        return projectIds;
    }

    public void setProjectIds(List<Long> projectIds) {
        this.projectIds = projectIds;
    }

    public Context withProjectIds(List<Long> projectIds) {
        this.projectIds = projectIds;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("isGlobal", isGlobal).append("projectIds", projectIds).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(isGlobal).append(projectIds).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Context) == false) {
            return false;
        }
        Context rhs = ((Context) other);
        return new EqualsBuilder().append(isGlobal, rhs.isGlobal).append(projectIds, rhs.projectIds).isEquals();
    }

}
