
package org.touchbit.testrail4j.gson.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Options {

    @SerializedName("default_value")
    @Expose
    private String defaultValue;
    @SerializedName("format")
    @Expose
    private String format;
    @SerializedName("is_required")
    @Expose
    private Boolean isRequired;
    @SerializedName("rows")
    @Expose
    private String rows;
    @SerializedName("items")
    @Expose
    private String items;
    @SerializedName("id")
    @Expose
    private String id;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Options() {
    }

    /**
     * 
     * @param isRequired
     * @param defaultValue
     * @param format
     * @param id
     * @param rows
     * @param items
     */
    public Options(String defaultValue, String format, Boolean isRequired, String rows, String items, String id) {
        super();
        this.defaultValue = defaultValue;
        this.format = format;
        this.isRequired = isRequired;
        this.rows = rows;
        this.items = items;
        this.id = id;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Options withDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public String getFormat() {
        return format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Options withFormat(String format) {
        this.format = format;
        return this;
    }

    public Boolean getIsRequired() {
        return isRequired;
    }

    public void setIsRequired(Boolean isRequired) {
        this.isRequired = isRequired;
    }

    public Options withIsRequired(Boolean isRequired) {
        this.isRequired = isRequired;
        return this;
    }

    public String getRows() {
        return rows;
    }

    public void setRows(String rows) {
        this.rows = rows;
    }

    public Options withRows(String rows) {
        this.rows = rows;
        return this;
    }

    public String getItems() {
        return items;
    }

    public void setItems(String items) {
        this.items = items;
    }

    public Options withItems(String items) {
        this.items = items;
        return this;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Options withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("defaultValue", defaultValue).append("format", format).append("isRequired", isRequired).append("rows", rows).append("items", items).append("id", id).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(isRequired).append(defaultValue).append(format).append(id).append(rows).append(items).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Options) == false) {
            return false;
        }
        Options rhs = ((Options) other);
        return new EqualsBuilder().append(isRequired, rhs.isRequired).append(defaultValue, rhs.defaultValue).append(format, rhs.format).append(id, rhs.id).append(rows, rhs.rows).append(items, rhs.items).isEquals();
    }

}
