
package org.touchbit.testrail4j.gson.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Options_ {

    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("format")
    @Expose
    private String format;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("has_actual")
    @Expose
    private Boolean hasActual;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("has_expected")
    @Expose
    private Boolean hasExpected;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("is_required")
    @Expose
    private Boolean isRequired;
    @SerializedName("rows")
    @Expose
    private String rows;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Options_() {
    }

    /**
     * 
     * @param isRequired
     * @param hasExpected
     * @param format
     * @param hasActual
     * @param rows
     */
    public Options_(String format, Boolean hasActual, Boolean hasExpected, Boolean isRequired, String rows) {
        super();
        this.format = format;
        this.hasActual = hasActual;
        this.hasExpected = hasExpected;
        this.isRequired = isRequired;
        this.rows = rows;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getFormat() {
        return format;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setFormat(String format) {
        this.format = format;
    }

    public Options_ withFormat(String format) {
        this.format = format;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Boolean getHasActual() {
        return hasActual;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setHasActual(Boolean hasActual) {
        this.hasActual = hasActual;
    }

    public Options_ withHasActual(Boolean hasActual) {
        this.hasActual = hasActual;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Boolean getHasExpected() {
        return hasExpected;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setHasExpected(Boolean hasExpected) {
        this.hasExpected = hasExpected;
    }

    public Options_ withHasExpected(Boolean hasExpected) {
        this.hasExpected = hasExpected;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Boolean getIsRequired() {
        return isRequired;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setIsRequired(Boolean isRequired) {
        this.isRequired = isRequired;
    }

    public Options_ withIsRequired(Boolean isRequired) {
        this.isRequired = isRequired;
        return this;
    }

    public String getRows() {
        return rows;
    }

    public void setRows(String rows) {
        this.rows = rows;
    }

    public Options_ withRows(String rows) {
        this.rows = rows;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("format", format).append("hasActual", hasActual).append("hasExpected", hasExpected).append("isRequired", isRequired).append("rows", rows).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(format).append(hasActual).append(isRequired).append(rows).append(hasExpected).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Options_) == false) {
            return false;
        }
        Options_ rhs = ((Options_) other);
        return new EqualsBuilder().append(format, rhs.format).append(hasActual, rhs.hasActual).append(isRequired, rhs.isRequired).append(rows, rhs.rows).append(hasExpected, rhs.hasExpected).isEquals();
    }

}
