
package org.touchbit.testrail4j.gson.model;

import java.util.ArrayList;
import java.util.List;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TRCase {

    /**
     * The ID of the user who created the test case
     * 
     */
    @SerializedName("created_by")
    @Expose
    private Long createdBy;
    /**
     * The date/time when the test case was created (as UNIX timestamp)
     * 
     */
    @SerializedName("created_on")
    @Expose
    private Long createdOn;
    /**
     * The estimate, e.g. '30s' or '1m 45s'
     * 
     */
    @SerializedName("estimate")
    @Expose
    private String estimate;
    /**
     * The estimate forecast, e.g. '30s' or '1m 45s'
     * 
     */
    @SerializedName("estimate_forecast")
    @Expose
    private String estimateForecast;
    /**
     * The unique ID of the test case
     * 
     */
    @SerializedName("id")
    @Expose
    private Long id;
    /**
     * The ID of the milestone that is linked to the test case
     * 
     */
    @SerializedName("milestone_id")
    @Expose
    private Long milestoneId;
    /**
     * The ID of the priority that is linked to the test case
     * 
     */
    @SerializedName("priority_id")
    @Expose
    private Long priorityId;
    /**
     * A comma-separated list of references/requirements
     * 
     */
    @SerializedName("refs")
    @Expose
    private String refs;
    /**
     * The ID of the section the test case belongs to
     * 
     */
    @SerializedName("section_id")
    @Expose
    private Long sectionId;
    /**
     * The ID of the suite the test case belongs to
     * 
     */
    @SerializedName("suite_id")
    @Expose
    private Long suiteId;
    /**
     * The title of the test case
     * 
     */
    @SerializedName("title")
    @Expose
    private String title;
    /**
     * The ID of the test case type that is linked to the test case
     * 
     */
    @SerializedName("type_id")
    @Expose
    private Long typeId;
    /**
     * The ID of the template (field layout) the test case uses (requires TestRail 5.2 or later)
     * 
     */
    @SerializedName("template_id")
    @Expose
    private Long templateId;
    /**
     * The ID of the user who last updated the test case
     * 
     */
    @SerializedName("updated_by")
    @Expose
    private Long updatedBy;
    /**
     * The date/time when the test case was last updated (as UNIX timestamp)
     * 
     */
    @SerializedName("updated_on")
    @Expose
    private Long updatedOn;
    /**
     * Test Case (Text) template steps
     * 
     */
    @SerializedName("custom_steps")
    @Expose
    private String customSteps;
    /**
     * Test Case (Text) template expected result
     * 
     */
    @SerializedName("custom_expected")
    @Expose
    private String customExpected;
    /**
     * Test Case (Text) template preconditions
     * 
     */
    @SerializedName("custom_preconds")
    @Expose
    private String customPreconds;
    /**
     * Exploratory Session template mission
     * 
     */
    @SerializedName("custom_mission")
    @Expose
    private String customMission;
    /**
     * Exploratory Session template goals
     * 
     */
    @SerializedName("custom_goals")
    @Expose
    private String customGoals;
    /**
     * Automation Type. Default values: 0 - None, 1 - Ranorex
     * 
     */
    @SerializedName("custom_automation_type")
    @Expose
    private Long customAutomationType;
    /**
     * Test Case (Steps) template steps
     * 
     */
    @SerializedName("custom_steps_separated")
    @Expose
    private List<TRStep> customStepsSeparated = new ArrayList<TRStep>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRCase() {
    }

    /**
     * 
     * @param suiteId
     * @param updatedBy
     * @param customExpected
     * @param customAutomationType
     * @param milestoneId
     * @param customPreconds
     * @param sectionId
     * @param updatedOn
     * @param title
     * @param templateId
     * @param createdOn
     * @param customStepsSeparated
     * @param priorityId
     * @param createdBy
     * @param refs
     * @param customSteps
     * @param customGoals
     * @param estimate
     * @param customMission
     * @param typeId
     * @param estimateForecast
     * @param id
     */
    public TRCase(Long createdBy, Long createdOn, String estimate, String estimateForecast, Long id, Long milestoneId, Long priorityId, String refs, Long sectionId, Long suiteId, String title, Long typeId, Long templateId, Long updatedBy, Long updatedOn, String customSteps, String customExpected, String customPreconds, String customMission, String customGoals, Long customAutomationType, List<TRStep> customStepsSeparated) {
        super();
        this.createdBy = createdBy;
        this.createdOn = createdOn;
        this.estimate = estimate;
        this.estimateForecast = estimateForecast;
        this.id = id;
        this.milestoneId = milestoneId;
        this.priorityId = priorityId;
        this.refs = refs;
        this.sectionId = sectionId;
        this.suiteId = suiteId;
        this.title = title;
        this.typeId = typeId;
        this.templateId = templateId;
        this.updatedBy = updatedBy;
        this.updatedOn = updatedOn;
        this.customSteps = customSteps;
        this.customExpected = customExpected;
        this.customPreconds = customPreconds;
        this.customMission = customMission;
        this.customGoals = customGoals;
        this.customAutomationType = customAutomationType;
        this.customStepsSeparated = customStepsSeparated;
    }

    /**
     * The ID of the user who created the test case
     * 
     */
    public Long getCreatedBy() {
        return createdBy;
    }

    /**
     * The ID of the user who created the test case
     * 
     */
    public void setCreatedBy(Long createdBy) {
        this.createdBy = createdBy;
    }

    public TRCase withCreatedBy(Long createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * The date/time when the test case was created (as UNIX timestamp)
     * 
     */
    public Long getCreatedOn() {
        return createdOn;
    }

    /**
     * The date/time when the test case was created (as UNIX timestamp)
     * 
     */
    public void setCreatedOn(Long createdOn) {
        this.createdOn = createdOn;
    }

    public TRCase withCreatedOn(Long createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    /**
     * The estimate, e.g. '30s' or '1m 45s'
     * 
     */
    public String getEstimate() {
        return estimate;
    }

    /**
     * The estimate, e.g. '30s' or '1m 45s'
     * 
     */
    public void setEstimate(String estimate) {
        this.estimate = estimate;
    }

    public TRCase withEstimate(String estimate) {
        this.estimate = estimate;
        return this;
    }

    /**
     * The estimate forecast, e.g. '30s' or '1m 45s'
     * 
     */
    public String getEstimateForecast() {
        return estimateForecast;
    }

    /**
     * The estimate forecast, e.g. '30s' or '1m 45s'
     * 
     */
    public void setEstimateForecast(String estimateForecast) {
        this.estimateForecast = estimateForecast;
    }

    public TRCase withEstimateForecast(String estimateForecast) {
        this.estimateForecast = estimateForecast;
        return this;
    }

    /**
     * The unique ID of the test case
     * 
     */
    public Long getId() {
        return id;
    }

    /**
     * The unique ID of the test case
     * 
     */
    public void setId(Long id) {
        this.id = id;
    }

    public TRCase withId(Long id) {
        this.id = id;
        return this;
    }

    /**
     * The ID of the milestone that is linked to the test case
     * 
     */
    public Long getMilestoneId() {
        return milestoneId;
    }

    /**
     * The ID of the milestone that is linked to the test case
     * 
     */
    public void setMilestoneId(Long milestoneId) {
        this.milestoneId = milestoneId;
    }

    public TRCase withMilestoneId(Long milestoneId) {
        this.milestoneId = milestoneId;
        return this;
    }

    /**
     * The ID of the priority that is linked to the test case
     * 
     */
    public Long getPriorityId() {
        return priorityId;
    }

    /**
     * The ID of the priority that is linked to the test case
     * 
     */
    public void setPriorityId(Long priorityId) {
        this.priorityId = priorityId;
    }

    public TRCase withPriorityId(Long priorityId) {
        this.priorityId = priorityId;
        return this;
    }

    /**
     * A comma-separated list of references/requirements
     * 
     */
    public String getRefs() {
        return refs;
    }

    /**
     * A comma-separated list of references/requirements
     * 
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    public TRCase withRefs(String refs) {
        this.refs = refs;
        return this;
    }

    /**
     * The ID of the section the test case belongs to
     * 
     */
    public Long getSectionId() {
        return sectionId;
    }

    /**
     * The ID of the section the test case belongs to
     * 
     */
    public void setSectionId(Long sectionId) {
        this.sectionId = sectionId;
    }

    public TRCase withSectionId(Long sectionId) {
        this.sectionId = sectionId;
        return this;
    }

    /**
     * The ID of the suite the test case belongs to
     * 
     */
    public Long getSuiteId() {
        return suiteId;
    }

    /**
     * The ID of the suite the test case belongs to
     * 
     */
    public void setSuiteId(Long suiteId) {
        this.suiteId = suiteId;
    }

    public TRCase withSuiteId(Long suiteId) {
        this.suiteId = suiteId;
        return this;
    }

    /**
     * The title of the test case
     * 
     */
    public String getTitle() {
        return title;
    }

    /**
     * The title of the test case
     * 
     */
    public void setTitle(String title) {
        this.title = title;
    }

    public TRCase withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * The ID of the test case type that is linked to the test case
     * 
     */
    public Long getTypeId() {
        return typeId;
    }

    /**
     * The ID of the test case type that is linked to the test case
     * 
     */
    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }

    public TRCase withTypeId(Long typeId) {
        this.typeId = typeId;
        return this;
    }

    /**
     * The ID of the template (field layout) the test case uses (requires TestRail 5.2 or later)
     * 
     */
    public Long getTemplateId() {
        return templateId;
    }

    /**
     * The ID of the template (field layout) the test case uses (requires TestRail 5.2 or later)
     * 
     */
    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public TRCase withTemplateId(Long templateId) {
        this.templateId = templateId;
        return this;
    }

    /**
     * The ID of the user who last updated the test case
     * 
     */
    public Long getUpdatedBy() {
        return updatedBy;
    }

    /**
     * The ID of the user who last updated the test case
     * 
     */
    public void setUpdatedBy(Long updatedBy) {
        this.updatedBy = updatedBy;
    }

    public TRCase withUpdatedBy(Long updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    /**
     * The date/time when the test case was last updated (as UNIX timestamp)
     * 
     */
    public Long getUpdatedOn() {
        return updatedOn;
    }

    /**
     * The date/time when the test case was last updated (as UNIX timestamp)
     * 
     */
    public void setUpdatedOn(Long updatedOn) {
        this.updatedOn = updatedOn;
    }

    public TRCase withUpdatedOn(Long updatedOn) {
        this.updatedOn = updatedOn;
        return this;
    }

    /**
     * Test Case (Text) template steps
     * 
     */
    public String getCustomSteps() {
        return customSteps;
    }

    /**
     * Test Case (Text) template steps
     * 
     */
    public void setCustomSteps(String customSteps) {
        this.customSteps = customSteps;
    }

    public TRCase withCustomSteps(String customSteps) {
        this.customSteps = customSteps;
        return this;
    }

    /**
     * Test Case (Text) template expected result
     * 
     */
    public String getCustomExpected() {
        return customExpected;
    }

    /**
     * Test Case (Text) template expected result
     * 
     */
    public void setCustomExpected(String customExpected) {
        this.customExpected = customExpected;
    }

    public TRCase withCustomExpected(String customExpected) {
        this.customExpected = customExpected;
        return this;
    }

    /**
     * Test Case (Text) template preconditions
     * 
     */
    public String getCustomPreconds() {
        return customPreconds;
    }

    /**
     * Test Case (Text) template preconditions
     * 
     */
    public void setCustomPreconds(String customPreconds) {
        this.customPreconds = customPreconds;
    }

    public TRCase withCustomPreconds(String customPreconds) {
        this.customPreconds = customPreconds;
        return this;
    }

    /**
     * Exploratory Session template mission
     * 
     */
    public String getCustomMission() {
        return customMission;
    }

    /**
     * Exploratory Session template mission
     * 
     */
    public void setCustomMission(String customMission) {
        this.customMission = customMission;
    }

    public TRCase withCustomMission(String customMission) {
        this.customMission = customMission;
        return this;
    }

    /**
     * Exploratory Session template goals
     * 
     */
    public String getCustomGoals() {
        return customGoals;
    }

    /**
     * Exploratory Session template goals
     * 
     */
    public void setCustomGoals(String customGoals) {
        this.customGoals = customGoals;
    }

    public TRCase withCustomGoals(String customGoals) {
        this.customGoals = customGoals;
        return this;
    }

    /**
     * Automation Type. Default values: 0 - None, 1 - Ranorex
     * 
     */
    public Long getCustomAutomationType() {
        return customAutomationType;
    }

    /**
     * Automation Type. Default values: 0 - None, 1 - Ranorex
     * 
     */
    public void setCustomAutomationType(Long customAutomationType) {
        this.customAutomationType = customAutomationType;
    }

    public TRCase withCustomAutomationType(Long customAutomationType) {
        this.customAutomationType = customAutomationType;
        return this;
    }

    /**
     * Test Case (Steps) template steps
     * 
     */
    public List<TRStep> getCustomStepsSeparated() {
        return customStepsSeparated;
    }

    /**
     * Test Case (Steps) template steps
     * 
     */
    public void setCustomStepsSeparated(List<TRStep> customStepsSeparated) {
        this.customStepsSeparated = customStepsSeparated;
    }

    public TRCase withCustomStepsSeparated(List<TRStep> customStepsSeparated) {
        this.customStepsSeparated = customStepsSeparated;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("createdBy", createdBy).append("createdOn", createdOn).append("estimate", estimate).append("estimateForecast", estimateForecast).append("id", id).append("milestoneId", milestoneId).append("priorityId", priorityId).append("refs", refs).append("sectionId", sectionId).append("suiteId", suiteId).append("title", title).append("typeId", typeId).append("templateId", templateId).append("updatedBy", updatedBy).append("updatedOn", updatedOn).append("customSteps", customSteps).append("customExpected", customExpected).append("customPreconds", customPreconds).append("customMission", customMission).append("customGoals", customGoals).append("customAutomationType", customAutomationType).append("customStepsSeparated", customStepsSeparated).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(suiteId).append(updatedBy).append(customExpected).append(customAutomationType).append(milestoneId).append(customPreconds).append(sectionId).append(updatedOn).append(title).append(templateId).append(createdOn).append(customStepsSeparated).append(priorityId).append(createdBy).append(refs).append(customSteps).append(customGoals).append(estimate).append(customMission).append(typeId).append(estimateForecast).append(id).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRCase) == false) {
            return false;
        }
        TRCase rhs = ((TRCase) other);
        return new EqualsBuilder().append(suiteId, rhs.suiteId).append(updatedBy, rhs.updatedBy).append(customExpected, rhs.customExpected).append(customAutomationType, rhs.customAutomationType).append(milestoneId, rhs.milestoneId).append(customPreconds, rhs.customPreconds).append(sectionId, rhs.sectionId).append(updatedOn, rhs.updatedOn).append(title, rhs.title).append(templateId, rhs.templateId).append(createdOn, rhs.createdOn).append(customStepsSeparated, rhs.customStepsSeparated).append(priorityId, rhs.priorityId).append(createdBy, rhs.createdBy).append(refs, rhs.refs).append(customSteps, rhs.customSteps).append(customGoals, rhs.customGoals).append(estimate, rhs.estimate).append(customMission, rhs.customMission).append(typeId, rhs.typeId).append(estimateForecast, rhs.estimateForecast).append(id, rhs.id).isEquals();
    }

}
