
package org.touchbit.testrail4j.gson.model;

import java.util.ArrayList;
import java.util.List;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;


/**
 * Case custom field. See http://docs.gurock.com/testrail-api2/reference-cases-fields#add_case_field
 * 
 */
public class TRCaseField {

    /**
     * An object wrapped in an array with two default keys, 'context' and 'options'
     * 
     */
    @SerializedName("configs")
    @Expose
    private List<TRCaseFieldConfig> configs = new ArrayList<TRCaseFieldConfig>();
    /**
     * The description for the new custom field
     * 
     */
    @SerializedName("description")
    @Expose
    private String description;
    @SerializedName("display_order")
    @Expose
    private java.lang.Long displayOrder;
    @SerializedName("id")
    @Expose
    private java.lang.Long id;
    @SerializedName("is_multi")
    @Expose
    private java.lang.Long isMulti;
    @SerializedName("is_active")
    @Expose
    private Boolean isActive;
    @SerializedName("status_id")
    @Expose
    private java.lang.Long statusId;
    @SerializedName("is_system")
    @Expose
    private java.lang.Long isSystem;
    @SerializedName("entity_id")
    @Expose
    private java.lang.Long entityId;
    /**
     * The label for custom field
     * (Required)
     * 
     */
    @SerializedName("label")
    @Expose
    private String label;
    /**
     * The name for custom field
     * (Required)
     * 
     */
    @SerializedName("name")
    @Expose
    private String name;
    /**
     * The system name for custom field
     * 
     */
    @SerializedName("system_name")
    @Expose
    private String systemName;
    /**
     * See FieldTypes class. You can pass the number of the type as well as the word, e.g. 5, string, String, Dropdown, 12. The numbers must be sent as a string e.g {type: "5"} not {type: 5}, otherwise you will get a 400 (Bad Request) response.
     * 
     */
    @SerializedName("type")
    @Expose
    private String type;
    /**
     * See FieldTypes class
     * (Required)
     * 
     */
    @SerializedName("type_id")
    @Expose
    private java.lang.Long typeId;
    /**
     * See FieldTypes class
     * 
     */
    @SerializedName("location_id")
    @Expose
    private java.lang.Long locationId;
    /**
     * Set flag to true if you want the new custom field included for all templates. Otherwise (false) specify the ID's of templates to be included as the next parameter (template_ids)
     * 
     */
    @SerializedName("include_all")
    @Expose
    private Boolean includeAll;
    /**
     * ID's of templates new custom field will apply to if include_all is set to false
     * 
     */
    @SerializedName("template_ids")
    @Expose
    private List<Long> templateIds = new ArrayList<Long>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRCaseField() {
    }

    /**
     * 
     * @param configs
     * @param templateIds
     * @param displayOrder
     * @param description
     * @param entityId
     * @param includeAll
     * @param label
     * @param isActive
     * @param type
     * @param isMulti
     * @param isSystem
     * @param statusId
     * @param systemName
     * @param locationId
     * @param name
     * @param typeId
     * @param id
     */
    public TRCaseField(List<TRCaseFieldConfig> configs, String description, java.lang.Long displayOrder, java.lang.Long id, java.lang.Long isMulti, Boolean isActive, java.lang.Long statusId, java.lang.Long isSystem, java.lang.Long entityId, String label, String name, String systemName, String type, java.lang.Long typeId, java.lang.Long locationId, Boolean includeAll, List<Long> templateIds) {
        super();
        this.configs = configs;
        this.description = description;
        this.displayOrder = displayOrder;
        this.id = id;
        this.isMulti = isMulti;
        this.isActive = isActive;
        this.statusId = statusId;
        this.isSystem = isSystem;
        this.entityId = entityId;
        this.label = label;
        this.name = name;
        this.systemName = systemName;
        this.type = type;
        this.typeId = typeId;
        this.locationId = locationId;
        this.includeAll = includeAll;
        this.templateIds = templateIds;
    }

    /**
     * An object wrapped in an array with two default keys, 'context' and 'options'
     * 
     */
    public List<TRCaseFieldConfig> getConfigs() {
        return configs;
    }

    /**
     * An object wrapped in an array with two default keys, 'context' and 'options'
     * 
     */
    public void setConfigs(List<TRCaseFieldConfig> configs) {
        this.configs = configs;
    }

    public TRCaseField withConfigs(List<TRCaseFieldConfig> configs) {
        this.configs = configs;
        return this;
    }

    /**
     * The description for the new custom field
     * 
     */
    public String getDescription() {
        return description;
    }

    /**
     * The description for the new custom field
     * 
     */
    public void setDescription(String description) {
        this.description = description;
    }

    public TRCaseField withDescription(String description) {
        this.description = description;
        return this;
    }

    public java.lang.Long getDisplayOrder() {
        return displayOrder;
    }

    public void setDisplayOrder(java.lang.Long displayOrder) {
        this.displayOrder = displayOrder;
    }

    public TRCaseField withDisplayOrder(java.lang.Long displayOrder) {
        this.displayOrder = displayOrder;
        return this;
    }

    public java.lang.Long getId() {
        return id;
    }

    public void setId(java.lang.Long id) {
        this.id = id;
    }

    public TRCaseField withId(java.lang.Long id) {
        this.id = id;
        return this;
    }

    public java.lang.Long getIsMulti() {
        return isMulti;
    }

    public void setIsMulti(java.lang.Long isMulti) {
        this.isMulti = isMulti;
    }

    public TRCaseField withIsMulti(java.lang.Long isMulti) {
        this.isMulti = isMulti;
        return this;
    }

    public Boolean getIsActive() {
        return isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public TRCaseField withIsActive(Boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    public java.lang.Long getStatusId() {
        return statusId;
    }

    public void setStatusId(java.lang.Long statusId) {
        this.statusId = statusId;
    }

    public TRCaseField withStatusId(java.lang.Long statusId) {
        this.statusId = statusId;
        return this;
    }

    public java.lang.Long getIsSystem() {
        return isSystem;
    }

    public void setIsSystem(java.lang.Long isSystem) {
        this.isSystem = isSystem;
    }

    public TRCaseField withIsSystem(java.lang.Long isSystem) {
        this.isSystem = isSystem;
        return this;
    }

    public java.lang.Long getEntityId() {
        return entityId;
    }

    public void setEntityId(java.lang.Long entityId) {
        this.entityId = entityId;
    }

    public TRCaseField withEntityId(java.lang.Long entityId) {
        this.entityId = entityId;
        return this;
    }

    /**
     * The label for custom field
     * (Required)
     * 
     */
    public String getLabel() {
        return label;
    }

    /**
     * The label for custom field
     * (Required)
     * 
     */
    public void setLabel(String label) {
        this.label = label;
    }

    public TRCaseField withLabel(String label) {
        this.label = label;
        return this;
    }

    /**
     * The name for custom field
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * The name for custom field
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    public TRCaseField withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * The system name for custom field
     * 
     */
    public String getSystemName() {
        return systemName;
    }

    /**
     * The system name for custom field
     * 
     */
    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public TRCaseField withSystemName(String systemName) {
        this.systemName = systemName;
        return this;
    }

    /**
     * See FieldTypes class. You can pass the number of the type as well as the word, e.g. 5, string, String, Dropdown, 12. The numbers must be sent as a string e.g {type: "5"} not {type: 5}, otherwise you will get a 400 (Bad Request) response.
     * 
     */
    public String getType() {
        return type;
    }

    /**
     * See FieldTypes class. You can pass the number of the type as well as the word, e.g. 5, string, String, Dropdown, 12. The numbers must be sent as a string e.g {type: "5"} not {type: 5}, otherwise you will get a 400 (Bad Request) response.
     * 
     */
    public void setType(String type) {
        this.type = type;
    }

    public TRCaseField withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * See FieldTypes class
     * (Required)
     * 
     */
    public java.lang.Long getTypeId() {
        return typeId;
    }

    /**
     * See FieldTypes class
     * (Required)
     * 
     */
    public void setTypeId(java.lang.Long typeId) {
        this.typeId = typeId;
    }

    public TRCaseField withTypeId(java.lang.Long typeId) {
        this.typeId = typeId;
        return this;
    }

    /**
     * See FieldTypes class
     * 
     */
    public java.lang.Long getLocationId() {
        return locationId;
    }

    /**
     * See FieldTypes class
     * 
     */
    public void setLocationId(java.lang.Long locationId) {
        this.locationId = locationId;
    }

    public TRCaseField withLocationId(java.lang.Long locationId) {
        this.locationId = locationId;
        return this;
    }

    /**
     * Set flag to true if you want the new custom field included for all templates. Otherwise (false) specify the ID's of templates to be included as the next parameter (template_ids)
     * 
     */
    public Boolean getIncludeAll() {
        return includeAll;
    }

    /**
     * Set flag to true if you want the new custom field included for all templates. Otherwise (false) specify the ID's of templates to be included as the next parameter (template_ids)
     * 
     */
    public void setIncludeAll(Boolean includeAll) {
        this.includeAll = includeAll;
    }

    public TRCaseField withIncludeAll(Boolean includeAll) {
        this.includeAll = includeAll;
        return this;
    }

    /**
     * ID's of templates new custom field will apply to if include_all is set to false
     * 
     */
    public List<Long> getTemplateIds() {
        return templateIds;
    }

    /**
     * ID's of templates new custom field will apply to if include_all is set to false
     * 
     */
    public void setTemplateIds(List<Long> templateIds) {
        this.templateIds = templateIds;
    }

    public TRCaseField withTemplateIds(List<Long> templateIds) {
        this.templateIds = templateIds;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("configs", configs).append("description", description).append("displayOrder", displayOrder).append("id", id).append("isMulti", isMulti).append("isActive", isActive).append("statusId", statusId).append("isSystem", isSystem).append("entityId", entityId).append("label", label).append("name", name).append("systemName", systemName).append("type", type).append("typeId", typeId).append("locationId", locationId).append("includeAll", includeAll).append("templateIds", templateIds).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(configs).append(templateIds).append(displayOrder).append(description).append(entityId).append(includeAll).append(label).append(isActive).append(type).append(isMulti).append(isSystem).append(statusId).append(systemName).append(locationId).append(name).append(typeId).append(id).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRCaseField) == false) {
            return false;
        }
        TRCaseField rhs = ((TRCaseField) other);
        return new EqualsBuilder().append(configs, rhs.configs).append(templateIds, rhs.templateIds).append(displayOrder, rhs.displayOrder).append(description, rhs.description).append(entityId, rhs.entityId).append(includeAll, rhs.includeAll).append(label, rhs.label).append(isActive, rhs.isActive).append(type, rhs.type).append(isMulti, rhs.isMulti).append(isSystem, rhs.isSystem).append(statusId, rhs.statusId).append(systemName, rhs.systemName).append(locationId, rhs.locationId).append(name, rhs.name).append(typeId, rhs.typeId).append(id, rhs.id).isEquals();
    }

}
