
package org.touchbit.testrail4j.gson.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TRCaseFieldConfig {

    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("context")
    @Expose
    private Context context;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("id")
    @Expose
    private String id;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("options")
    @Expose
    private Options options;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRCaseFieldConfig() {
    }

    /**
     * 
     * @param context
     * @param options
     * @param id
     */
    public TRCaseFieldConfig(Context context, String id, Options options) {
        super();
        this.context = context;
        this.id = id;
        this.options = options;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Context getContext() {
        return context;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setContext(Context context) {
        this.context = context;
    }

    public TRCaseFieldConfig withContext(Context context) {
        this.context = context;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getId() {
        return id;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setId(String id) {
        this.id = id;
    }

    public TRCaseFieldConfig withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Options getOptions() {
        return options;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setOptions(Options options) {
        this.options = options;
    }

    public TRCaseFieldConfig withOptions(Options options) {
        this.options = options;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("context", context).append("id", id).append("options", options).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(context).append(options).append(id).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRCaseFieldConfig) == false) {
            return false;
        }
        TRCaseFieldConfig rhs = ((TRCaseFieldConfig) other);
        return new EqualsBuilder().append(context, rhs.context).append(options, rhs.options).append(id, rhs.id).isEquals();
    }

}
