
package org.touchbit.testrail4j.gson.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TRCaseType {

    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("id")
    @Expose
    private Long id;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("is_default")
    @Expose
    private Boolean isDefault;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("name")
    @Expose
    private String name;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRCaseType() {
    }

    /**
     * 
     * @param isDefault
     * @param name
     * @param id
     */
    public TRCaseType(Long id, Boolean isDefault, String name) {
        super();
        this.id = id;
        this.isDefault = isDefault;
        this.name = name;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Long getId() {
        return id;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setId(Long id) {
        this.id = id;
    }

    public TRCaseType withId(Long id) {
        this.id = id;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Boolean getIsDefault() {
        return isDefault;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public TRCaseType withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    public TRCaseType withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("id", id).append("isDefault", isDefault).append("name", name).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(name).append(isDefault).append(id).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRCaseType) == false) {
            return false;
        }
        TRCaseType rhs = ((TRCaseType) other);
        return new EqualsBuilder().append(name, rhs.name).append(isDefault, rhs.isDefault).append(id, rhs.id).isEquals();
    }

}
