
package org.touchbit.testrail4j.gson.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TRError {

    /**
     * Error message
     * (Required)
     * 
     */
    @SerializedName("error")
    @Expose
    private String error;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRError() {
    }

    /**
     * 
     * @param error
     */
    public TRError(String error) {
        super();
        this.error = error;
    }

    /**
     * Error message
     * (Required)
     * 
     */
    public String getError() {
        return error;
    }

    /**
     * Error message
     * (Required)
     * 
     */
    public void setError(String error) {
        this.error = error;
    }

    public TRError withError(String error) {
        this.error = error;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("error", error).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(error).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRError) == false) {
            return false;
        }
        TRError rhs = ((TRError) other);
        return new EqualsBuilder().append(error, rhs.error).isEquals();
    }

}
