
package org.touchbit.testrail4j.gson.model;

import java.util.ArrayList;
import java.util.List;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TRMilestone {

    /**
     * The date/time when the milestone was marked as completed (as UNIX timestamp)
     * 
     */
    @SerializedName("completed_on")
    @Expose
    private Long completedOn;
    /**
     * The description of the milestone
     * 
     */
    @SerializedName("description")
    @Expose
    private String description;
    /**
     * The due date/time of the milestone (as UNIX timestamp)
     * 
     */
    @SerializedName("due_on")
    @Expose
    private Long dueOn;
    /**
     * The scheduled start date/time of the milestone (as UNIX timestamp) (available since TestRail 5.3)
     * 
     */
    @SerializedName("start_on")
    @Expose
    private Long startOn;
    /**
     * The date/time when the milestone was started (as UNIX timestamp) (available since TestRail 5.3)
     * 
     */
    @SerializedName("started_on")
    @Expose
    private Long startedOn;
    /**
     * The unique ID of the milestone
     * 
     */
    @SerializedName("id")
    @Expose
    private Long id;
    /**
     * The ID of the parent milestone the milestone belongs to (if any) (available since TestRail 5.3)
     * 
     */
    @SerializedName("parent_id")
    @Expose
    private Long parentId;
    /**
     * True if the milestone is marked as completed and false otherwise
     * 
     */
    @SerializedName("is_completed")
    @Expose
    private Boolean isCompleted;
    /**
     * True if the milestone is marked as started and false otherwise (available since TestRail 5.3)
     * 
     */
    @SerializedName("is_started")
    @Expose
    private Boolean isStarted;
    /**
     * The sub milestones that belong to the milestone (if any); only available with get_milestone (available since TestRail 5.3)
     * 
     */
    @SerializedName("milestones")
    @Expose
    private List<TRMilestone> milestones = new ArrayList<TRMilestone>();
    /**
     * The name of the milestone
     * (Required)
     * 
     */
    @SerializedName("name")
    @Expose
    private String name;
    /**
     * The ID of the project the milestone belongs to
     * 
     */
    @SerializedName("project_id")
    @Expose
    private Long projectId;
    /**
     * The address/URL of the milestone in the user interface
     * 
     */
    @SerializedName("url")
    @Expose
    private String url;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRMilestone() {
    }

    /**
     * 
     * @param dueOn
     * @param description
     * @param startOn
     * @param isStarted
     * @param parentId
     * @param url
     * @param completedOn
     * @param name
     * @param id
     * @param milestones
     * @param startedOn
     * @param projectId
     * @param isCompleted
     */
    public TRMilestone(Long completedOn, String description, Long dueOn, Long startOn, Long startedOn, Long id, Long parentId, Boolean isCompleted, Boolean isStarted, List<TRMilestone> milestones, String name, Long projectId, String url) {
        super();
        this.completedOn = completedOn;
        this.description = description;
        this.dueOn = dueOn;
        this.startOn = startOn;
        this.startedOn = startedOn;
        this.id = id;
        this.parentId = parentId;
        this.isCompleted = isCompleted;
        this.isStarted = isStarted;
        this.milestones = milestones;
        this.name = name;
        this.projectId = projectId;
        this.url = url;
    }

    /**
     * The date/time when the milestone was marked as completed (as UNIX timestamp)
     * 
     */
    public Long getCompletedOn() {
        return completedOn;
    }

    /**
     * The date/time when the milestone was marked as completed (as UNIX timestamp)
     * 
     */
    public void setCompletedOn(Long completedOn) {
        this.completedOn = completedOn;
    }

    public TRMilestone withCompletedOn(Long completedOn) {
        this.completedOn = completedOn;
        return this;
    }

    /**
     * The description of the milestone
     * 
     */
    public String getDescription() {
        return description;
    }

    /**
     * The description of the milestone
     * 
     */
    public void setDescription(String description) {
        this.description = description;
    }

    public TRMilestone withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * The due date/time of the milestone (as UNIX timestamp)
     * 
     */
    public Long getDueOn() {
        return dueOn;
    }

    /**
     * The due date/time of the milestone (as UNIX timestamp)
     * 
     */
    public void setDueOn(Long dueOn) {
        this.dueOn = dueOn;
    }

    public TRMilestone withDueOn(Long dueOn) {
        this.dueOn = dueOn;
        return this;
    }

    /**
     * The scheduled start date/time of the milestone (as UNIX timestamp) (available since TestRail 5.3)
     * 
     */
    public Long getStartOn() {
        return startOn;
    }

    /**
     * The scheduled start date/time of the milestone (as UNIX timestamp) (available since TestRail 5.3)
     * 
     */
    public void setStartOn(Long startOn) {
        this.startOn = startOn;
    }

    public TRMilestone withStartOn(Long startOn) {
        this.startOn = startOn;
        return this;
    }

    /**
     * The date/time when the milestone was started (as UNIX timestamp) (available since TestRail 5.3)
     * 
     */
    public Long getStartedOn() {
        return startedOn;
    }

    /**
     * The date/time when the milestone was started (as UNIX timestamp) (available since TestRail 5.3)
     * 
     */
    public void setStartedOn(Long startedOn) {
        this.startedOn = startedOn;
    }

    public TRMilestone withStartedOn(Long startedOn) {
        this.startedOn = startedOn;
        return this;
    }

    /**
     * The unique ID of the milestone
     * 
     */
    public Long getId() {
        return id;
    }

    /**
     * The unique ID of the milestone
     * 
     */
    public void setId(Long id) {
        this.id = id;
    }

    public TRMilestone withId(Long id) {
        this.id = id;
        return this;
    }

    /**
     * The ID of the parent milestone the milestone belongs to (if any) (available since TestRail 5.3)
     * 
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * The ID of the parent milestone the milestone belongs to (if any) (available since TestRail 5.3)
     * 
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public TRMilestone withParentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    /**
     * True if the milestone is marked as completed and false otherwise
     * 
     */
    public Boolean getIsCompleted() {
        return isCompleted;
    }

    /**
     * True if the milestone is marked as completed and false otherwise
     * 
     */
    public void setIsCompleted(Boolean isCompleted) {
        this.isCompleted = isCompleted;
    }

    public TRMilestone withIsCompleted(Boolean isCompleted) {
        this.isCompleted = isCompleted;
        return this;
    }

    /**
     * True if the milestone is marked as started and false otherwise (available since TestRail 5.3)
     * 
     */
    public Boolean getIsStarted() {
        return isStarted;
    }

    /**
     * True if the milestone is marked as started and false otherwise (available since TestRail 5.3)
     * 
     */
    public void setIsStarted(Boolean isStarted) {
        this.isStarted = isStarted;
    }

    public TRMilestone withIsStarted(Boolean isStarted) {
        this.isStarted = isStarted;
        return this;
    }

    /**
     * The sub milestones that belong to the milestone (if any); only available with get_milestone (available since TestRail 5.3)
     * 
     */
    public List<TRMilestone> getMilestones() {
        return milestones;
    }

    /**
     * The sub milestones that belong to the milestone (if any); only available with get_milestone (available since TestRail 5.3)
     * 
     */
    public void setMilestones(List<TRMilestone> milestones) {
        this.milestones = milestones;
    }

    public TRMilestone withMilestones(List<TRMilestone> milestones) {
        this.milestones = milestones;
        return this;
    }

    /**
     * The name of the milestone
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * The name of the milestone
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    public TRMilestone withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * The ID of the project the milestone belongs to
     * 
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * The ID of the project the milestone belongs to
     * 
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public TRMilestone withProjectId(Long projectId) {
        this.projectId = projectId;
        return this;
    }

    /**
     * The address/URL of the milestone in the user interface
     * 
     */
    public String getUrl() {
        return url;
    }

    /**
     * The address/URL of the milestone in the user interface
     * 
     */
    public void setUrl(String url) {
        this.url = url;
    }

    public TRMilestone withUrl(String url) {
        this.url = url;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("completedOn", completedOn).append("description", description).append("dueOn", dueOn).append("startOn", startOn).append("startedOn", startedOn).append("id", id).append("parentId", parentId).append("isCompleted", isCompleted).append("isStarted", isStarted).append("milestones", milestones).append("name", name).append("projectId", projectId).append("url", url).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(dueOn).append(description).append(startOn).append(isStarted).append(parentId).append(url).append(completedOn).append(name).append(id).append(milestones).append(startedOn).append(projectId).append(isCompleted).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRMilestone) == false) {
            return false;
        }
        TRMilestone rhs = ((TRMilestone) other);
        return new EqualsBuilder().append(dueOn, rhs.dueOn).append(description, rhs.description).append(startOn, rhs.startOn).append(isStarted, rhs.isStarted).append(parentId, rhs.parentId).append(url, rhs.url).append(completedOn, rhs.completedOn).append(name, rhs.name).append(id, rhs.id).append(milestones, rhs.milestones).append(startedOn, rhs.startedOn).append(projectId, rhs.projectId).append(isCompleted, rhs.isCompleted).isEquals();
    }

}
