
package org.touchbit.testrail4j.gson.model;

import java.util.ArrayList;
import java.util.List;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TRPlan {

    /**
     * The ID of the user the entire test plan is assigned to
     * 
     */
    @SerializedName("assignedto_id")
    @Expose
    private Long assignedtoId;
    /**
     * The amount of tests in the test plan marked as blocked
     * 
     */
    @SerializedName("blocked_count")
    @Expose
    private Long blockedCount;
    /**
     * The date/time when the test plan was closed (as UNIX timestamp)
     * 
     */
    @SerializedName("completed_on")
    @Expose
    private Long completedOn;
    /**
     * The ID of the user who created the test plan
     * 
     */
    @SerializedName("created_by")
    @Expose
    private Long createdBy;
    /**
     * The date/time when the test plan was created (as UNIX timestamp)
     * 
     */
    @SerializedName("created_on")
    @Expose
    private Long createdOn;
    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    @SerializedName("custom_status1_count")
    @Expose
    private Long customStatus1Count;
    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    @SerializedName("custom_status2_count")
    @Expose
    private Long customStatus2Count;
    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    @SerializedName("custom_status3_count")
    @Expose
    private Long customStatus3Count;
    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    @SerializedName("custom_status4_count")
    @Expose
    private Long customStatus4Count;
    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    @SerializedName("custom_status5_count")
    @Expose
    private Long customStatus5Count;
    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    @SerializedName("custom_status6_count")
    @Expose
    private Long customStatus6Count;
    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    @SerializedName("custom_status7_count")
    @Expose
    private Long customStatus7Count;
    /**
     * The description of the test plan
     * 
     */
    @SerializedName("description")
    @Expose
    private String description;
    /**
     * An array of 'entries', i.e. group of test runs
     * 
     */
    @SerializedName("entries")
    @Expose
    private List<TRPlanEntry> entries = new ArrayList<TRPlanEntry>();
    /**
     * The amount of tests in the test plan marked as failed
     * 
     */
    @SerializedName("failed_count")
    @Expose
    private Long failedCount;
    /**
     * The unique ID of the test plan
     * 
     */
    @SerializedName("id")
    @Expose
    private Long id;
    /**
     * True if the test plan was closed and false otherwise
     * 
     */
    @SerializedName("is_completed")
    @Expose
    private Boolean isCompleted;
    /**
     * The ID of the milestone this test plan belongs to
     * 
     */
    @SerializedName("milestone_id")
    @Expose
    private Long milestoneId;
    /**
     * The name of the test plan
     * (Required)
     * 
     */
    @SerializedName("name")
    @Expose
    private String name;
    /**
     * The amount of tests in the test plan marked as passed
     * 
     */
    @SerializedName("passed_count")
    @Expose
    private Long passedCount;
    /**
     * The ID of the project this test plan belongs to
     * 
     */
    @SerializedName("project_id")
    @Expose
    private Long projectId;
    /**
     * The amount of tests in the test plan marked as retest
     * 
     */
    @SerializedName("retest_count")
    @Expose
    private Long retestCount;
    /**
     * The amount of tests in the test plan marked as untested
     * 
     */
    @SerializedName("untested_count")
    @Expose
    private Long untestedCount;
    /**
     * The address/URL of the test plan in the user interface
     * 
     */
    @SerializedName("url")
    @Expose
    private String url;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRPlan() {
    }

    /**
     * 
     * @param customStatus7Count
     * @param blockedCount
     * @param customStatus4Count
     * @param retestCount
     * @param milestoneId
     * @param description
     * @param createdOn
     * @param url
     * @param customStatus2Count
     * @param customStatus5Count
     * @param entries
     * @param failedCount
     * @param untestedCount
     * @param createdBy
     * @param assignedtoId
     * @param completedOn
     * @param name
     * @param customStatus1Count
     * @param customStatus3Count
     * @param passedCount
     * @param id
     * @param projectId
     * @param customStatus6Count
     * @param isCompleted
     */
    public TRPlan(Long assignedtoId, Long blockedCount, Long completedOn, Long createdBy, Long createdOn, Long customStatus1Count, Long customStatus2Count, Long customStatus3Count, Long customStatus4Count, Long customStatus5Count, Long customStatus6Count, Long customStatus7Count, String description, List<TRPlanEntry> entries, Long failedCount, Long id, Boolean isCompleted, Long milestoneId, String name, Long passedCount, Long projectId, Long retestCount, Long untestedCount, String url) {
        super();
        this.assignedtoId = assignedtoId;
        this.blockedCount = blockedCount;
        this.completedOn = completedOn;
        this.createdBy = createdBy;
        this.createdOn = createdOn;
        this.customStatus1Count = customStatus1Count;
        this.customStatus2Count = customStatus2Count;
        this.customStatus3Count = customStatus3Count;
        this.customStatus4Count = customStatus4Count;
        this.customStatus5Count = customStatus5Count;
        this.customStatus6Count = customStatus6Count;
        this.customStatus7Count = customStatus7Count;
        this.description = description;
        this.entries = entries;
        this.failedCount = failedCount;
        this.id = id;
        this.isCompleted = isCompleted;
        this.milestoneId = milestoneId;
        this.name = name;
        this.passedCount = passedCount;
        this.projectId = projectId;
        this.retestCount = retestCount;
        this.untestedCount = untestedCount;
        this.url = url;
    }

    /**
     * The ID of the user the entire test plan is assigned to
     * 
     */
    public Long getAssignedtoId() {
        return assignedtoId;
    }

    /**
     * The ID of the user the entire test plan is assigned to
     * 
     */
    public void setAssignedtoId(Long assignedtoId) {
        this.assignedtoId = assignedtoId;
    }

    public TRPlan withAssignedtoId(Long assignedtoId) {
        this.assignedtoId = assignedtoId;
        return this;
    }

    /**
     * The amount of tests in the test plan marked as blocked
     * 
     */
    public Long getBlockedCount() {
        return blockedCount;
    }

    /**
     * The amount of tests in the test plan marked as blocked
     * 
     */
    public void setBlockedCount(Long blockedCount) {
        this.blockedCount = blockedCount;
    }

    public TRPlan withBlockedCount(Long blockedCount) {
        this.blockedCount = blockedCount;
        return this;
    }

    /**
     * The date/time when the test plan was closed (as UNIX timestamp)
     * 
     */
    public Long getCompletedOn() {
        return completedOn;
    }

    /**
     * The date/time when the test plan was closed (as UNIX timestamp)
     * 
     */
    public void setCompletedOn(Long completedOn) {
        this.completedOn = completedOn;
    }

    public TRPlan withCompletedOn(Long completedOn) {
        this.completedOn = completedOn;
        return this;
    }

    /**
     * The ID of the user who created the test plan
     * 
     */
    public Long getCreatedBy() {
        return createdBy;
    }

    /**
     * The ID of the user who created the test plan
     * 
     */
    public void setCreatedBy(Long createdBy) {
        this.createdBy = createdBy;
    }

    public TRPlan withCreatedBy(Long createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * The date/time when the test plan was created (as UNIX timestamp)
     * 
     */
    public Long getCreatedOn() {
        return createdOn;
    }

    /**
     * The date/time when the test plan was created (as UNIX timestamp)
     * 
     */
    public void setCreatedOn(Long createdOn) {
        this.createdOn = createdOn;
    }

    public TRPlan withCreatedOn(Long createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    public Long getCustomStatus1Count() {
        return customStatus1Count;
    }

    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    public void setCustomStatus1Count(Long customStatus1Count) {
        this.customStatus1Count = customStatus1Count;
    }

    public TRPlan withCustomStatus1Count(Long customStatus1Count) {
        this.customStatus1Count = customStatus1Count;
        return this;
    }

    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    public Long getCustomStatus2Count() {
        return customStatus2Count;
    }

    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    public void setCustomStatus2Count(Long customStatus2Count) {
        this.customStatus2Count = customStatus2Count;
    }

    public TRPlan withCustomStatus2Count(Long customStatus2Count) {
        this.customStatus2Count = customStatus2Count;
        return this;
    }

    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    public Long getCustomStatus3Count() {
        return customStatus3Count;
    }

    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    public void setCustomStatus3Count(Long customStatus3Count) {
        this.customStatus3Count = customStatus3Count;
    }

    public TRPlan withCustomStatus3Count(Long customStatus3Count) {
        this.customStatus3Count = customStatus3Count;
        return this;
    }

    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    public Long getCustomStatus4Count() {
        return customStatus4Count;
    }

    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    public void setCustomStatus4Count(Long customStatus4Count) {
        this.customStatus4Count = customStatus4Count;
    }

    public TRPlan withCustomStatus4Count(Long customStatus4Count) {
        this.customStatus4Count = customStatus4Count;
        return this;
    }

    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    public Long getCustomStatus5Count() {
        return customStatus5Count;
    }

    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    public void setCustomStatus5Count(Long customStatus5Count) {
        this.customStatus5Count = customStatus5Count;
    }

    public TRPlan withCustomStatus5Count(Long customStatus5Count) {
        this.customStatus5Count = customStatus5Count;
        return this;
    }

    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    public Long getCustomStatus6Count() {
        return customStatus6Count;
    }

    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    public void setCustomStatus6Count(Long customStatus6Count) {
        this.customStatus6Count = customStatus6Count;
    }

    public TRPlan withCustomStatus6Count(Long customStatus6Count) {
        this.customStatus6Count = customStatus6Count;
        return this;
    }

    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    public Long getCustomStatus7Count() {
        return customStatus7Count;
    }

    /**
     * The amount of tests in the test plan with the respective custom status
     * 
     */
    public void setCustomStatus7Count(Long customStatus7Count) {
        this.customStatus7Count = customStatus7Count;
    }

    public TRPlan withCustomStatus7Count(Long customStatus7Count) {
        this.customStatus7Count = customStatus7Count;
        return this;
    }

    /**
     * The description of the test plan
     * 
     */
    public String getDescription() {
        return description;
    }

    /**
     * The description of the test plan
     * 
     */
    public void setDescription(String description) {
        this.description = description;
    }

    public TRPlan withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * An array of 'entries', i.e. group of test runs
     * 
     */
    public List<TRPlanEntry> getEntries() {
        return entries;
    }

    /**
     * An array of 'entries', i.e. group of test runs
     * 
     */
    public void setEntries(List<TRPlanEntry> entries) {
        this.entries = entries;
    }

    public TRPlan withEntries(List<TRPlanEntry> entries) {
        this.entries = entries;
        return this;
    }

    /**
     * The amount of tests in the test plan marked as failed
     * 
     */
    public Long getFailedCount() {
        return failedCount;
    }

    /**
     * The amount of tests in the test plan marked as failed
     * 
     */
    public void setFailedCount(Long failedCount) {
        this.failedCount = failedCount;
    }

    public TRPlan withFailedCount(Long failedCount) {
        this.failedCount = failedCount;
        return this;
    }

    /**
     * The unique ID of the test plan
     * 
     */
    public Long getId() {
        return id;
    }

    /**
     * The unique ID of the test plan
     * 
     */
    public void setId(Long id) {
        this.id = id;
    }

    public TRPlan withId(Long id) {
        this.id = id;
        return this;
    }

    /**
     * True if the test plan was closed and false otherwise
     * 
     */
    public Boolean getIsCompleted() {
        return isCompleted;
    }

    /**
     * True if the test plan was closed and false otherwise
     * 
     */
    public void setIsCompleted(Boolean isCompleted) {
        this.isCompleted = isCompleted;
    }

    public TRPlan withIsCompleted(Boolean isCompleted) {
        this.isCompleted = isCompleted;
        return this;
    }

    /**
     * The ID of the milestone this test plan belongs to
     * 
     */
    public Long getMilestoneId() {
        return milestoneId;
    }

    /**
     * The ID of the milestone this test plan belongs to
     * 
     */
    public void setMilestoneId(Long milestoneId) {
        this.milestoneId = milestoneId;
    }

    public TRPlan withMilestoneId(Long milestoneId) {
        this.milestoneId = milestoneId;
        return this;
    }

    /**
     * The name of the test plan
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * The name of the test plan
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    public TRPlan withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * The amount of tests in the test plan marked as passed
     * 
     */
    public Long getPassedCount() {
        return passedCount;
    }

    /**
     * The amount of tests in the test plan marked as passed
     * 
     */
    public void setPassedCount(Long passedCount) {
        this.passedCount = passedCount;
    }

    public TRPlan withPassedCount(Long passedCount) {
        this.passedCount = passedCount;
        return this;
    }

    /**
     * The ID of the project this test plan belongs to
     * 
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * The ID of the project this test plan belongs to
     * 
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public TRPlan withProjectId(Long projectId) {
        this.projectId = projectId;
        return this;
    }

    /**
     * The amount of tests in the test plan marked as retest
     * 
     */
    public Long getRetestCount() {
        return retestCount;
    }

    /**
     * The amount of tests in the test plan marked as retest
     * 
     */
    public void setRetestCount(Long retestCount) {
        this.retestCount = retestCount;
    }

    public TRPlan withRetestCount(Long retestCount) {
        this.retestCount = retestCount;
        return this;
    }

    /**
     * The amount of tests in the test plan marked as untested
     * 
     */
    public Long getUntestedCount() {
        return untestedCount;
    }

    /**
     * The amount of tests in the test plan marked as untested
     * 
     */
    public void setUntestedCount(Long untestedCount) {
        this.untestedCount = untestedCount;
    }

    public TRPlan withUntestedCount(Long untestedCount) {
        this.untestedCount = untestedCount;
        return this;
    }

    /**
     * The address/URL of the test plan in the user interface
     * 
     */
    public String getUrl() {
        return url;
    }

    /**
     * The address/URL of the test plan in the user interface
     * 
     */
    public void setUrl(String url) {
        this.url = url;
    }

    public TRPlan withUrl(String url) {
        this.url = url;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("assignedtoId", assignedtoId).append("blockedCount", blockedCount).append("completedOn", completedOn).append("createdBy", createdBy).append("createdOn", createdOn).append("customStatus1Count", customStatus1Count).append("customStatus2Count", customStatus2Count).append("customStatus3Count", customStatus3Count).append("customStatus4Count", customStatus4Count).append("customStatus5Count", customStatus5Count).append("customStatus6Count", customStatus6Count).append("customStatus7Count", customStatus7Count).append("description", description).append("entries", entries).append("failedCount", failedCount).append("id", id).append("isCompleted", isCompleted).append("milestoneId", milestoneId).append("name", name).append("passedCount", passedCount).append("projectId", projectId).append("retestCount", retestCount).append("untestedCount", untestedCount).append("url", url).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(customStatus7Count).append(blockedCount).append(customStatus4Count).append(milestoneId).append(description).append(createdOn).append(customStatus2Count).append(untestedCount).append(customStatus3Count).append(passedCount).append(id).append(customStatus6Count).append(isCompleted).append(retestCount).append(url).append(customStatus5Count).append(entries).append(failedCount).append(createdBy).append(assignedtoId).append(completedOn).append(name).append(customStatus1Count).append(projectId).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRPlan) == false) {
            return false;
        }
        TRPlan rhs = ((TRPlan) other);
        return new EqualsBuilder().append(customStatus7Count, rhs.customStatus7Count).append(blockedCount, rhs.blockedCount).append(customStatus4Count, rhs.customStatus4Count).append(milestoneId, rhs.milestoneId).append(description, rhs.description).append(createdOn, rhs.createdOn).append(customStatus2Count, rhs.customStatus2Count).append(untestedCount, rhs.untestedCount).append(customStatus3Count, rhs.customStatus3Count).append(passedCount, rhs.passedCount).append(id, rhs.id).append(customStatus6Count, rhs.customStatus6Count).append(isCompleted, rhs.isCompleted).append(retestCount, rhs.retestCount).append(url, rhs.url).append(customStatus5Count, rhs.customStatus5Count).append(entries, rhs.entries).append(failedCount, rhs.failedCount).append(createdBy, rhs.createdBy).append(assignedtoId, rhs.assignedtoId).append(completedOn, rhs.completedOn).append(name, rhs.name).append(customStatus1Count, rhs.customStatus1Count).append(projectId, rhs.projectId).isEquals();
    }

}
