
package org.touchbit.testrail4j.gson.model;

import java.util.ArrayList;
import java.util.List;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TRPlanEntry {

    /**
     * UUID
     * 
     */
    @SerializedName("id")
    @Expose
    private String id;
    /**
     * The ID of the test suite for the test run(s) (required)
     * (Required)
     * 
     */
    @SerializedName("suite_id")
    @Expose
    private java.lang.Long suiteId;
    /**
     * The name of the test run(s)
     * 
     */
    @SerializedName("name")
    @Expose
    private String name;
    /**
     * The description of the test run(s) (requires TestRail 5.2 or later)
     * 
     */
    @SerializedName("description")
    @Expose
    private String description;
    /**
     * The ID of the user the test run(s) should be assigned to
     * 
     */
    @SerializedName("assignedto_id")
    @Expose
    private java.lang.Long assignedtoId;
    /**
     * True for including all test cases of the test suite and false for a custom case selection (default: true)
     * 
     */
    @SerializedName("include_all")
    @Expose
    private Boolean includeAll;
    /**
     * An array of case IDs for the custom case selection
     * 
     */
    @SerializedName("case_ids")
    @Expose
    private List<Long> caseIds = new ArrayList<Long>();
    /**
     * An array of configuration IDs used for the test runs of the test plan entry (requires TestRail 3.1 or later)
     * 
     */
    @SerializedName("config_ids")
    @Expose
    private List<Long> configIds = new ArrayList<Long>();
    /**
     * An array of test runs with configurations, please see the example below for details (requires TestRail 3.1 or later)
     * 
     */
    @SerializedName("runs")
    @Expose
    private List<TRRun> runs = new ArrayList<TRRun>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRPlanEntry() {
    }

    /**
     * 
     * @param suiteId
     * @param assignedtoId
     * @param name
     * @param description
     * @param includeAll
     * @param caseIds
     * @param configIds
     * @param id
     * @param runs
     */
    public TRPlanEntry(String id, java.lang.Long suiteId, String name, String description, java.lang.Long assignedtoId, Boolean includeAll, List<Long> caseIds, List<Long> configIds, List<TRRun> runs) {
        super();
        this.id = id;
        this.suiteId = suiteId;
        this.name = name;
        this.description = description;
        this.assignedtoId = assignedtoId;
        this.includeAll = includeAll;
        this.caseIds = caseIds;
        this.configIds = configIds;
        this.runs = runs;
    }

    /**
     * UUID
     * 
     */
    public String getId() {
        return id;
    }

    /**
     * UUID
     * 
     */
    public void setId(String id) {
        this.id = id;
    }

    public TRPlanEntry withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * The ID of the test suite for the test run(s) (required)
     * (Required)
     * 
     */
    public java.lang.Long getSuiteId() {
        return suiteId;
    }

    /**
     * The ID of the test suite for the test run(s) (required)
     * (Required)
     * 
     */
    public void setSuiteId(java.lang.Long suiteId) {
        this.suiteId = suiteId;
    }

    public TRPlanEntry withSuiteId(java.lang.Long suiteId) {
        this.suiteId = suiteId;
        return this;
    }

    /**
     * The name of the test run(s)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * The name of the test run(s)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    public TRPlanEntry withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * The description of the test run(s) (requires TestRail 5.2 or later)
     * 
     */
    public String getDescription() {
        return description;
    }

    /**
     * The description of the test run(s) (requires TestRail 5.2 or later)
     * 
     */
    public void setDescription(String description) {
        this.description = description;
    }

    public TRPlanEntry withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * The ID of the user the test run(s) should be assigned to
     * 
     */
    public java.lang.Long getAssignedtoId() {
        return assignedtoId;
    }

    /**
     * The ID of the user the test run(s) should be assigned to
     * 
     */
    public void setAssignedtoId(java.lang.Long assignedtoId) {
        this.assignedtoId = assignedtoId;
    }

    public TRPlanEntry withAssignedtoId(java.lang.Long assignedtoId) {
        this.assignedtoId = assignedtoId;
        return this;
    }

    /**
     * True for including all test cases of the test suite and false for a custom case selection (default: true)
     * 
     */
    public Boolean getIncludeAll() {
        return includeAll;
    }

    /**
     * True for including all test cases of the test suite and false for a custom case selection (default: true)
     * 
     */
    public void setIncludeAll(Boolean includeAll) {
        this.includeAll = includeAll;
    }

    public TRPlanEntry withIncludeAll(Boolean includeAll) {
        this.includeAll = includeAll;
        return this;
    }

    /**
     * An array of case IDs for the custom case selection
     * 
     */
    public List<Long> getCaseIds() {
        return caseIds;
    }

    /**
     * An array of case IDs for the custom case selection
     * 
     */
    public void setCaseIds(List<Long> caseIds) {
        this.caseIds = caseIds;
    }

    public TRPlanEntry withCaseIds(List<Long> caseIds) {
        this.caseIds = caseIds;
        return this;
    }

    /**
     * An array of configuration IDs used for the test runs of the test plan entry (requires TestRail 3.1 or later)
     * 
     */
    public List<Long> getConfigIds() {
        return configIds;
    }

    /**
     * An array of configuration IDs used for the test runs of the test plan entry (requires TestRail 3.1 or later)
     * 
     */
    public void setConfigIds(List<Long> configIds) {
        this.configIds = configIds;
    }

    public TRPlanEntry withConfigIds(List<Long> configIds) {
        this.configIds = configIds;
        return this;
    }

    /**
     * An array of test runs with configurations, please see the example below for details (requires TestRail 3.1 or later)
     * 
     */
    public List<TRRun> getRuns() {
        return runs;
    }

    /**
     * An array of test runs with configurations, please see the example below for details (requires TestRail 3.1 or later)
     * 
     */
    public void setRuns(List<TRRun> runs) {
        this.runs = runs;
    }

    public TRPlanEntry withRuns(List<TRRun> runs) {
        this.runs = runs;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("id", id).append("suiteId", suiteId).append("name", name).append("description", description).append("assignedtoId", assignedtoId).append("includeAll", includeAll).append("caseIds", caseIds).append("configIds", configIds).append("runs", runs).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(suiteId).append(assignedtoId).append(name).append(description).append(includeAll).append(caseIds).append(configIds).append(id).append(runs).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRPlanEntry) == false) {
            return false;
        }
        TRPlanEntry rhs = ((TRPlanEntry) other);
        return new EqualsBuilder().append(suiteId, rhs.suiteId).append(assignedtoId, rhs.assignedtoId).append(name, rhs.name).append(description, rhs.description).append(includeAll, rhs.includeAll).append(caseIds, rhs.caseIds).append(configIds, rhs.configIds).append(id, rhs.id).append(runs, rhs.runs).isEquals();
    }

}
