
package org.touchbit.testrail4j.gson.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TRPriority {

    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("id")
    @Expose
    private Long id;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("is_default")
    @Expose
    private Boolean isDefault;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("name")
    @Expose
    private String name;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("priority")
    @Expose
    private Long priority;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("short_name")
    @Expose
    private String shortName;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRPriority() {
    }

    /**
     * 
     * @param isDefault
     * @param name
     * @param id
     * @param priority
     * @param shortName
     */
    public TRPriority(Long id, Boolean isDefault, String name, Long priority, String shortName) {
        super();
        this.id = id;
        this.isDefault = isDefault;
        this.name = name;
        this.priority = priority;
        this.shortName = shortName;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Long getId() {
        return id;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setId(Long id) {
        this.id = id;
    }

    public TRPriority withId(Long id) {
        this.id = id;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Boolean getIsDefault() {
        return isDefault;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public TRPriority withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    public TRPriority withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Long getPriority() {
        return priority;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setPriority(Long priority) {
        this.priority = priority;
    }

    public TRPriority withPriority(Long priority) {
        this.priority = priority;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getShortName() {
        return shortName;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public TRPriority withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("id", id).append("isDefault", isDefault).append("name", name).append("priority", priority).append("shortName", shortName).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(name).append(isDefault).append(id).append(priority).append(shortName).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRPriority) == false) {
            return false;
        }
        TRPriority rhs = ((TRPriority) other);
        return new EqualsBuilder().append(name, rhs.name).append(isDefault, rhs.isDefault).append(id, rhs.id).append(priority, rhs.priority).append(shortName, rhs.shortName).isEquals();
    }

}
