
package org.touchbit.testrail4j.gson.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TRProject {

    /**
     * The description/announcement of the project
     * 
     */
    @SerializedName("announcement")
    @Expose
    private String announcement;
    /**
     * The date/time when the project was marked as completed (as UNIX timestamp)
     * 
     */
    @SerializedName("completed_on")
    @Expose
    private Long completedOn;
    /**
     * The unique ID of the project
     * 
     */
    @SerializedName("id")
    @Expose
    private Long id;
    /**
     * True if the project is marked as completed and false otherwise
     * 
     */
    @SerializedName("is_completed")
    @Expose
    private Boolean isCompleted;
    /**
     * The name of the project
     * 
     */
    @SerializedName("name")
    @Expose
    private String name;
    /**
     * True to show the announcement/description and false otherwise
     * 
     */
    @SerializedName("show_announcement")
    @Expose
    private Boolean showAnnouncement;
    /**
     * The address/URL of the project in the user interface
     * 
     */
    @SerializedName("url")
    @Expose
    private String url;
    /**
     * The suite mode of the project (1 for single suite mode, 2 for single suite + baselines, 3 for multiple suites) (added with TestRail 4.0)
     * 
     */
    @SerializedName("suite_mode")
    @Expose
    private Long suiteMode;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRProject() {
    }

    /**
     * 
     * @param suiteMode
     * @param completedOn
     * @param name
     * @param id
     * @param showAnnouncement
     * @param url
     * @param announcement
     * @param isCompleted
     */
    public TRProject(String announcement, Long completedOn, Long id, Boolean isCompleted, String name, Boolean showAnnouncement, String url, Long suiteMode) {
        super();
        this.announcement = announcement;
        this.completedOn = completedOn;
        this.id = id;
        this.isCompleted = isCompleted;
        this.name = name;
        this.showAnnouncement = showAnnouncement;
        this.url = url;
        this.suiteMode = suiteMode;
    }

    /**
     * The description/announcement of the project
     * 
     */
    public String getAnnouncement() {
        return announcement;
    }

    /**
     * The description/announcement of the project
     * 
     */
    public void setAnnouncement(String announcement) {
        this.announcement = announcement;
    }

    public TRProject withAnnouncement(String announcement) {
        this.announcement = announcement;
        return this;
    }

    /**
     * The date/time when the project was marked as completed (as UNIX timestamp)
     * 
     */
    public Long getCompletedOn() {
        return completedOn;
    }

    /**
     * The date/time when the project was marked as completed (as UNIX timestamp)
     * 
     */
    public void setCompletedOn(Long completedOn) {
        this.completedOn = completedOn;
    }

    public TRProject withCompletedOn(Long completedOn) {
        this.completedOn = completedOn;
        return this;
    }

    /**
     * The unique ID of the project
     * 
     */
    public Long getId() {
        return id;
    }

    /**
     * The unique ID of the project
     * 
     */
    public void setId(Long id) {
        this.id = id;
    }

    public TRProject withId(Long id) {
        this.id = id;
        return this;
    }

    /**
     * True if the project is marked as completed and false otherwise
     * 
     */
    public Boolean getIsCompleted() {
        return isCompleted;
    }

    /**
     * True if the project is marked as completed and false otherwise
     * 
     */
    public void setIsCompleted(Boolean isCompleted) {
        this.isCompleted = isCompleted;
    }

    public TRProject withIsCompleted(Boolean isCompleted) {
        this.isCompleted = isCompleted;
        return this;
    }

    /**
     * The name of the project
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * The name of the project
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    public TRProject withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * True to show the announcement/description and false otherwise
     * 
     */
    public Boolean getShowAnnouncement() {
        return showAnnouncement;
    }

    /**
     * True to show the announcement/description and false otherwise
     * 
     */
    public void setShowAnnouncement(Boolean showAnnouncement) {
        this.showAnnouncement = showAnnouncement;
    }

    public TRProject withShowAnnouncement(Boolean showAnnouncement) {
        this.showAnnouncement = showAnnouncement;
        return this;
    }

    /**
     * The address/URL of the project in the user interface
     * 
     */
    public String getUrl() {
        return url;
    }

    /**
     * The address/URL of the project in the user interface
     * 
     */
    public void setUrl(String url) {
        this.url = url;
    }

    public TRProject withUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * The suite mode of the project (1 for single suite mode, 2 for single suite + baselines, 3 for multiple suites) (added with TestRail 4.0)
     * 
     */
    public Long getSuiteMode() {
        return suiteMode;
    }

    /**
     * The suite mode of the project (1 for single suite mode, 2 for single suite + baselines, 3 for multiple suites) (added with TestRail 4.0)
     * 
     */
    public void setSuiteMode(Long suiteMode) {
        this.suiteMode = suiteMode;
    }

    public TRProject withSuiteMode(Long suiteMode) {
        this.suiteMode = suiteMode;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("announcement", announcement).append("completedOn", completedOn).append("id", id).append("isCompleted", isCompleted).append("name", name).append("showAnnouncement", showAnnouncement).append("url", url).append("suiteMode", suiteMode).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(suiteMode).append(completedOn).append(name).append(id).append(showAnnouncement).append(url).append(announcement).append(isCompleted).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRProject) == false) {
            return false;
        }
        TRProject rhs = ((TRProject) other);
        return new EqualsBuilder().append(suiteMode, rhs.suiteMode).append(completedOn, rhs.completedOn).append(name, rhs.name).append(id, rhs.id).append(showAnnouncement, rhs.showAnnouncement).append(url, rhs.url).append(announcement, rhs.announcement).append(isCompleted, rhs.isCompleted).isEquals();
    }

}
