
package org.touchbit.testrail4j.gson.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TRProjectConfig {

    @SerializedName("group_id")
    @Expose
    private Long groupId;
    @SerializedName("id")
    @Expose
    private Long id;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("name")
    @Expose
    private String name;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRProjectConfig() {
    }

    /**
     * 
     * @param groupId
     * @param name
     * @param id
     */
    public TRProjectConfig(Long groupId, Long id, String name) {
        super();
        this.groupId = groupId;
        this.id = id;
        this.name = name;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public TRProjectConfig withGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public TRProjectConfig withId(Long id) {
        this.id = id;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    public TRProjectConfig withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("groupId", groupId).append("id", id).append("name", name).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(name).append(id).append(groupId).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRProjectConfig) == false) {
            return false;
        }
        TRProjectConfig rhs = ((TRProjectConfig) other);
        return new EqualsBuilder().append(name, rhs.name).append(id, rhs.id).append(groupId, rhs.groupId).isEquals();
    }

}
