
package org.touchbit.testrail4j.gson.model;

import java.util.ArrayList;
import java.util.List;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TRProjectConfigGroup {

    @SerializedName("configs")
    @Expose
    private List<TRProjectConfig> configs = new ArrayList<TRProjectConfig>();
    @SerializedName("id")
    @Expose
    private Long id;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("name")
    @Expose
    private String name;
    @SerializedName("project_id")
    @Expose
    private Long projectId;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRProjectConfigGroup() {
    }

    /**
     * 
     * @param configs
     * @param name
     * @param id
     * @param projectId
     */
    public TRProjectConfigGroup(List<TRProjectConfig> configs, Long id, String name, Long projectId) {
        super();
        this.configs = configs;
        this.id = id;
        this.name = name;
        this.projectId = projectId;
    }

    public List<TRProjectConfig> getConfigs() {
        return configs;
    }

    public void setConfigs(List<TRProjectConfig> configs) {
        this.configs = configs;
    }

    public TRProjectConfigGroup withConfigs(List<TRProjectConfig> configs) {
        this.configs = configs;
        return this;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public TRProjectConfigGroup withId(Long id) {
        this.id = id;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    public TRProjectConfigGroup withName(String name) {
        this.name = name;
        return this;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public TRProjectConfigGroup withProjectId(Long projectId) {
        this.projectId = projectId;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("configs", configs).append("id", id).append("name", name).append("projectId", projectId).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(name).append(configs).append(id).append(projectId).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRProjectConfigGroup) == false) {
            return false;
        }
        TRProjectConfigGroup rhs = ((TRProjectConfigGroup) other);
        return new EqualsBuilder().append(name, rhs.name).append(configs, rhs.configs).append(id, rhs.id).append(projectId, rhs.projectId).isEquals();
    }

}
