
package org.touchbit.testrail4j.gson.model;

import java.util.ArrayList;
import java.util.List;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TRResult {

    /**
     * The unique ID of the test result
     * 
     */
    @SerializedName("id")
    @Expose
    private Long id;
    /**
     * The ID of the test case (Util field. Not returned in response.)
     * 
     */
    @SerializedName("case_id")
    @Expose
    private Long caseId;
    /**
     * The status of the test result, e.g. passed or failed
     * 
     */
    @SerializedName("status_id")
    @Expose
    private Long statusId;
    /**
     * The ID of the test this test result belongs to
     * 
     */
    @SerializedName("test_id")
    @Expose
    private Long testId;
    /**
     * The comment or error message of the test result
     * 
     */
    @SerializedName("comment")
    @Expose
    private String comment;
    /**
     * A comma-separated list of defects linked to the test result
     * 
     */
    @SerializedName("defects")
    @Expose
    private String defects;
    /**
     * The (build) version the test was executed against
     * 
     */
    @SerializedName("version")
    @Expose
    private String version;
    /**
     * The amount of time it took to execute the test (e.g. '1m' or '2m 30s')
     * 
     */
    @SerializedName("elapsed")
    @Expose
    private String elapsed;
    /**
     * The ID of the user who created the test result
     * 
     */
    @SerializedName("created_by")
    @Expose
    private Long createdBy;
    /**
     * The date/time when the test result was created (as UNIX timestamp)
     * 
     */
    @SerializedName("created_on")
    @Expose
    private Long createdOn;
    /**
     * The ID of the assignee (user) of the test result
     * 
     */
    @SerializedName("assignedto_id")
    @Expose
    private Long assignedtoId;
    /**
     * Test Case (Steps) template results
     * 
     */
    @SerializedName("custom_step_results")
    @Expose
    private List<TRStep> customStepResults = new ArrayList<TRStep>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRResult() {
    }

    /**
     * 
     * @param elapsed
     * @param statusId
     * @param createdBy
     * @param assignedtoId
     * @param caseId
     * @param defects
     * @param testId
     * @param comment
     * @param customStepResults
     * @param id
     * @param version
     * @param createdOn
     */
    public TRResult(Long id, Long caseId, Long statusId, Long testId, String comment, String defects, String version, String elapsed, Long createdBy, Long createdOn, Long assignedtoId, List<TRStep> customStepResults) {
        super();
        this.id = id;
        this.caseId = caseId;
        this.statusId = statusId;
        this.testId = testId;
        this.comment = comment;
        this.defects = defects;
        this.version = version;
        this.elapsed = elapsed;
        this.createdBy = createdBy;
        this.createdOn = createdOn;
        this.assignedtoId = assignedtoId;
        this.customStepResults = customStepResults;
    }

    /**
     * The unique ID of the test result
     * 
     */
    public Long getId() {
        return id;
    }

    /**
     * The unique ID of the test result
     * 
     */
    public void setId(Long id) {
        this.id = id;
    }

    public TRResult withId(Long id) {
        this.id = id;
        return this;
    }

    /**
     * The ID of the test case (Util field. Not returned in response.)
     * 
     */
    public Long getCaseId() {
        return caseId;
    }

    /**
     * The ID of the test case (Util field. Not returned in response.)
     * 
     */
    public void setCaseId(Long caseId) {
        this.caseId = caseId;
    }

    public TRResult withCaseId(Long caseId) {
        this.caseId = caseId;
        return this;
    }

    /**
     * The status of the test result, e.g. passed or failed
     * 
     */
    public Long getStatusId() {
        return statusId;
    }

    /**
     * The status of the test result, e.g. passed or failed
     * 
     */
    public void setStatusId(Long statusId) {
        this.statusId = statusId;
    }

    public TRResult withStatusId(Long statusId) {
        this.statusId = statusId;
        return this;
    }

    /**
     * The ID of the test this test result belongs to
     * 
     */
    public Long getTestId() {
        return testId;
    }

    /**
     * The ID of the test this test result belongs to
     * 
     */
    public void setTestId(Long testId) {
        this.testId = testId;
    }

    public TRResult withTestId(Long testId) {
        this.testId = testId;
        return this;
    }

    /**
     * The comment or error message of the test result
     * 
     */
    public String getComment() {
        return comment;
    }

    /**
     * The comment or error message of the test result
     * 
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    public TRResult withComment(String comment) {
        this.comment = comment;
        return this;
    }

    /**
     * A comma-separated list of defects linked to the test result
     * 
     */
    public String getDefects() {
        return defects;
    }

    /**
     * A comma-separated list of defects linked to the test result
     * 
     */
    public void setDefects(String defects) {
        this.defects = defects;
    }

    public TRResult withDefects(String defects) {
        this.defects = defects;
        return this;
    }

    /**
     * The (build) version the test was executed against
     * 
     */
    public String getVersion() {
        return version;
    }

    /**
     * The (build) version the test was executed against
     * 
     */
    public void setVersion(String version) {
        this.version = version;
    }

    public TRResult withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * The amount of time it took to execute the test (e.g. '1m' or '2m 30s')
     * 
     */
    public String getElapsed() {
        return elapsed;
    }

    /**
     * The amount of time it took to execute the test (e.g. '1m' or '2m 30s')
     * 
     */
    public void setElapsed(String elapsed) {
        this.elapsed = elapsed;
    }

    public TRResult withElapsed(String elapsed) {
        this.elapsed = elapsed;
        return this;
    }

    /**
     * The ID of the user who created the test result
     * 
     */
    public Long getCreatedBy() {
        return createdBy;
    }

    /**
     * The ID of the user who created the test result
     * 
     */
    public void setCreatedBy(Long createdBy) {
        this.createdBy = createdBy;
    }

    public TRResult withCreatedBy(Long createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * The date/time when the test result was created (as UNIX timestamp)
     * 
     */
    public Long getCreatedOn() {
        return createdOn;
    }

    /**
     * The date/time when the test result was created (as UNIX timestamp)
     * 
     */
    public void setCreatedOn(Long createdOn) {
        this.createdOn = createdOn;
    }

    public TRResult withCreatedOn(Long createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    /**
     * The ID of the assignee (user) of the test result
     * 
     */
    public Long getAssignedtoId() {
        return assignedtoId;
    }

    /**
     * The ID of the assignee (user) of the test result
     * 
     */
    public void setAssignedtoId(Long assignedtoId) {
        this.assignedtoId = assignedtoId;
    }

    public TRResult withAssignedtoId(Long assignedtoId) {
        this.assignedtoId = assignedtoId;
        return this;
    }

    /**
     * Test Case (Steps) template results
     * 
     */
    public List<TRStep> getCustomStepResults() {
        return customStepResults;
    }

    /**
     * Test Case (Steps) template results
     * 
     */
    public void setCustomStepResults(List<TRStep> customStepResults) {
        this.customStepResults = customStepResults;
    }

    public TRResult withCustomStepResults(List<TRStep> customStepResults) {
        this.customStepResults = customStepResults;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("id", id).append("caseId", caseId).append("statusId", statusId).append("testId", testId).append("comment", comment).append("defects", defects).append("version", version).append("elapsed", elapsed).append("createdBy", createdBy).append("createdOn", createdOn).append("assignedtoId", assignedtoId).append("customStepResults", customStepResults).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(customStepResults).append(version).append(createdOn).append(elapsed).append(statusId).append(createdBy).append(assignedtoId).append(caseId).append(defects).append(testId).append(comment).append(id).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRResult) == false) {
            return false;
        }
        TRResult rhs = ((TRResult) other);
        return new EqualsBuilder().append(customStepResults, rhs.customStepResults).append(version, rhs.version).append(createdOn, rhs.createdOn).append(elapsed, rhs.elapsed).append(statusId, rhs.statusId).append(createdBy, rhs.createdBy).append(assignedtoId, rhs.assignedtoId).append(caseId, rhs.caseId).append(defects, rhs.defects).append(testId, rhs.testId).append(comment, rhs.comment).append(id, rhs.id).isEquals();
    }

}
