
package org.touchbit.testrail4j.gson.model;

import java.util.ArrayList;
import java.util.List;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TRResults {

    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("results")
    @Expose
    private List<TRResult> results = new ArrayList<TRResult>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRResults() {
    }

    /**
     * 
     * @param results
     */
    public TRResults(List<TRResult> results) {
        super();
        this.results = results;
    }

    /**
     * 
     * (Required)
     * 
     */
    public List<TRResult> getResults() {
        return results;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setResults(List<TRResult> results) {
        this.results = results;
    }

    public TRResults withResults(List<TRResult> results) {
        this.results = results;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("results", results).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(results).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRResults) == false) {
            return false;
        }
        TRResults rhs = ((TRResults) other);
        return new EqualsBuilder().append(results, rhs.results).isEquals();
    }

}
