
package org.touchbit.testrail4j.gson.model;

import java.util.ArrayList;
import java.util.List;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TRRun {

    /**
     * The ID of the user the entire test run is assigned to
     * 
     */
    @SerializedName("assignedto_id")
    @Expose
    private java.lang.Long assignedtoId;
    /**
     * The amount of tests in the test run marked as blocked
     * 
     */
    @SerializedName("blocked_count")
    @Expose
    private java.lang.Long blockedCount;
    /**
     * The date/time when the test run was closed (as UNIX timestamp)
     * 
     */
    @SerializedName("completed_on")
    @Expose
    private java.lang.Long completedOn;
    /**
     * The configuration of the test run as string (if part of a test plan)
     * 
     */
    @SerializedName("config")
    @Expose
    private String config;
    /**
     * Test plan entry UUID
     * 
     */
    @SerializedName("entry_id")
    @Expose
    private String entryId;
    /**
     * Test plan entry index
     * 
     */
    @SerializedName("entry_index")
    @Expose
    private java.lang.Long entryIndex;
    /**
     * The array of IDs of the configurations of the test run (if part of a test plan)
     * 
     */
    @SerializedName("config_ids")
    @Expose
    private List<Long> configIds = new ArrayList<Long>();
    /**
     * An array of case IDs for the custom case selection
     * 
     */
    @SerializedName("case_ids")
    @Expose
    private List<Long> caseIds = new ArrayList<Long>();
    /**
     * The ID of the user who created the test run
     * 
     */
    @SerializedName("created_by")
    @Expose
    private java.lang.Long createdBy;
    /**
     * The date/time when the test run was created (as UNIX timestamp)
     * 
     */
    @SerializedName("created_on")
    @Expose
    private java.lang.Long createdOn;
    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    @SerializedName("custom_status1_count")
    @Expose
    private java.lang.Long customStatus1Count;
    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    @SerializedName("custom_status2_count")
    @Expose
    private java.lang.Long customStatus2Count;
    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    @SerializedName("custom_status3_count")
    @Expose
    private java.lang.Long customStatus3Count;
    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    @SerializedName("custom_status4_count")
    @Expose
    private java.lang.Long customStatus4Count;
    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    @SerializedName("custom_status5_count")
    @Expose
    private java.lang.Long customStatus5Count;
    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    @SerializedName("custom_status6_count")
    @Expose
    private java.lang.Long customStatus6Count;
    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    @SerializedName("custom_status7_count")
    @Expose
    private java.lang.Long customStatus7Count;
    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    @SerializedName("custom_status8_count")
    @Expose
    private java.lang.Long customStatus8Count;
    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    @SerializedName("custom_status9_count")
    @Expose
    private java.lang.Long customStatus9Count;
    /**
     * The description of the test run
     * 
     */
    @SerializedName("description")
    @Expose
    private String description;
    /**
     * The amount of tests in the test run marked as failed
     * 
     */
    @SerializedName("failed_count")
    @Expose
    private java.lang.Long failedCount;
    /**
     * The unique ID of the test run
     * 
     */
    @SerializedName("id")
    @Expose
    private java.lang.Long id;
    /**
     * True if the test run includes all test cases and false otherwise
     * 
     */
    @SerializedName("include_all")
    @Expose
    private Boolean includeAll;
    /**
     * True if the test run was closed and false otherwise
     * 
     */
    @SerializedName("is_completed")
    @Expose
    private Boolean isCompleted;
    /**
     * The ID of the milestone this test run belongs to
     * 
     */
    @SerializedName("milestone_id")
    @Expose
    private java.lang.Long milestoneId;
    /**
     * The name of the test run
     * 
     */
    @SerializedName("name")
    @Expose
    private String name;
    /**
     * The amount of tests in the test run marked as passed
     * 
     */
    @SerializedName("passed_count")
    @Expose
    private java.lang.Long passedCount;
    /**
     * The ID of the test plan this test run belongs to
     * 
     */
    @SerializedName("plan_id")
    @Expose
    private java.lang.Long planId;
    /**
     * The ID of the project this test run belongs to
     * 
     */
    @SerializedName("project_id")
    @Expose
    private java.lang.Long projectId;
    /**
     * The amount of tests in the test run marked as retest
     * 
     */
    @SerializedName("retest_count")
    @Expose
    private java.lang.Long retestCount;
    /**
     * The ID of the test suite this test run is derived from
     * 
     */
    @SerializedName("suite_id")
    @Expose
    private java.lang.Long suiteId;
    /**
     * The amount of tests in the test run marked as untested
     * 
     */
    @SerializedName("untested_count")
    @Expose
    private java.lang.Long untestedCount;
    /**
     * The address/URL of the test run in the user interface
     * 
     */
    @SerializedName("url")
    @Expose
    private String url;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRRun() {
    }

    /**
     * 
     * @param customStatus7Count
     * @param blockedCount
     * @param customStatus4Count
     * @param milestoneId
     * @param description
     * @param includeAll
     * @param createdOn
     * @param entryId
     * @param customStatus2Count
     * @param untestedCount
     * @param configIds
     * @param customStatus3Count
     * @param passedCount
     * @param planId
     * @param customStatus9Count
     * @param id
     * @param customStatus6Count
     * @param isCompleted
     * @param entryIndex
     * @param suiteId
     * @param retestCount
     * @param url
     * @param customStatus5Count
     * @param failedCount
     * @param createdBy
     * @param assignedtoId
     * @param completedOn
     * @param customStatus8Count
     * @param name
     * @param caseIds
     * @param customStatus1Count
     * @param config
     * @param projectId
     */
    public TRRun(java.lang.Long assignedtoId, java.lang.Long blockedCount, java.lang.Long completedOn, String config, String entryId, java.lang.Long entryIndex, List<Long> configIds, List<Long> caseIds, java.lang.Long createdBy, java.lang.Long createdOn, java.lang.Long customStatus1Count, java.lang.Long customStatus2Count, java.lang.Long customStatus3Count, java.lang.Long customStatus4Count, java.lang.Long customStatus5Count, java.lang.Long customStatus6Count, java.lang.Long customStatus7Count, java.lang.Long customStatus8Count, java.lang.Long customStatus9Count, String description, java.lang.Long failedCount, java.lang.Long id, Boolean includeAll, Boolean isCompleted, java.lang.Long milestoneId, String name, java.lang.Long passedCount, java.lang.Long planId, java.lang.Long projectId, java.lang.Long retestCount, java.lang.Long suiteId, java.lang.Long untestedCount, String url) {
        super();
        this.assignedtoId = assignedtoId;
        this.blockedCount = blockedCount;
        this.completedOn = completedOn;
        this.config = config;
        this.entryId = entryId;
        this.entryIndex = entryIndex;
        this.configIds = configIds;
        this.caseIds = caseIds;
        this.createdBy = createdBy;
        this.createdOn = createdOn;
        this.customStatus1Count = customStatus1Count;
        this.customStatus2Count = customStatus2Count;
        this.customStatus3Count = customStatus3Count;
        this.customStatus4Count = customStatus4Count;
        this.customStatus5Count = customStatus5Count;
        this.customStatus6Count = customStatus6Count;
        this.customStatus7Count = customStatus7Count;
        this.customStatus8Count = customStatus8Count;
        this.customStatus9Count = customStatus9Count;
        this.description = description;
        this.failedCount = failedCount;
        this.id = id;
        this.includeAll = includeAll;
        this.isCompleted = isCompleted;
        this.milestoneId = milestoneId;
        this.name = name;
        this.passedCount = passedCount;
        this.planId = planId;
        this.projectId = projectId;
        this.retestCount = retestCount;
        this.suiteId = suiteId;
        this.untestedCount = untestedCount;
        this.url = url;
    }

    /**
     * The ID of the user the entire test run is assigned to
     * 
     */
    public java.lang.Long getAssignedtoId() {
        return assignedtoId;
    }

    /**
     * The ID of the user the entire test run is assigned to
     * 
     */
    public void setAssignedtoId(java.lang.Long assignedtoId) {
        this.assignedtoId = assignedtoId;
    }

    public TRRun withAssignedtoId(java.lang.Long assignedtoId) {
        this.assignedtoId = assignedtoId;
        return this;
    }

    /**
     * The amount of tests in the test run marked as blocked
     * 
     */
    public java.lang.Long getBlockedCount() {
        return blockedCount;
    }

    /**
     * The amount of tests in the test run marked as blocked
     * 
     */
    public void setBlockedCount(java.lang.Long blockedCount) {
        this.blockedCount = blockedCount;
    }

    public TRRun withBlockedCount(java.lang.Long blockedCount) {
        this.blockedCount = blockedCount;
        return this;
    }

    /**
     * The date/time when the test run was closed (as UNIX timestamp)
     * 
     */
    public java.lang.Long getCompletedOn() {
        return completedOn;
    }

    /**
     * The date/time when the test run was closed (as UNIX timestamp)
     * 
     */
    public void setCompletedOn(java.lang.Long completedOn) {
        this.completedOn = completedOn;
    }

    public TRRun withCompletedOn(java.lang.Long completedOn) {
        this.completedOn = completedOn;
        return this;
    }

    /**
     * The configuration of the test run as string (if part of a test plan)
     * 
     */
    public String getConfig() {
        return config;
    }

    /**
     * The configuration of the test run as string (if part of a test plan)
     * 
     */
    public void setConfig(String config) {
        this.config = config;
    }

    public TRRun withConfig(String config) {
        this.config = config;
        return this;
    }

    /**
     * Test plan entry UUID
     * 
     */
    public String getEntryId() {
        return entryId;
    }

    /**
     * Test plan entry UUID
     * 
     */
    public void setEntryId(String entryId) {
        this.entryId = entryId;
    }

    public TRRun withEntryId(String entryId) {
        this.entryId = entryId;
        return this;
    }

    /**
     * Test plan entry index
     * 
     */
    public java.lang.Long getEntryIndex() {
        return entryIndex;
    }

    /**
     * Test plan entry index
     * 
     */
    public void setEntryIndex(java.lang.Long entryIndex) {
        this.entryIndex = entryIndex;
    }

    public TRRun withEntryIndex(java.lang.Long entryIndex) {
        this.entryIndex = entryIndex;
        return this;
    }

    /**
     * The array of IDs of the configurations of the test run (if part of a test plan)
     * 
     */
    public List<Long> getConfigIds() {
        return configIds;
    }

    /**
     * The array of IDs of the configurations of the test run (if part of a test plan)
     * 
     */
    public void setConfigIds(List<Long> configIds) {
        this.configIds = configIds;
    }

    public TRRun withConfigIds(List<Long> configIds) {
        this.configIds = configIds;
        return this;
    }

    /**
     * An array of case IDs for the custom case selection
     * 
     */
    public List<Long> getCaseIds() {
        return caseIds;
    }

    /**
     * An array of case IDs for the custom case selection
     * 
     */
    public void setCaseIds(List<Long> caseIds) {
        this.caseIds = caseIds;
    }

    public TRRun withCaseIds(List<Long> caseIds) {
        this.caseIds = caseIds;
        return this;
    }

    /**
     * The ID of the user who created the test run
     * 
     */
    public java.lang.Long getCreatedBy() {
        return createdBy;
    }

    /**
     * The ID of the user who created the test run
     * 
     */
    public void setCreatedBy(java.lang.Long createdBy) {
        this.createdBy = createdBy;
    }

    public TRRun withCreatedBy(java.lang.Long createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * The date/time when the test run was created (as UNIX timestamp)
     * 
     */
    public java.lang.Long getCreatedOn() {
        return createdOn;
    }

    /**
     * The date/time when the test run was created (as UNIX timestamp)
     * 
     */
    public void setCreatedOn(java.lang.Long createdOn) {
        this.createdOn = createdOn;
    }

    public TRRun withCreatedOn(java.lang.Long createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    public java.lang.Long getCustomStatus1Count() {
        return customStatus1Count;
    }

    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    public void setCustomStatus1Count(java.lang.Long customStatus1Count) {
        this.customStatus1Count = customStatus1Count;
    }

    public TRRun withCustomStatus1Count(java.lang.Long customStatus1Count) {
        this.customStatus1Count = customStatus1Count;
        return this;
    }

    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    public java.lang.Long getCustomStatus2Count() {
        return customStatus2Count;
    }

    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    public void setCustomStatus2Count(java.lang.Long customStatus2Count) {
        this.customStatus2Count = customStatus2Count;
    }

    public TRRun withCustomStatus2Count(java.lang.Long customStatus2Count) {
        this.customStatus2Count = customStatus2Count;
        return this;
    }

    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    public java.lang.Long getCustomStatus3Count() {
        return customStatus3Count;
    }

    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    public void setCustomStatus3Count(java.lang.Long customStatus3Count) {
        this.customStatus3Count = customStatus3Count;
    }

    public TRRun withCustomStatus3Count(java.lang.Long customStatus3Count) {
        this.customStatus3Count = customStatus3Count;
        return this;
    }

    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    public java.lang.Long getCustomStatus4Count() {
        return customStatus4Count;
    }

    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    public void setCustomStatus4Count(java.lang.Long customStatus4Count) {
        this.customStatus4Count = customStatus4Count;
    }

    public TRRun withCustomStatus4Count(java.lang.Long customStatus4Count) {
        this.customStatus4Count = customStatus4Count;
        return this;
    }

    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    public java.lang.Long getCustomStatus5Count() {
        return customStatus5Count;
    }

    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    public void setCustomStatus5Count(java.lang.Long customStatus5Count) {
        this.customStatus5Count = customStatus5Count;
    }

    public TRRun withCustomStatus5Count(java.lang.Long customStatus5Count) {
        this.customStatus5Count = customStatus5Count;
        return this;
    }

    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    public java.lang.Long getCustomStatus6Count() {
        return customStatus6Count;
    }

    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    public void setCustomStatus6Count(java.lang.Long customStatus6Count) {
        this.customStatus6Count = customStatus6Count;
    }

    public TRRun withCustomStatus6Count(java.lang.Long customStatus6Count) {
        this.customStatus6Count = customStatus6Count;
        return this;
    }

    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    public java.lang.Long getCustomStatus7Count() {
        return customStatus7Count;
    }

    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    public void setCustomStatus7Count(java.lang.Long customStatus7Count) {
        this.customStatus7Count = customStatus7Count;
    }

    public TRRun withCustomStatus7Count(java.lang.Long customStatus7Count) {
        this.customStatus7Count = customStatus7Count;
        return this;
    }

    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    public java.lang.Long getCustomStatus8Count() {
        return customStatus8Count;
    }

    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    public void setCustomStatus8Count(java.lang.Long customStatus8Count) {
        this.customStatus8Count = customStatus8Count;
    }

    public TRRun withCustomStatus8Count(java.lang.Long customStatus8Count) {
        this.customStatus8Count = customStatus8Count;
        return this;
    }

    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    public java.lang.Long getCustomStatus9Count() {
        return customStatus9Count;
    }

    /**
     * The amount of tests in the test run with the respective custom status
     * 
     */
    public void setCustomStatus9Count(java.lang.Long customStatus9Count) {
        this.customStatus9Count = customStatus9Count;
    }

    public TRRun withCustomStatus9Count(java.lang.Long customStatus9Count) {
        this.customStatus9Count = customStatus9Count;
        return this;
    }

    /**
     * The description of the test run
     * 
     */
    public String getDescription() {
        return description;
    }

    /**
     * The description of the test run
     * 
     */
    public void setDescription(String description) {
        this.description = description;
    }

    public TRRun withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * The amount of tests in the test run marked as failed
     * 
     */
    public java.lang.Long getFailedCount() {
        return failedCount;
    }

    /**
     * The amount of tests in the test run marked as failed
     * 
     */
    public void setFailedCount(java.lang.Long failedCount) {
        this.failedCount = failedCount;
    }

    public TRRun withFailedCount(java.lang.Long failedCount) {
        this.failedCount = failedCount;
        return this;
    }

    /**
     * The unique ID of the test run
     * 
     */
    public java.lang.Long getId() {
        return id;
    }

    /**
     * The unique ID of the test run
     * 
     */
    public void setId(java.lang.Long id) {
        this.id = id;
    }

    public TRRun withId(java.lang.Long id) {
        this.id = id;
        return this;
    }

    /**
     * True if the test run includes all test cases and false otherwise
     * 
     */
    public Boolean getIncludeAll() {
        return includeAll;
    }

    /**
     * True if the test run includes all test cases and false otherwise
     * 
     */
    public void setIncludeAll(Boolean includeAll) {
        this.includeAll = includeAll;
    }

    public TRRun withIncludeAll(Boolean includeAll) {
        this.includeAll = includeAll;
        return this;
    }

    /**
     * True if the test run was closed and false otherwise
     * 
     */
    public Boolean getIsCompleted() {
        return isCompleted;
    }

    /**
     * True if the test run was closed and false otherwise
     * 
     */
    public void setIsCompleted(Boolean isCompleted) {
        this.isCompleted = isCompleted;
    }

    public TRRun withIsCompleted(Boolean isCompleted) {
        this.isCompleted = isCompleted;
        return this;
    }

    /**
     * The ID of the milestone this test run belongs to
     * 
     */
    public java.lang.Long getMilestoneId() {
        return milestoneId;
    }

    /**
     * The ID of the milestone this test run belongs to
     * 
     */
    public void setMilestoneId(java.lang.Long milestoneId) {
        this.milestoneId = milestoneId;
    }

    public TRRun withMilestoneId(java.lang.Long milestoneId) {
        this.milestoneId = milestoneId;
        return this;
    }

    /**
     * The name of the test run
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * The name of the test run
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    public TRRun withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * The amount of tests in the test run marked as passed
     * 
     */
    public java.lang.Long getPassedCount() {
        return passedCount;
    }

    /**
     * The amount of tests in the test run marked as passed
     * 
     */
    public void setPassedCount(java.lang.Long passedCount) {
        this.passedCount = passedCount;
    }

    public TRRun withPassedCount(java.lang.Long passedCount) {
        this.passedCount = passedCount;
        return this;
    }

    /**
     * The ID of the test plan this test run belongs to
     * 
     */
    public java.lang.Long getPlanId() {
        return planId;
    }

    /**
     * The ID of the test plan this test run belongs to
     * 
     */
    public void setPlanId(java.lang.Long planId) {
        this.planId = planId;
    }

    public TRRun withPlanId(java.lang.Long planId) {
        this.planId = planId;
        return this;
    }

    /**
     * The ID of the project this test run belongs to
     * 
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * The ID of the project this test run belongs to
     * 
     */
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }

    public TRRun withProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
        return this;
    }

    /**
     * The amount of tests in the test run marked as retest
     * 
     */
    public java.lang.Long getRetestCount() {
        return retestCount;
    }

    /**
     * The amount of tests in the test run marked as retest
     * 
     */
    public void setRetestCount(java.lang.Long retestCount) {
        this.retestCount = retestCount;
    }

    public TRRun withRetestCount(java.lang.Long retestCount) {
        this.retestCount = retestCount;
        return this;
    }

    /**
     * The ID of the test suite this test run is derived from
     * 
     */
    public java.lang.Long getSuiteId() {
        return suiteId;
    }

    /**
     * The ID of the test suite this test run is derived from
     * 
     */
    public void setSuiteId(java.lang.Long suiteId) {
        this.suiteId = suiteId;
    }

    public TRRun withSuiteId(java.lang.Long suiteId) {
        this.suiteId = suiteId;
        return this;
    }

    /**
     * The amount of tests in the test run marked as untested
     * 
     */
    public java.lang.Long getUntestedCount() {
        return untestedCount;
    }

    /**
     * The amount of tests in the test run marked as untested
     * 
     */
    public void setUntestedCount(java.lang.Long untestedCount) {
        this.untestedCount = untestedCount;
    }

    public TRRun withUntestedCount(java.lang.Long untestedCount) {
        this.untestedCount = untestedCount;
        return this;
    }

    /**
     * The address/URL of the test run in the user interface
     * 
     */
    public String getUrl() {
        return url;
    }

    /**
     * The address/URL of the test run in the user interface
     * 
     */
    public void setUrl(String url) {
        this.url = url;
    }

    public TRRun withUrl(String url) {
        this.url = url;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("assignedtoId", assignedtoId).append("blockedCount", blockedCount).append("completedOn", completedOn).append("config", config).append("entryId", entryId).append("entryIndex", entryIndex).append("configIds", configIds).append("caseIds", caseIds).append("createdBy", createdBy).append("createdOn", createdOn).append("customStatus1Count", customStatus1Count).append("customStatus2Count", customStatus2Count).append("customStatus3Count", customStatus3Count).append("customStatus4Count", customStatus4Count).append("customStatus5Count", customStatus5Count).append("customStatus6Count", customStatus6Count).append("customStatus7Count", customStatus7Count).append("customStatus8Count", customStatus8Count).append("customStatus9Count", customStatus9Count).append("description", description).append("failedCount", failedCount).append("id", id).append("includeAll", includeAll).append("isCompleted", isCompleted).append("milestoneId", milestoneId).append("name", name).append("passedCount", passedCount).append("planId", planId).append("projectId", projectId).append("retestCount", retestCount).append("suiteId", suiteId).append("untestedCount", untestedCount).append("url", url).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(customStatus7Count).append(blockedCount).append(customStatus4Count).append(milestoneId).append(description).append(includeAll).append(createdOn).append(entryId).append(customStatus2Count).append(untestedCount).append(configIds).append(customStatus3Count).append(passedCount).append(planId).append(customStatus9Count).append(id).append(customStatus6Count).append(isCompleted).append(entryIndex).append(suiteId).append(retestCount).append(url).append(customStatus5Count).append(failedCount).append(createdBy).append(assignedtoId).append(completedOn).append(customStatus8Count).append(name).append(caseIds).append(customStatus1Count).append(config).append(projectId).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRRun) == false) {
            return false;
        }
        TRRun rhs = ((TRRun) other);
        return new EqualsBuilder().append(customStatus7Count, rhs.customStatus7Count).append(blockedCount, rhs.blockedCount).append(customStatus4Count, rhs.customStatus4Count).append(milestoneId, rhs.milestoneId).append(description, rhs.description).append(includeAll, rhs.includeAll).append(createdOn, rhs.createdOn).append(entryId, rhs.entryId).append(customStatus2Count, rhs.customStatus2Count).append(untestedCount, rhs.untestedCount).append(configIds, rhs.configIds).append(customStatus3Count, rhs.customStatus3Count).append(passedCount, rhs.passedCount).append(planId, rhs.planId).append(customStatus9Count, rhs.customStatus9Count).append(id, rhs.id).append(customStatus6Count, rhs.customStatus6Count).append(isCompleted, rhs.isCompleted).append(entryIndex, rhs.entryIndex).append(suiteId, rhs.suiteId).append(retestCount, rhs.retestCount).append(url, rhs.url).append(customStatus5Count, rhs.customStatus5Count).append(failedCount, rhs.failedCount).append(createdBy, rhs.createdBy).append(assignedtoId, rhs.assignedtoId).append(completedOn, rhs.completedOn).append(customStatus8Count, rhs.customStatus8Count).append(name, rhs.name).append(caseIds, rhs.caseIds).append(customStatus1Count, rhs.customStatus1Count).append(config, rhs.config).append(projectId, rhs.projectId).isEquals();
    }

}
