
package org.touchbit.testrail4j.gson.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;


/**
 * The depth, display_order and parent fields determine the hierarchy of the sections in a test suite. The depth field is 0 for all sections on the root level and greater than 0 for all child sections. The depth field therefore resembles the level in the section hierarchy. Also see get_sections for an example.
 * 
 */
public class TRSection {

    /**
     * The description of the section (added with TestRail 4.0)
     * 
     */
    @SerializedName("description")
    @Expose
    private String description;
    /**
     * The ID of the section
     * 
     */
    @SerializedName("id")
    @Expose
    private Long id;
    /**
     * The ID of the test suite (ignored if the project is operating in single suite mode, required otherwise)
     * 
     */
    @SerializedName("suite_id")
    @Expose
    private Long suiteId;
    /**
     * The ID of the parent section (to build section hierarchies)
     * 
     */
    @SerializedName("parent_id")
    @Expose
    private Long parentId;
    /**
     * The name of the section (required)
     * (Required)
     * 
     */
    @SerializedName("name")
    @Expose
    private String name;
    /**
     * The level in the section hierarchy of the test suite
     * 
     */
    @SerializedName("depth")
    @Expose
    private Long depth;
    /**
     * The order in the test suite
     * 
     */
    @SerializedName("display_order")
    @Expose
    private Long displayOrder;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRSection() {
    }

    /**
     * 
     * @param suiteId
     * @param depth
     * @param name
     * @param displayOrder
     * @param description
     * @param id
     * @param parentId
     */
    public TRSection(String description, Long id, Long suiteId, Long parentId, String name, Long depth, Long displayOrder) {
        super();
        this.description = description;
        this.id = id;
        this.suiteId = suiteId;
        this.parentId = parentId;
        this.name = name;
        this.depth = depth;
        this.displayOrder = displayOrder;
    }

    /**
     * The description of the section (added with TestRail 4.0)
     * 
     */
    public String getDescription() {
        return description;
    }

    /**
     * The description of the section (added with TestRail 4.0)
     * 
     */
    public void setDescription(String description) {
        this.description = description;
    }

    public TRSection withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * The ID of the section
     * 
     */
    public Long getId() {
        return id;
    }

    /**
     * The ID of the section
     * 
     */
    public void setId(Long id) {
        this.id = id;
    }

    public TRSection withId(Long id) {
        this.id = id;
        return this;
    }

    /**
     * The ID of the test suite (ignored if the project is operating in single suite mode, required otherwise)
     * 
     */
    public Long getSuiteId() {
        return suiteId;
    }

    /**
     * The ID of the test suite (ignored if the project is operating in single suite mode, required otherwise)
     * 
     */
    public void setSuiteId(Long suiteId) {
        this.suiteId = suiteId;
    }

    public TRSection withSuiteId(Long suiteId) {
        this.suiteId = suiteId;
        return this;
    }

    /**
     * The ID of the parent section (to build section hierarchies)
     * 
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * The ID of the parent section (to build section hierarchies)
     * 
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public TRSection withParentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    /**
     * The name of the section (required)
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * The name of the section (required)
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    public TRSection withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * The level in the section hierarchy of the test suite
     * 
     */
    public Long getDepth() {
        return depth;
    }

    /**
     * The level in the section hierarchy of the test suite
     * 
     */
    public void setDepth(Long depth) {
        this.depth = depth;
    }

    public TRSection withDepth(Long depth) {
        this.depth = depth;
        return this;
    }

    /**
     * The order in the test suite
     * 
     */
    public Long getDisplayOrder() {
        return displayOrder;
    }

    /**
     * The order in the test suite
     * 
     */
    public void setDisplayOrder(Long displayOrder) {
        this.displayOrder = displayOrder;
    }

    public TRSection withDisplayOrder(Long displayOrder) {
        this.displayOrder = displayOrder;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("description", description).append("id", id).append("suiteId", suiteId).append("parentId", parentId).append("name", name).append("depth", depth).append("displayOrder", displayOrder).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(suiteId).append(depth).append(name).append(displayOrder).append(description).append(id).append(parentId).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRSection) == false) {
            return false;
        }
        TRSection rhs = ((TRSection) other);
        return new EqualsBuilder().append(suiteId, rhs.suiteId).append(depth, rhs.depth).append(name, rhs.name).append(displayOrder, rhs.displayOrder).append(description, rhs.description).append(id, rhs.id).append(parentId, rhs.parentId).isEquals();
    }

}
