
package org.touchbit.testrail4j.gson.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TRStatus {

    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("color_bright")
    @Expose
    private Long colorBright;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("color_dark")
    @Expose
    private Long colorDark;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("color_medium")
    @Expose
    private Long colorMedium;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("id")
    @Expose
    private Long id;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("is_final")
    @Expose
    private Boolean isFinal;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("is_system")
    @Expose
    private Boolean isSystem;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("is_untested")
    @Expose
    private Boolean isUntested;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("label")
    @Expose
    private String label;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("name")
    @Expose
    private String name;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TRStatus() {
    }

    /**
     * 
     * @param isSystem
     * @param colorDark
     * @param isUntested
     * @param colorBright
     * @param name
     * @param id
     * @param isFinal
     * @param label
     * @param colorMedium
     */
    public TRStatus(Long colorBright, Long colorDark, Long colorMedium, Long id, Boolean isFinal, Boolean isSystem, Boolean isUntested, String label, String name) {
        super();
        this.colorBright = colorBright;
        this.colorDark = colorDark;
        this.colorMedium = colorMedium;
        this.id = id;
        this.isFinal = isFinal;
        this.isSystem = isSystem;
        this.isUntested = isUntested;
        this.label = label;
        this.name = name;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Long getColorBright() {
        return colorBright;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setColorBright(Long colorBright) {
        this.colorBright = colorBright;
    }

    public TRStatus withColorBright(Long colorBright) {
        this.colorBright = colorBright;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Long getColorDark() {
        return colorDark;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setColorDark(Long colorDark) {
        this.colorDark = colorDark;
    }

    public TRStatus withColorDark(Long colorDark) {
        this.colorDark = colorDark;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Long getColorMedium() {
        return colorMedium;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setColorMedium(Long colorMedium) {
        this.colorMedium = colorMedium;
    }

    public TRStatus withColorMedium(Long colorMedium) {
        this.colorMedium = colorMedium;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Long getId() {
        return id;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setId(Long id) {
        this.id = id;
    }

    public TRStatus withId(Long id) {
        this.id = id;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Boolean getIsFinal() {
        return isFinal;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setIsFinal(Boolean isFinal) {
        this.isFinal = isFinal;
    }

    public TRStatus withIsFinal(Boolean isFinal) {
        this.isFinal = isFinal;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Boolean getIsSystem() {
        return isSystem;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setIsSystem(Boolean isSystem) {
        this.isSystem = isSystem;
    }

    public TRStatus withIsSystem(Boolean isSystem) {
        this.isSystem = isSystem;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Boolean getIsUntested() {
        return isUntested;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setIsUntested(Boolean isUntested) {
        this.isUntested = isUntested;
    }

    public TRStatus withIsUntested(Boolean isUntested) {
        this.isUntested = isUntested;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getLabel() {
        return label;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setLabel(String label) {
        this.label = label;
    }

    public TRStatus withLabel(String label) {
        this.label = label;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    public TRStatus withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("colorBright", colorBright).append("colorDark", colorDark).append("colorMedium", colorMedium).append("id", id).append("isFinal", isFinal).append("isSystem", isSystem).append("isUntested", isUntested).append("label", label).append("name", name).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(isSystem).append(colorDark).append(isUntested).append(colorBright).append(name).append(id).append(isFinal).append(label).append(colorMedium).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TRStatus) == false) {
            return false;
        }
        TRStatus rhs = ((TRStatus) other);
        return new EqualsBuilder().append(isSystem, rhs.isSystem).append(colorDark, rhs.colorDark).append(isUntested, rhs.isUntested).append(colorBright, rhs.colorBright).append(name, rhs.name).append(id, rhs.id).append(isFinal, rhs.isFinal).append(label, rhs.label).append(colorMedium, rhs.colorMedium).isEquals();
    }

}
